/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.code.disk.adapters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class DataAdapterHelper {
    public static void writeNullableUTF(DataOutput out, @Nullable String str) throws IOException {
        if (str == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(str);
        }
    }

    @Nullable
    public static String readNullableUTF(DataInput in4) throws IOException {
        if (in4.readByte() == 0) {
            return null;
        }
        return in4.readUTF();
    }

    public static void writeUVInt(DataOutput out, int val) throws IOException {
        if (val < 0) {
            throw new IllegalArgumentException("Expect value >= 0, got: " + val);
        }
        int current = val;
        int next = val;
        while (true) {
            if ((next >>>= 7) == 0) {
                out.writeByte(current & 0x7F);
                return;
            }
            out.writeByte(current & 0x7F | 0x80);
            current = next;
        }
    }

    public static int readUVInt(DataInput in4) throws IOException {
        byte v15;
        int result = 0;
        int shift = 0;
        do {
            v15 = in4.readByte();
            result |= (v15 & 0x7F) << shift;
            shift += 7;
        } while ((v15 & 0x80) == 128);
        return result;
    }
}

