/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class ListUtils {
    public static <T> boolean isSingleElement(@Nullable List<T> list2, T obj) {
        if (list2 == null || list2.size() != 1) {
            return false;
        }
        return Objects.equals(list2.get(0), obj);
    }

    public static <T> boolean unorderedEquals(List<T> first, List<T> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return first.containsAll(second);
    }

    public static <T, U> boolean orderedEquals(List<T> list1, List<U> list2, BiPredicate<T, U> comparer) {
        if (list1 == list2) {
            return true;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<T> iter1 = list1.iterator();
        Iterator<U> iter2 = list2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            U item2;
            T item1 = iter1.next();
            if (comparer.test(item1, item2 = iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public static <T, R> List<R> map(Collection<T> list2, Function<T, R> mapFunc) {
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>(list2.size());
        for (T t15 : list2) {
            result.add(mapFunc.apply(t15));
        }
        return result;
    }

    public static <T> T first(List<T> list2) {
        return list2.get(0);
    }

    @Nullable
    public static <T> T last(List<T> list2) {
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return list2.get(list2.size() - 1);
    }

    @Nullable
    public static <T> T removeLast(List<T> list2) {
        int size = list2.size();
        if (size == 0) {
            return null;
        }
        return list2.remove(size - 1);
    }

    public static <T extends Comparable<T>> List<T> distinctMergeSortedLists(List<T> first, List<T> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        TreeSet<T> set = new TreeSet<T>(first);
        set.addAll(second);
        return new ArrayList<T>(set);
    }

    public static <T> List<T> distinctList(List<T> list2) {
        return new ArrayList<T>(new LinkedHashSet<T>(list2));
    }

    public static <T> List<T> concat(T first, T[] values2) {
        ArrayList<T> list2 = new ArrayList<T>(1 + values2.length);
        list2.add(first);
        list2.addAll(Arrays.asList(values2));
        return list2;
    }

    public static <T> List<T> safeReplace(List<T> list2, T oldObj, T newObj) {
        if (list2 == null || list2.isEmpty()) {
            ArrayList<T> newList = new ArrayList<T>(1);
            newList.add(newObj);
            return newList;
        }
        int idx = list2.indexOf(oldObj);
        if (idx != -1) {
            list2.set(idx, newObj);
        } else {
            list2.add(newObj);
        }
        return list2;
    }

    public static <T> void safeRemove(List<T> list2, T obj) {
        if (list2 != null && !list2.isEmpty()) {
            list2.remove(obj);
        }
    }

    public static <T> List<T> safeRemoveAndTrim(List<T> list2, T obj) {
        if (list2 == null || list2.isEmpty()) {
            return list2;
        }
        if (list2.remove(obj) && list2.isEmpty()) {
            return Collections.emptyList();
        }
        return list2;
    }

    public static <T> List<T> safeAdd(List<T> list2, T obj) {
        if (list2 == null || list2.isEmpty()) {
            ArrayList<T> newList = new ArrayList<T>(1);
            newList.add(obj);
            return newList;
        }
        list2.add(obj);
        return list2;
    }

    public static <T> List<T> filter(Collection<T> list2, Predicate<T> filter) {
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : list2) {
            if (!filter.test(element)) continue;
            result.add(element);
        }
        return result;
    }

    @Nullable
    public static <T> T filterOnlyOne(List<T> list2, Predicate<T> filter) {
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        T found = null;
        for (T element : list2) {
            if (!filter.test(element)) continue;
            if (found != null) {
                return null;
            }
            found = element;
        }
        return found;
    }

    public static <T> boolean allMatch(Collection<T> list2, Predicate<T> test) {
        if (list2 == null || list2.isEmpty()) {
            return false;
        }
        for (T element : list2) {
            if (test.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean noneMatch(Collection<T> list2, Predicate<T> test) {
        return !ListUtils.anyMatch(list2, test);
    }

    public static <T> boolean anyMatch(Collection<T> list2, Predicate<T> test) {
        if (list2 == null || list2.isEmpty()) {
            return false;
        }
        for (T element : list2) {
            if (!test.test(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> enumerationToList(Enumeration<T> enumeration) {
        if (enumeration == null || enumeration == Collections.emptyEnumeration()) {
            return Collections.emptyList();
        }
        ArrayList<T> list2 = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            list2.add(enumeration.nextElement());
        }
        return list2;
    }
}

