/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.usage;

import jadx.api.usage.IUsageInfoData;
import jadx.api.usage.IUsageInfoVisitor;
import jadx.core.clsp.ClspClass;
import jadx.core.clsp.ClspClassSource;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.usage.UseSet;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class UsageInfo
implements IUsageInfoData {
    private final RootNode root;
    private final UseSet<ClassNode, ClassNode> clsDeps = new UseSet();
    private final UseSet<ClassNode, ClassNode> clsUsage = new UseSet();
    private final UseSet<ClassNode, MethodNode> clsUseInMth = new UseSet();
    private final UseSet<FieldNode, MethodNode> fieldUsage = new UseSet();
    private final UseSet<MethodNode, MethodNode> mthUsage = new UseSet();

    public UsageInfo(RootNode root) {
        this.root = root;
    }

    @Override
    public void apply() {
        this.clsDeps.visit((cls, deps) -> cls.setDependencies(UsageInfo.sortedList(deps)));
        this.clsUsage.visit((cls, deps) -> cls.setUseIn(UsageInfo.sortedList(deps)));
        this.clsUseInMth.visit((cls, methods2) -> cls.setUseInMth(UsageInfo.sortedList(methods2)));
        this.fieldUsage.visit((field, methods2) -> field.setUseIn(UsageInfo.sortedList(methods2)));
        this.mthUsage.visit((mth, methods2) -> mth.setUseIn(UsageInfo.sortedList(methods2)));
    }

    @Override
    public void applyForClass(ClassNode cls) {
        cls.setDependencies(UsageInfo.sortedList(this.clsDeps.get(cls)));
        cls.setUseIn(UsageInfo.sortedList(this.clsUsage.get(cls)));
        cls.setUseInMth(UsageInfo.sortedList(this.clsUseInMth.get(cls)));
        for (FieldNode fld : cls.getFields()) {
            fld.setUseIn(UsageInfo.sortedList(this.fieldUsage.get(fld)));
        }
        for (MethodNode mth : cls.getMethods()) {
            mth.setUseIn(UsageInfo.sortedList(this.mthUsage.get(mth)));
        }
    }

    @Override
    public void visitUsageData(IUsageInfoVisitor visitor2) {
        this.clsDeps.visit((cls, deps) -> visitor2.visitClassDeps((ClassNode)cls, UsageInfo.sortedList(deps)));
        this.clsUsage.visit((cls, deps) -> visitor2.visitClassUsage((ClassNode)cls, UsageInfo.sortedList(deps)));
        this.clsUseInMth.visit((cls, methods2) -> visitor2.visitClassUseInMethods((ClassNode)cls, UsageInfo.sortedList(methods2)));
        this.fieldUsage.visit((field, methods2) -> visitor2.visitFieldsUsage((FieldNode)field, UsageInfo.sortedList(methods2)));
        this.mthUsage.visit((mth, methods2) -> visitor2.visitMethodsUsage((MethodNode)mth, UsageInfo.sortedList(methods2)));
        visitor2.visitComplete();
    }

    public void clsUse(ClassNode cls, ArgType useType) {
        this.processType(useType, depCls -> this.clsUse(cls, (ClassNode)depCls));
    }

    public void clsUse(MethodNode mth, ArgType useType) {
        this.processType(useType, depCls -> this.clsUse(mth, (ClassNode)depCls));
    }

    public void clsUse(ICodeNode node, ArgType useType) {
        Consumer<ClassNode> consumer;
        switch (node.getAnnType()) {
            case CLASS: {
                ClassNode cls = (ClassNode)node;
                consumer = depCls -> this.clsUse(cls, (ClassNode)depCls);
                break;
            }
            case METHOD: {
                MethodNode mth = (MethodNode)node;
                consumer = depCls -> this.clsUse(mth, (ClassNode)depCls);
                break;
            }
            case FIELD: {
                FieldNode fld = (FieldNode)node;
                ClassNode fldCls = fld.getParentClass();
                consumer = depCls -> this.clsUse(fldCls, (ClassNode)depCls);
                break;
            }
            default: {
                throw new JadxRuntimeException("Unexpected use type: " + String.valueOf((Object)node.getAnnType()));
            }
        }
        this.processType(useType, consumer);
    }

    public void clsUse(MethodNode mth, ClassNode useCls) {
        ClassNode parentClass = mth.getParentClass();
        this.clsUse(parentClass, useCls);
        if (parentClass != useCls) {
            this.clsUseInMth.add(useCls, mth);
        }
    }

    public void clsUse(ClassNode cls, ClassNode depCls) {
        ClassNode topParentClass = cls.getTopParentClass();
        this.clsDeps.add(topParentClass, depCls.getTopParentClass());
        this.clsUsage.add(depCls, cls);
        this.clsUsage.add(depCls, topParentClass);
    }

    public void methodUse(MethodNode mth, MethodNode useMth) {
        this.clsUse(mth, useMth.getParentClass());
        this.mthUsage.add(useMth, mth);
        this.clsUse(mth, useMth.getReturnType());
        useMth.getMethodInfo().getArgumentsTypes().forEach(argType -> this.clsUse(mth, (ArgType)argType));
    }

    public void fieldUse(MethodNode mth, FieldNode useFld) {
        this.clsUse(mth, useFld.getParentClass());
        this.fieldUsage.add(useFld, mth);
        this.clsUse(mth, useFld.getType());
    }

    public void fieldUse(ICodeNode node, FieldInfo useFld) {
        FieldNode fld = this.root.resolveField(useFld);
        if (fld == null) {
            return;
        }
        switch (node.getAnnType()) {
            case CLASS: {
                this.clsUse((ClassNode)node, fld.getParentClass());
                break;
            }
            case METHOD: {
                this.fieldUse((MethodNode)node, fld);
            }
        }
    }

    private void processType(ArgType type, Consumer<ClassNode> consumer) {
        if (type == null || type == ArgType.OBJECT) {
            return;
        }
        if (type.isArray()) {
            this.processType(type.getArrayRootElement(), consumer);
            return;
        }
        if (type.isObject()) {
            ArgType argType;
            List<ArgType> extendTypes;
            List<ArgType> genericTypes;
            ClassNode clsNode;
            ClspClass clsDetails = this.root.getClsp().getClsDetails(type);
            if (clsDetails != null && clsDetails.getSource() == ClspClassSource.APACHE_HTTP_LEGACY_CLIENT) {
                this.root.getGradleInfoStorage().setUseApacheHttpLegacy(true);
            }
            if ((clsNode = this.root.resolveClass(type)) != null) {
                consumer.accept(clsNode);
            }
            if (Utils.notEmpty(genericTypes = type.getGenericTypes())) {
                for (ArgType argType2 : genericTypes) {
                    this.processType(argType2, consumer);
                }
            }
            if (Utils.notEmpty(extendTypes = type.getExtendTypes())) {
                for (ArgType extendType : extendTypes) {
                    this.processType(extendType, consumer);
                }
            }
            if ((argType = type.getWildcardType()) != null) {
                this.processType(argType, consumer);
            }
        }
    }

    private static <T extends Comparable<T>> List<T> sortedList(Set<T> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list2 = new ArrayList<T>(nodes);
        Collections.sort(list2);
        return list2;
    }
}

