/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class TypeUpdateFlags {
    static final TypeUpdateFlags FLAGS_EMPTY = TypeUpdateFlags.build(new FlagsEnum[0]);
    static final TypeUpdateFlags FLAGS_WIDER = TypeUpdateFlags.build(FlagsEnum.ALLOW_WIDER);
    static final TypeUpdateFlags FLAGS_WIDER_IGNORE_SAME = TypeUpdateFlags.build(FlagsEnum.ALLOW_WIDER, FlagsEnum.IGNORE_SAME);
    static final TypeUpdateFlags FLAGS_APPLY_DEBUG = TypeUpdateFlags.build(FlagsEnum.ALLOW_WIDER, FlagsEnum.KEEP_GENERICS, FlagsEnum.IGNORE_UNKNOWN);
    private final Set<FlagsEnum> flags;

    private static TypeUpdateFlags build(FlagsEnum ... flags) {
        EnumSet<FlagsEnum> set = flags.length == 0 ? EnumSet.noneOf(FlagsEnum.class) : EnumSet.copyOf(List.of(flags));
        return new TypeUpdateFlags(set);
    }

    private TypeUpdateFlags(Set<FlagsEnum> flags) {
        this.flags = flags;
    }

    public boolean isAllowWider() {
        return this.flags.contains((Object)FlagsEnum.ALLOW_WIDER);
    }

    public boolean isIgnoreSame() {
        return this.flags.contains((Object)FlagsEnum.IGNORE_SAME);
    }

    public boolean isIgnoreUnknown() {
        return this.flags.contains((Object)FlagsEnum.IGNORE_UNKNOWN);
    }

    public boolean isKeepGenerics() {
        return this.flags.contains((Object)FlagsEnum.KEEP_GENERICS);
    }

    public String toString() {
        return this.flags.toString();
    }

    static enum FlagsEnum {
        ALLOW_WIDER,
        IGNORE_SAME,
        IGNORE_UNKNOWN,
        KEEP_GENERICS;

    }
}

