/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.rename;

import jadx.api.data.ICodeData;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.InitCodeVariables;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.debuginfo.DebugInfoApplyVisitor;
import jadx.core.utils.exceptions.JadxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="ApplyCodeRename", desc="Rename variables and other entities in methods", runAfter={InitCodeVariables.class, DebugInfoApplyVisitor.class})
public class CodeRenameVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(CodeRenameVisitor.class);
    private Map<String, List<ICodeRename>> clsRenamesMap;

    @Override
    public void init(RootNode root) throws JadxException {
        this.updateRenamesMap(root.getArgs().getCodeData());
        root.registerCodeDataUpdateListener(this::updateRenamesMap);
    }

    @Override
    public boolean visit(ClassNode cls) {
        List<ICodeRename> renames = this.getRenames(cls);
        if (!renames.isEmpty()) {
            CodeRenameVisitor.applyRenames(cls, renames);
        }
        cls.getInnerClasses().forEach(this::visit);
        return false;
    }

    private static void applyRenames(ClassNode cls, List<ICodeRename> renames) {
        for (ICodeRename rename : renames) {
            IJavaNodeRef nodeRef = rename.getNodeRef();
            if (nodeRef.getType() != IJavaNodeRef.RefType.METHOD) continue;
            MethodNode methodNode = cls.searchMethodByShortId(nodeRef.getShortId());
            if (methodNode == null) {
                LOG.warn("Method reference not found: {}", (Object)nodeRef);
                continue;
            }
            IJavaCodeRef codeRef = rename.getCodeRef();
            if (codeRef == null) continue;
            CodeRenameVisitor.processRename(methodNode, codeRef, rename);
        }
    }

    private static void processRename(MethodNode mth, IJavaCodeRef codeRef, ICodeRename rename) {
        switch (codeRef.getAttachType()) {
            case MTH_ARG: {
                List<RegisterArg> argRegs = mth.getArgRegs();
                int argNum = codeRef.getIndex();
                if (argNum < argRegs.size()) {
                    argRegs.get(argNum).getSVar().getCodeVar().setName(rename.getNewName());
                    break;
                }
                LOG.warn("Incorrect method arg ref {}, should be less than {}", (Object)argNum, (Object)argRegs.size());
                break;
            }
            case VAR: {
                int regNum = codeRef.getIndex() >> 16;
                int ssaVer = codeRef.getIndex() & 0xFFFF;
                for (SSAVar ssaVar : mth.getSVars()) {
                    if (ssaVar.getRegNum() != regNum || ssaVar.getVersion() != ssaVer) continue;
                    ssaVar.getCodeVar().setName(rename.getNewName());
                    return;
                }
                LOG.warn("Can't find variable ref by {}_{}", (Object)regNum, (Object)ssaVer);
                break;
            }
            default: {
                LOG.warn("Rename code ref type {} not yet supported", (Object)codeRef.getAttachType());
            }
        }
    }

    private List<ICodeRename> getRenames(ClassNode cls) {
        if (this.clsRenamesMap == null) {
            return Collections.emptyList();
        }
        List<ICodeRename> clsComments = this.clsRenamesMap.get(cls.getClassInfo().getRawName());
        if (clsComments == null) {
            return Collections.emptyList();
        }
        return clsComments;
    }

    private void updateRenamesMap(@Nullable ICodeData data) {
        this.clsRenamesMap = data == null ? Collections.emptyMap() : data.getRenames().stream().filter(r15 -> r15.getCodeRef() != null).collect(Collectors.groupingBy(r15 -> r15.getNodeRef().getDeclaringClass()));
    }
}

