/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.api.plugins.utils.Utils;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.TmpEdgeAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.dex.visitors.blocks.BlockProcessor;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.dex.visitors.blocks.DominatorTree;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.ListUtils;
import jadx.core.utils.blocks.BlockSet;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BlockExceptionHandler.class);

    public static boolean process(MethodNode mth) {
        if (mth.isNoExceptionHandlers()) {
            return false;
        }
        BlockProcessor.updateCleanSuccessors(mth);
        DominatorTree.computeDominanceFrontier(mth);
        BlockExceptionHandler.processCatchAttr(mth);
        BlockExceptionHandler.initExcHandlers(mth);
        List<TryCatchBlockAttr> tryBlocks = BlockExceptionHandler.prepareTryBlocks(mth);
        BlockExceptionHandler.connectExcHandlers(mth, tryBlocks);
        mth.addAttr(AType.TRY_BLOCKS_LIST, tryBlocks);
        mth.getBasicBlocks().forEach(BlockNode::updateCleanSuccessors);
        for (ExceptionHandler eh4 : mth.getExceptionHandlers()) {
            BlockExceptionHandler.removeMonitorExitFromExcHandler(mth, eh4);
        }
        BlockProcessor.removeMarkedBlocks(mth);
        BlockSet sorted2 = new BlockSet(mth);
        BlockUtils.visitDFS(mth, sorted2::add);
        BlockExceptionHandler.removeUnusedExcHandlers(mth, tryBlocks, sorted2);
        return true;
    }

    private static void connectExcHandlers(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        if (tryBlocks.isEmpty()) {
            return;
        }
        int limit = tryBlocks.size() * 3;
        int count = 0;
        ArrayDeque<TryCatchBlockAttr> queue = new ArrayDeque<TryCatchBlockAttr>(tryBlocks);
        while (!queue.isEmpty()) {
            TryCatchBlockAttr tryBlock = (TryCatchBlockAttr)queue.removeFirst();
            boolean complete = BlockExceptionHandler.wrapBlocksWithTryCatch(mth, tryBlock);
            if (!complete) {
                queue.addLast(tryBlock);
            }
            if (count++ <= limit) continue;
            throw new JadxRuntimeException("Try blocks wrapping queue limit reached! Please report as an issue!");
        }
    }

    private static void processCatchAttr(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                if (!insn.contains(AType.EXC_CATCH) || insn.canThrowException()) continue;
                insn.remove(AType.EXC_CATCH);
            }
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            CatchAttr commonCatchAttr = BlockExceptionHandler.getCommonCatchAttr(block);
            if (commonCatchAttr == null) continue;
            block.addAttr(commonCatchAttr);
            for (InsnNode insn : block.getInstructions()) {
                if (insn.contains(AFlag.TRY_ENTER)) {
                    block.add(AFlag.TRY_ENTER);
                }
                if (!insn.contains(AFlag.TRY_LEAVE)) continue;
                block.add(AFlag.TRY_LEAVE);
            }
        }
    }

    @Nullable
    private static CatchAttr getCommonCatchAttr(BlockNode block) {
        CatchAttr commonCatchAttr = null;
        for (InsnNode insn : block.getInstructions()) {
            CatchAttr catchAttr = insn.get(AType.EXC_CATCH);
            if (catchAttr == null) continue;
            if (commonCatchAttr == null) {
                commonCatchAttr = catchAttr;
                continue;
            }
            if (commonCatchAttr.equals(catchAttr)) continue;
            return null;
        }
        return commonCatchAttr;
    }

    private static void initExcHandlers(MethodNode mth) {
        List<BlockNode> blocks = mth.getBasicBlocks();
        int blocksCount = blocks.size();
        for (int i15 = 0; i15 < blocksCount; ++i15) {
            ExcHandlerAttr excHandlerAttr;
            BlockNode block = blocks.get(i15);
            InsnNode firstInsn = BlockUtils.getFirstInsn(block);
            if (firstInsn == null || (excHandlerAttr = firstInsn.get(AType.EXC_HANDLER)) == null) continue;
            firstInsn.remove(AType.EXC_HANDLER);
            BlockExceptionHandler.removeTmpConnection(block);
            ExceptionHandler excHandler = excHandlerAttr.getHandler();
            if (block.getPredecessors().isEmpty()) {
                excHandler.setHandlerBlock(block);
                block.addAttr(excHandlerAttr);
                excHandler.addBlock(block);
                BlockUtils.collectBlocksDominatedByWithExcHandlers(mth, block, block).forEach(excHandler::addBlock);
            } else {
                BlockNode emptyHandlerBlock = BlockSplitter.startNewBlock(mth, block.getStartOffset());
                emptyHandlerBlock.add(AFlag.SYNTHETIC);
                emptyHandlerBlock.addAttr(excHandlerAttr);
                BlockSplitter.connect(emptyHandlerBlock, block);
                excHandler.setHandlerBlock(emptyHandlerBlock);
                excHandler.addBlock(emptyHandlerBlock);
            }
            BlockExceptionHandler.fixMoveExceptionInsn(block, excHandlerAttr);
        }
    }

    private static void removeTmpConnection(BlockNode block) {
        TmpEdgeAttr tmpEdgeAttr = block.get(AType.TMP_EDGE);
        if (tmpEdgeAttr != null) {
            BlockSplitter.removeConnection(tmpEdgeAttr.getBlock(), block);
            block.remove(AType.TMP_EDGE);
        }
    }

    private static List<TryCatchBlockAttr> prepareTryBlocks(MethodNode mth) {
        HashMap<ExceptionHandler, List> blocksByHandler = new HashMap<ExceptionHandler, List>();
        for (BlockNode block : mth.getBasicBlocks()) {
            CatchAttr catchAttr = block.get(AType.EXC_CATCH);
            if (catchAttr == null) continue;
            for (ExceptionHandler eh5 : catchAttr.getHandlers()) {
                blocksByHandler.computeIfAbsent(eh5, c15 -> new ArrayList()).add(block);
            }
        }
        if (blocksByHandler.isEmpty()) {
            mth.getExceptionHandlers().forEach(eh4 -> BlockExceptionHandler.removeExcHandler(mth, eh4));
        } else {
            blocksByHandler.forEach((eh4, blocks) -> {
                if (blocks.isEmpty()) {
                    BlockExceptionHandler.removeExcHandler(mth, eh4);
                }
            });
        }
        BlockSplitter.detachMarkedBlocks(mth);
        mth.clearExceptionHandlers();
        if (mth.isNoExceptionHandlers()) {
            return Collections.emptyList();
        }
        blocksByHandler.forEach((eh4, blocks) -> blocks.removeAll(eh4.getBlocks()));
        ArrayList<TryCatchBlockAttr> tryBlocks = new ArrayList<TryCatchBlockAttr>();
        blocksByHandler.forEach((eh4, blocks) -> {
            ArrayList<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>(1);
            handlers.add((ExceptionHandler)eh4);
            tryBlocks.add(new TryCatchBlockAttr(tryBlocks.size(), (List<ExceptionHandler>)handlers, (List<BlockNode>)blocks));
        });
        if (tryBlocks.size() > 1) {
            boolean restart;
            while (restart = BlockExceptionHandler.combineTryCatchBlocks(tryBlocks)) {
            }
        }
        BlockExceptionHandler.checkForMultiCatch(mth, tryBlocks);
        BlockExceptionHandler.clearTryBlocks(mth, tryBlocks);
        BlockExceptionHandler.sortHandlers(mth, tryBlocks);
        return tryBlocks;
    }

    private static void clearTryBlocks(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        tryBlocks.forEach(tc5 -> tc5.getBlocks().removeIf(b15 -> b15.contains(AFlag.REMOVE)));
        tryBlocks.removeIf(tb5 -> tb5.getBlocks().isEmpty() || tb5.getHandlers().isEmpty());
        mth.clearExceptionHandlers();
        BlockSplitter.detachMarkedBlocks(mth);
    }

    private static boolean combineTryCatchBlocks(List<TryCatchBlockAttr> tryBlocks) {
        for (TryCatchBlockAttr outerTryBlock : tryBlocks) {
            for (TryCatchBlockAttr innerTryBlock : tryBlocks) {
                if (outerTryBlock == innerTryBlock || innerTryBlock.getOuterTryBlock() != null || !BlockExceptionHandler.checkTryCatchRelation(tryBlocks, outerTryBlock, innerTryBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkTryCatchRelation(List<TryCatchBlockAttr> tryBlocks, TryCatchBlockAttr outerTryBlock, TryCatchBlockAttr innerTryBlock) {
        if (outerTryBlock.getBlocks().equals(innerTryBlock.getBlocks())) {
            List<ExceptionHandler> handlers = Utils.concatDistinct(outerTryBlock.getHandlers(), innerTryBlock.getHandlers());
            tryBlocks.add(new TryCatchBlockAttr(tryBlocks.size(), handlers, outerTryBlock.getBlocks()));
            tryBlocks.remove(outerTryBlock);
            tryBlocks.remove(innerTryBlock);
            return true;
        }
        Set handlerBlocks = innerTryBlock.getHandlers().stream().flatMap(eh4 -> eh4.getBlocks().stream()).collect(Collectors.toSet());
        boolean catchInHandler = handlerBlocks.stream().anyMatch(BlockExceptionHandler.isHandlersIntersects(outerTryBlock));
        boolean catchInTry = innerTryBlock.getBlocks().stream().anyMatch(BlockExceptionHandler.isHandlersIntersects(outerTryBlock));
        boolean blocksOutsideHandler = outerTryBlock.getBlocks().stream().anyMatch(b15 -> !handlerBlocks.contains(b15));
        if (catchInHandler && (catchInTry || blocksOutsideHandler)) {
            List<BlockNode> mergedBlocks = Utils.concatDistinct(outerTryBlock.getBlocks(), innerTryBlock.getBlocks());
            innerTryBlock.getHandlers().removeAll(outerTryBlock.getHandlers());
            innerTryBlock.setOuterTryBlock(outerTryBlock);
            outerTryBlock.addInnerTryBlock(innerTryBlock);
            outerTryBlock.setBlocks(mergedBlocks);
            return false;
        }
        HashSet<ExceptionHandler> innerHandlerSet = new HashSet<ExceptionHandler>(innerTryBlock.getHandlers());
        if (innerHandlerSet.containsAll(outerTryBlock.getHandlers())) {
            List<BlockNode> mergedBlocks = Utils.concatDistinct(outerTryBlock.getBlocks(), innerTryBlock.getBlocks());
            List<ExceptionHandler> handlers = Utils.concatDistinct(outerTryBlock.getHandlers(), innerTryBlock.getHandlers());
            tryBlocks.add(new TryCatchBlockAttr(tryBlocks.size(), handlers, mergedBlocks));
            tryBlocks.remove(outerTryBlock);
            tryBlocks.remove(innerTryBlock);
            return true;
        }
        return false;
    }

    @NotNull
    private static Predicate<BlockNode> isHandlersIntersects(TryCatchBlockAttr outerTryBlock) {
        return block -> {
            CatchAttr catchAttr = block.get(AType.EXC_CATCH);
            return catchAttr != null && Objects.equals(catchAttr.getHandlers(), outerTryBlock.getHandlers());
        };
    }

    private static void removeExcHandler(MethodNode mth, ExceptionHandler excHandler) {
        excHandler.markForRemove();
        BlockSplitter.removeConnection(mth.getEnterBlock(), excHandler.getHandlerBlock());
    }

    private static boolean wrapBlocksWithTryCatch(MethodNode mth, TryCatchBlockAttr tryCatchBlock) {
        BlockNode bottomSplitterBlock;
        BlockNode splitReturn;
        List<BlockNode> blocks = tryCatchBlock.getBlocks();
        BlockNode top = BlockExceptionHandler.searchTopBlock(mth, blocks);
        if (top.getPredecessors().isEmpty() && top != mth.getEnterBlock()) {
            return false;
        }
        BlockNode bottom = BlockExceptionHandler.searchBottomBlock(mth, blocks);
        if (bottom != null && bottom.isReturnBlock()) {
            splitReturn = bottom;
            bottom = BlockSplitter.blockSplitTop(mth, bottom);
            bottom.add(AFlag.SYNTHETIC);
        } else {
            splitReturn = null;
        }
        BlockNode topSplitterBlock = BlockExceptionHandler.getTopSplitterBlock(mth, top);
        topSplitterBlock.add(AFlag.EXC_TOP_SPLITTER);
        topSplitterBlock.add(AFlag.SYNTHETIC);
        int totalHandlerBlocks = tryCatchBlock.getHandlers().stream().mapToInt(eh4 -> eh4.getBlocks().size()).sum();
        if (bottom == null || totalHandlerBlocks == 0) {
            bottomSplitterBlock = null;
        } else {
            BlockNode existBottomSplitter = BlockUtils.getBlockWithFlag(bottom.getSuccessors(), AFlag.EXC_BOTTOM_SPLITTER);
            bottomSplitterBlock = existBottomSplitter != null ? existBottomSplitter : BlockSplitter.startNewBlock(mth, -1);
            bottomSplitterBlock.add(AFlag.EXC_BOTTOM_SPLITTER);
            bottomSplitterBlock.add(AFlag.SYNTHETIC);
            BlockSplitter.connect(bottom, bottomSplitterBlock);
            if (splitReturn != null) {
                BlockSet bottomPreds = BlockSet.from(mth, bottom.getPredecessors());
                for (ExceptionHandler handler : tryCatchBlock.getHandlers()) {
                    BlockNode lastBlock;
                    if (!bottomPreds.intersects(handler.getBlocks()) || (lastBlock = bottomPreds.intersect(handler.getBlocks()).getOne()) == null) continue;
                    BlockSplitter.replaceConnection(lastBlock, bottom, splitReturn);
                }
            }
        }
        BlockExceptionHandler.connectSplittersAndHandlers(tryCatchBlock, topSplitterBlock, bottomSplitterBlock);
        for (BlockNode block : blocks) {
            TryCatchBlockAttr currentTCBAttr = block.get(AType.TRY_BLOCK);
            if (currentTCBAttr != null && !currentTCBAttr.getInnerTryBlocks().contains(tryCatchBlock)) continue;
            block.addAttr(tryCatchBlock);
        }
        tryCatchBlock.setTopSplitter(topSplitterBlock);
        topSplitterBlock.updateCleanSuccessors();
        if (bottomSplitterBlock != null) {
            bottomSplitterBlock.updateCleanSuccessors();
        }
        return true;
    }

    private static BlockNode getTopSplitterBlock(MethodNode mth, BlockNode top) {
        BlockNode otherTopSplitter;
        if (top == mth.getEnterBlock()) {
            BlockNode fixedTop = mth.getEnterBlock().getSuccessors().get(0);
            return BlockSplitter.blockSplitTop(mth, fixedTop);
        }
        BlockNode existPredTopSplitter = BlockUtils.getBlockWithFlag(top.getPredecessors(), AFlag.EXC_TOP_SPLITTER);
        if (existPredTopSplitter != null) {
            return existPredTopSplitter;
        }
        if (top.getCleanSuccessors().size() == 1 && top.getInstructions().isEmpty() && (otherTopSplitter = BlockUtils.getBlockWithFlag(top.getCleanSuccessors(), AFlag.EXC_TOP_SPLITTER)) != null && otherTopSplitter.getPredecessors().size() == 1) {
            return otherTopSplitter;
        }
        return BlockSplitter.blockSplitTop(mth, top);
    }

    private static BlockNode searchTopBlock(MethodNode mth, List<BlockNode> blocks) {
        BlockNode top = BlockUtils.getTopBlock(blocks);
        if (top != null) {
            return BlockExceptionHandler.adjustTopBlock(top);
        }
        BlockNode topDom = BlockUtils.getCommonDominator(mth, blocks);
        if (topDom != null) {
            BlockNode upBlock;
            if (topDom.getSuccessors().size() == 1 && blocks.contains(upBlock = topDom.getSuccessors().get(0))) {
                return upBlock;
            }
            return BlockExceptionHandler.adjustTopBlock(topDom);
        }
        throw new JadxRuntimeException("Failed to find top block for try-catch from: " + String.valueOf(blocks));
    }

    private static BlockNode adjustTopBlock(BlockNode topBlock) {
        if (topBlock.getSuccessors().size() == 1 && !topBlock.contains(AType.EXC_CATCH)) {
            return topBlock.getSuccessors().get(0);
        }
        return topBlock;
    }

    @Nullable
    private static BlockNode searchBottomBlock(MethodNode mth, List<BlockNode> blocks) {
        BlockNode bottom = BlockUtils.getBottomBlock(blocks);
        if (bottom != null) {
            return bottom;
        }
        BlockNode pathCross = BlockUtils.getPathCross(mth, blocks);
        if (pathCross == null) {
            return null;
        }
        ArrayList<BlockNode> preds = new ArrayList<BlockNode>(pathCross.getPredecessors());
        preds.removeAll(blocks);
        List outsidePredecessors = preds.stream().filter(p15 -> !BlockUtils.atLeastOnePathExists(blocks, p15)).collect(Collectors.toList());
        if (outsidePredecessors.isEmpty()) {
            return pathCross;
        }
        BlockNode splitCross = BlockSplitter.blockSplitTop(mth, pathCross);
        splitCross.add(AFlag.SYNTHETIC);
        for (BlockNode outsidePredecessor : outsidePredecessors) {
            BlockSplitter.replaceConnection(outsidePredecessor, splitCross, pathCross);
        }
        return splitCross;
    }

    private static void connectSplittersAndHandlers(TryCatchBlockAttr tryCatchBlock, BlockNode topSplitterBlock, @Nullable BlockNode bottomSplitterBlock) {
        for (ExceptionHandler handler : tryCatchBlock.getHandlers()) {
            BlockNode handlerBlock = handler.getHandlerBlock();
            BlockSplitter.connect(topSplitterBlock, handlerBlock);
            if (bottomSplitterBlock == null) continue;
            BlockSplitter.connect(bottomSplitterBlock, handlerBlock);
        }
        TryCatchBlockAttr outerTryBlock = tryCatchBlock.getOuterTryBlock();
        if (outerTryBlock != null) {
            BlockExceptionHandler.connectSplittersAndHandlers(outerTryBlock, topSplitterBlock, bottomSplitterBlock);
        }
    }

    private static void fixMoveExceptionInsn(BlockNode block, ExcHandlerAttr excHandlerAttr) {
        ExceptionHandler excHandler = excHandlerAttr.getHandler();
        ArgType argType = excHandler.getArgType();
        InsnNode me5 = BlockUtils.getLastInsn(block);
        if (me5 != null && me5.getType() == InsnType.MOVE_EXCEPTION) {
            RegisterArg resArg = InsnArg.reg(me5.getResult().getRegNum(), argType);
            resArg.copyAttributesFrom(me5);
            me5.setResult(resArg);
            me5.add(AFlag.DONT_INLINE);
            resArg.add(AFlag.CUSTOM_DECLARE);
            excHandler.setArg(resArg);
            me5.addAttr(excHandlerAttr);
            return;
        }
        excHandler.setArg(new NamedArg("unused", argType));
    }

    private static void removeMonitorExitFromExcHandler(MethodNode mth, ExceptionHandler excHandler) {
        for (BlockNode excBlock : excHandler.getBlocks()) {
            InsnRemover remover = new InsnRemover(mth, excBlock);
            for (InsnNode insn : excBlock.getInstructions()) {
                if (insn.getType() == InsnType.MONITOR_ENTER) break;
                if (insn.getType() != InsnType.MONITOR_EXIT) continue;
                remover.addAndUnbind(insn);
            }
            remover.perform();
        }
    }

    private static void checkForMultiCatch(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        boolean merged = false;
        for (TryCatchBlockAttr tryBlock : tryBlocks) {
            if (!BlockExceptionHandler.mergeMultiCatch(mth, tryBlock)) continue;
            merged = true;
        }
        if (merged) {
            BlockSplitter.detachMarkedBlocks(mth);
            mth.clearExceptionHandlers();
        }
    }

    private static boolean mergeMultiCatch(MethodNode mth, TryCatchBlockAttr tryCatch) {
        if (tryCatch.getHandlers().size() < 2) {
            return false;
        }
        for (ExceptionHandler handler2 : tryCatch.getHandlers()) {
            if (handler2.getBlocks().size() != 1) {
                return false;
            }
            BlockNode block = handler2.getHandlerBlock();
            if (block.getInstructions().size() == 1 && BlockUtils.checkLastInsnType(block, InsnType.MOVE_EXCEPTION)) continue;
            return false;
        }
        List<BlockNode> handlerBlocks = ListUtils.map(tryCatch.getHandlers(), ExceptionHandler::getHandlerBlock);
        List successorBlocks = handlerBlocks.stream().flatMap(h15 -> h15.getSuccessors().stream()).distinct().collect(Collectors.toList());
        if (successorBlocks.size() != 1) {
            return false;
        }
        BlockNode successorBlock = (BlockNode)successorBlocks.get(0);
        if (!ListUtils.unorderedEquals(successorBlock.getPredecessors(), handlerBlocks)) {
            return false;
        }
        List regs = tryCatch.getHandlers().stream().map(h15 -> Objects.requireNonNull(BlockUtils.getLastInsn(h15.getHandlerBlock())).getResult()).distinct().collect(Collectors.toList());
        if (regs.size() != 1) {
            return false;
        }
        ExceptionHandler resultHandler = tryCatch.getHandlers().get(0);
        tryCatch.getHandlers().removeIf(handler -> {
            if (handler == resultHandler) {
                return false;
            }
            resultHandler.addCatchTypes(mth, handler.getCatchTypes());
            handler.markForRemove();
            return true;
        });
        return true;
    }

    private static void sortHandlers(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        TypeCompare typeCompare = mth.root().getTypeCompare();
        Comparator<ArgType> comparator = typeCompare.getReversedComparator();
        for (TryCatchBlockAttr tryBlock : tryBlocks) {
            for (ExceptionHandler handler : tryBlock.getHandlers()) {
                handler.getCatchTypes().sort((first, second) -> BlockExceptionHandler.compareByTypeAndName(comparator, first, second));
            }
            tryBlock.getHandlers().sort((first, second) -> {
                if (first.equals(second)) {
                    throw new JadxRuntimeException("Same handlers in try block: " + String.valueOf(tryBlock));
                }
                if (first.isCatchAll()) {
                    return 1;
                }
                if (second.isCatchAll()) {
                    return -1;
                }
                return BlockExceptionHandler.compareByTypeAndName(comparator, ListUtils.first(first.getCatchTypes()), ListUtils.first(second.getCatchTypes()));
            });
        }
    }

    private static int compareByTypeAndName(Comparator<ArgType> comparator, ClassInfo first, ClassInfo second) {
        int r15 = comparator.compare(first.getType(), second.getType());
        if (r15 == -2) {
            return first.compareTo(second);
        }
        return r15;
    }

    private static void removeUnusedExcHandlers(MethodNode mth, List<TryCatchBlockAttr> tryBlocks, BlockSet blocks) {
        for (ExceptionHandler eh4 : mth.getExceptionHandlers()) {
            boolean notProcessed = true;
            BlockNode handlerBlock = eh4.getHandlerBlock();
            if (handlerBlock == null || blocks.contains(handlerBlock)) continue;
            for (TryCatchBlockAttr tcb : tryBlocks) {
                if (!tcb.getHandlers().contains(eh4)) continue;
                notProcessed = false;
                break;
            }
            if (!notProcessed) continue;
            BlockProcessor.removeUnreachableBlock(handlerBlock, mth);
        }
    }

    private static /* synthetic */ void lambda$prepareTryBlocks$6(TryCatchBlockAttr tryBlock) {
        LOG.debug(" {}", (Object)tryBlock);
    }

    private static /* synthetic */ void lambda$prepareTryBlocks$1(ExceptionHandler eh4, List blocks) {
        LOG.debug(" {}, throw blocks: {}, handler blocks: {}", eh4, blocks, eh4.getBlocks());
    }
}

