/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.dex.visitors.typeinference.TypeInferenceVisitor;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="ShadowFieldVisitor", desc="Fix shadowed field access", runAfter={TypeInferenceVisitor.class}, runBefore={CodeShrinkVisitor.class})
public class ShadowFieldVisitor
extends AbstractVisitor {
    private Map<String, FieldFixInfo> fixInfoMap;

    @Override
    public void init(RootNode root) {
        HashMap<String, FieldFixInfo> map = new HashMap<String, FieldFixInfo>();
        for (ClassNode cls : root.getClasses(true)) {
            Map<FieldInfo, FieldFixType> fieldFixMap = ShadowFieldVisitor.searchShadowedFields(cls);
            if (fieldFixMap.isEmpty()) continue;
            FieldFixInfo fixInfo = new FieldFixInfo();
            fixInfo.fieldFixMap = fieldFixMap;
            map.put(cls.getRawName(), fixInfo);
        }
        this.fixInfoMap = map;
    }

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        ShadowFieldVisitor.fixShadowFieldAccess(mth, this.fixInfoMap);
    }

    private static Map<FieldInfo, FieldFixType> searchShadowedFields(ClassNode thisCls) {
        List<FieldNode> allFields = ShadowFieldVisitor.collectAllInstanceFields(thisCls);
        if (allFields.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, List<FieldNode>> mapByName = ShadowFieldVisitor.groupByName(allFields);
        mapByName.entrySet().removeIf(entry -> ((List)entry.getValue()).size() == 1);
        if (mapByName.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<FieldInfo, FieldFixType> fixMap = new HashMap<FieldInfo, FieldFixType>();
        for (List<FieldNode> fields2 : mapByName.values()) {
            boolean fromThisCls;
            boolean bl4 = fromThisCls = fields2.get(0).getParentClass() == thisCls;
            if (fromThisCls && fields2.size() == 2) {
                FieldNode otherField = fields2.get(1);
                if (otherField.getParentClass() == thisCls) continue;
                fixMap.put(otherField.getFieldInfo(), FieldFixType.SUPER);
                continue;
            }
            for (FieldNode field : fields2) {
                if (field.getParentClass() == thisCls) continue;
                fixMap.put(field.getFieldInfo(), FieldFixType.CAST);
            }
        }
        return fixMap;
    }

    private static Map<String, List<FieldNode>> groupByName(List<FieldNode> allFields) {
        HashMap<String, List<FieldNode>> groupByName = new HashMap<String, List<FieldNode>>(allFields.size());
        for (FieldNode field : allFields) {
            groupByName.computeIfAbsent(field.getName(), k15 -> new ArrayList()).add(field);
        }
        return groupByName;
    }

    private static List<FieldNode> collectAllInstanceFields(ClassNode cls) {
        ArrayList<FieldNode> fieldsList = new ArrayList<FieldNode>();
        HashSet<ClassNode> visited = new HashSet<ClassNode>();
        ClassNode currentClass = cls;
        while (currentClass != null) {
            if (!visited.add(currentClass)) {
                String msg = "Found 'super' loop in classes: " + String.valueOf(visited);
                visited.forEach(c15 -> c15.addWarnComment(msg));
                return fieldsList;
            }
            for (FieldNode field : currentClass.getFields()) {
                if (field.getAccessFlags().isStatic()) continue;
                fieldsList.add(field);
            }
            ArgType superClass = currentClass.getSuperClass();
            if (superClass == null) break;
            currentClass = cls.root().resolveClass(superClass);
        }
        return fieldsList;
    }

    private static void fixShadowFieldAccess(MethodNode mth, Map<String, FieldFixInfo> fixInfoMap) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                ShadowFieldVisitor.processInsn(mth, insn, fixInfoMap);
            }
        }
    }

    private static void processInsn(MethodNode mth, InsnNode insn, Map<String, FieldFixInfo> fixInfoMap) {
        FieldInfo fieldInfo = ShadowFieldVisitor.getFieldInfo(insn);
        if (fieldInfo == null) {
            return;
        }
        InsnArg arg = insn.getArg(insn.getArgsCount() - 1);
        ArgType type = arg.getType();
        if (!type.isTypeKnown() || !type.isObject()) {
            return;
        }
        FieldFixInfo fieldFixInfo = fixInfoMap.get(type.getObject());
        if (fieldFixInfo == null) {
            return;
        }
        FieldFixType fieldFixType = fieldFixInfo.fieldFixMap.get(fieldInfo);
        if (fieldFixType == null) {
            return;
        }
        ShadowFieldVisitor.fixFieldAccess(mth, fieldInfo, fieldFixType, arg);
    }

    @Nullable
    private static FieldInfo getFieldInfo(InsnNode insn) {
        switch (insn.getType()) {
            case IPUT: 
            case IGET: {
                return (FieldInfo)((IndexInsnNode)insn).getIndex();
            }
        }
        return null;
    }

    private static void fixFieldAccess(MethodNode mth, FieldInfo fieldInfo, FieldFixType fieldFixType, InsnArg arg) {
        if (fieldFixType == FieldFixType.SUPER && arg.isThis()) {
            arg.add(AFlag.SUPER);
            return;
        }
        IndexInsnNode castInsn = new IndexInsnNode(InsnType.CAST, fieldInfo.getDeclClass().getType(), 1);
        castInsn.addArg(arg.duplicate());
        castInsn.add(AFlag.SYNTHETIC);
        castInsn.add(AFlag.EXPLICIT_CAST);
        arg.wrapInstruction(mth, castInsn, false);
    }

    private static class FieldFixInfo {
        Map<FieldInfo, FieldFixType> fieldFixMap;

        private FieldFixInfo() {
        }
    }

    private static enum FieldFixType {
        SUPER,
        CAST;

    }
}

