/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.trycatch;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ExceptionHandler {
    private final List<ClassInfo> catchTypes = new ArrayList<ClassInfo>(1);
    private final int handlerOffset;
    private BlockNode handlerBlock;
    private final List<BlockNode> blocks = new ArrayList<BlockNode>();
    private IContainer handlerRegion;
    private InsnArg arg;
    private TryCatchBlockAttr tryBlock;
    private boolean isFinally;
    private boolean removed = false;

    public static ExceptionHandler build(MethodNode mth, int addr, @Nullable ClassInfo type) {
        ExceptionHandler eh4 = new ExceptionHandler(addr);
        eh4.addCatchType(mth, type);
        return eh4;
    }

    private ExceptionHandler(int addr) {
        this.handlerOffset = addr;
    }

    public boolean addCatchType(MethodNode mth, @Nullable ClassInfo type) {
        if (type != null) {
            if (this.catchTypes.contains(type)) {
                return false;
            }
            return this.catchTypes.add(type);
        }
        if (!this.catchTypes.isEmpty()) {
            mth.addDebugComment("Throwable added to exception handler: '" + this.catchTypeStr() + "', keep only Throwable");
            this.catchTypes.clear();
            return true;
        }
        return false;
    }

    public void addCatchTypes(MethodNode mth, Collection<ClassInfo> types) {
        for (ClassInfo type : types) {
            this.addCatchType(mth, type);
        }
    }

    public List<ClassInfo> getCatchTypes() {
        return this.catchTypes;
    }

    public ArgType getArgType() {
        if (this.isCatchAll()) {
            return ArgType.THROWABLE;
        }
        List<ClassInfo> types = this.getCatchTypes();
        if (types.size() == 1) {
            return types.iterator().next().getType();
        }
        return ArgType.THROWABLE;
    }

    public boolean isCatchAll() {
        if (this.catchTypes.isEmpty()) {
            return true;
        }
        for (ClassInfo classInfo : this.catchTypes) {
            if (!classInfo.getFullName().equals("java.lang.Throwable")) continue;
            return true;
        }
        return false;
    }

    public int getHandlerOffset() {
        return this.handlerOffset;
    }

    public BlockNode getHandlerBlock() {
        return this.handlerBlock;
    }

    public void setHandlerBlock(BlockNode handlerBlock) {
        this.handlerBlock = handlerBlock;
    }

    public List<BlockNode> getBlocks() {
        return this.blocks;
    }

    public void addBlock(BlockNode node) {
        this.blocks.add(node);
    }

    public IContainer getHandlerRegion() {
        return this.handlerRegion;
    }

    public void setHandlerRegion(IContainer handlerRegion) {
        this.handlerRegion = handlerRegion;
    }

    public InsnArg getArg() {
        return this.arg;
    }

    public void setArg(InsnArg arg) {
        this.arg = arg;
    }

    public void setTryBlock(TryCatchBlockAttr tryBlock) {
        this.tryBlock = tryBlock;
    }

    public TryCatchBlockAttr getTryBlock() {
        return this.tryBlock;
    }

    public boolean isFinally() {
        return this.isFinally;
    }

    public void setFinally(boolean isFinally) {
        this.isFinally = isFinally;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void markForRemove() {
        this.removed = true;
        this.blocks.forEach(b15 -> b15.add(AFlag.REMOVE));
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        ExceptionHandler that = (ExceptionHandler)o15;
        return this.handlerOffset == that.handlerOffset && this.catchTypes.equals(that.catchTypes) && Objects.equals(this.tryBlock, that.tryBlock);
    }

    public int hashCode() {
        return Objects.hash(this.catchTypes, this.handlerOffset);
    }

    public String catchTypeStr() {
        return this.catchTypes.isEmpty() ? "all" : Utils.listToString(this.catchTypes, " | ", ClassInfo::getShortName);
    }

    public String toString() {
        return this.catchTypeStr() + " -> " + InsnUtils.formatOffset(this.handlerOffset);
    }
}

