/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.DecompilationMode;
import jadx.api.ICodeCache;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.data.ICodeData;
import jadx.api.impl.passes.DecompilePassWrapper;
import jadx.api.impl.passes.PreparePassWrapper;
import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.pass.JadxPass;
import jadx.api.plugins.pass.types.JadxDecompilePass;
import jadx.api.plugins.pass.types.JadxPassType;
import jadx.api.plugins.pass.types.JadxPreparePass;
import jadx.core.Jadx;
import jadx.core.ProcessClass;
import jadx.core.clsp.ClspGraph;
import jadx.core.dex.attributes.AttributeStorage;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.InfoStorage;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.info.PackageInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeDataUpdateListener;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.utils.MethodUtils;
import jadx.core.dex.nodes.utils.SelectFromDuplicates;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.dex.visitors.typeinference.TypeUpdate;
import jadx.core.export.GradleInfoStorage;
import jadx.core.utils.CacheStorage;
import jadx.core.utils.DebugChecks;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.PassMerge;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.android.AndroidResourcesUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.IResTableParser;
import jadx.core.xmlgen.ManifestAttributes;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootNode {
    private static final Logger LOG = LoggerFactory.getLogger(RootNode.class);
    private final JadxArgs args;
    private final ErrorsCounter errorsCounter = new ErrorsCounter();
    private final StringUtils stringUtils;
    private final ConstStorage constValues;
    private final InfoStorage infoStorage = new InfoStorage();
    private final CacheStorage cacheStorage = new CacheStorage();
    private final TypeUpdate typeUpdate;
    private final MethodUtils methodUtils;
    private final TypeUtils typeUtils;
    private final AttributeStorage attributes = new AttributeStorage();
    private final List<ICodeDataUpdateListener> codeDataUpdateListeners = new ArrayList<ICodeDataUpdateListener>();
    private final GradleInfoStorage gradleInfoStorage = new GradleInfoStorage();
    private final Map<ClassInfo, ClassNode> clsMap = new HashMap<ClassInfo, ClassNode>();
    private final Map<String, ClassNode> rawClsMap = new HashMap<String, ClassNode>();
    private List<ClassNode> classes = new ArrayList<ClassNode>();
    private final Map<String, PackageNode> pkgMap = new HashMap<String, PackageNode>();
    private final List<PackageNode> packages = new ArrayList<PackageNode>();
    private List<IDexTreeVisitor> preDecompilePasses;
    private ProcessClass processClasses;
    private ClspGraph clsp;
    @Nullable
    private String appPackage;
    @Nullable
    private ClassNode appResClass;
    @Nullable
    private JadxDecompiler decompiler;
    @Nullable
    private ManifestAttributes manifestAttributes;

    public RootNode(JadxDecompiler decompiler) {
        this(decompiler, decompiler.getArgs());
    }

    @Deprecated
    public RootNode(JadxArgs args) {
        this(null, args);
    }

    private RootNode(@Nullable JadxDecompiler decompiler, JadxArgs args) {
        this.decompiler = decompiler;
        this.args = args;
        this.preDecompilePasses = Jadx.getPreDecompilePassesList();
        this.processClasses = new ProcessClass(Jadx.getPassesList(args));
        this.stringUtils = new StringUtils(args);
        this.constValues = new ConstStorage(args);
        this.typeUpdate = new TypeUpdate(this);
        this.methodUtils = new MethodUtils(this);
        this.typeUtils = new TypeUtils(this);
    }

    public void init() {
        if (this.args.isDeobfuscationOn() || !this.args.getRenameFlags().isEmpty()) {
            this.args.getAliasProvider().init(this);
        }
        if (this.args.isDeobfuscationOn()) {
            this.args.getRenameCondition().init(this);
        }
    }

    public void loadClasses(List<ICodeLoader> loadedInputs) {
        for (ICodeLoader codeLoader : loadedInputs) {
            codeLoader.visitClasses(cls -> {
                try {
                    this.addClassNode(new ClassNode(this, (IClassData)cls));
                }
                catch (Exception e15) {
                    this.addDummyClass((IClassData)cls, e15);
                }
                Utils.checkThreadInterrupt();
            });
        }
    }

    public void finishClassLoad() {
        if (this.classes.size() != this.clsMap.size()) {
            this.fixDuplicatedClasses();
        }
        this.classes = new ArrayList<ClassNode>(this.clsMap.values());
        int mthCount = this.classes.stream().mapToInt(c15 -> c15.getMethods().size()).sum();
        int insnsCount = this.classes.stream().flatMap(c15 -> c15.getMethods().stream()).mapToInt(MethodNode::getInsnsCount).sum();
        LOG.info("Loaded classes: {}, methods: {}, instructions: {}", this.classes.size(), mthCount, insnsCount);
        this.classes.sort(Comparator.comparing(ClassNode::getRawName));
        if (this.args.isMoveInnerClasses()) {
            this.initInnerClasses();
        }
        Collections.sort(this.packages);
    }

    private void addDummyClass(IClassData classData, Exception exc) {
        try {
            String typeStr = classData.getType();
            Object name = null;
            try {
                ClassInfo clsInfo = ClassInfo.fromName(this, typeStr);
                if (clsInfo != null) {
                    name = clsInfo.getShortName();
                }
            }
            catch (Exception e15) {
                LOG.error("Failed to get name for class with type {}", (Object)typeStr, (Object)e15);
            }
            if (name == null || ((String)name).isEmpty()) {
                name = "CLASS_" + typeStr;
            }
            ClassNode clsNode = ClassNode.addSyntheticClass(this, (String)name, classData.getAccessFlags());
            ErrorsCounter.error(clsNode, "Load error", exc);
        }
        catch (Exception innerExc) {
            LOG.error("Failed to load class from file: {}", (Object)classData.getInputFileName(), (Object)exc);
        }
    }

    private void fixDuplicatedClasses() {
        this.classes.stream().collect(Collectors.groupingBy(ClassNode::getClassInfo)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            ClassInfo clsInfo = (ClassInfo)entry.getKey();
            List dupClsList = (List)entry.getValue();
            ClassNode selectedCls = SelectFromDuplicates.process(dupClsList);
            this.clsMap.put(clsInfo, selectedCls);
            this.rawClsMap.put(selectedCls.getRawName(), selectedCls);
            String selectedSource = selectedCls.getInputFileName();
            String sources = dupClsList.stream().map(ClassNode::getInputFileName).sorted().collect(Collectors.joining("\n  "));
            LOG.warn("Found duplicated class: {}, count: {}, sources:\n  {}\n Keep class with source: {}, others will be removed.", clsInfo, dupClsList.size(), sources, selectedSource);
            selectedCls.addWarnComment("Classes with same name are omitted, all sources:\n  " + sources + "\n");
        });
    }

    public void addClassNode(ClassNode clsNode) {
        this.classes.add(clsNode);
        this.clsMap.put(clsNode.getClassInfo(), clsNode);
        this.rawClsMap.put(clsNode.getRawName(), clsNode);
    }

    public void loadResources(ResourcesLoader resLoader, List<ResourceFile> resources) {
        ResourceFile arsc = this.getResourceFile(resources);
        if (arsc == null) {
            LOG.debug("'resources.arsc' or 'resources.pb' file not found");
            return;
        }
        try {
            IResTableParser parser = ResourcesLoader.decodeStream(arsc, (size, is4) -> resLoader.decodeTable(arsc, is4));
            if (parser != null) {
                this.processResources(parser.getResStorage());
                this.updateObfuscatedFiles(parser, resources);
                this.initManifestAttributes().updateAttributes(parser);
            }
        }
        catch (Exception e15) {
            LOG.error("Failed to parse 'resources.pb'/'.arsc' file", e15);
        }
    }

    @Nullable
    private ResourceFile getResourceFile(List<ResourceFile> resources) {
        for (ResourceFile rf5 : resources) {
            if (rf5.getType() != ResourceType.ARSC) continue;
            return rf5;
        }
        return null;
    }

    public void processResources(ResourceStorage resStorage) {
        this.constValues.setResourcesNames(resStorage.getResourcesNames());
        this.appPackage = resStorage.getAppPackage();
        this.appResClass = AndroidResourcesUtils.searchAppResClass(this, resStorage);
    }

    public void initClassPath() {
        try {
            if (this.clsp == null) {
                ClspGraph newClsp = new ClspGraph(this);
                if (this.args.isLoadJadxClsSetFile()) {
                    newClsp.loadClsSetFile();
                }
                newClsp.addApp(this.classes);
                newClsp.initCache();
                this.clsp = newClsp;
            }
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Error loading jadx class set", e15);
        }
    }

    private void updateObfuscatedFiles(IResTableParser parser, List<ResourceFile> resources) {
        if (this.args.isSkipResources()) {
            return;
        }
        boolean useHeaders = this.args.isUseHeadersForDetectResourceExtensions();
        long start = System.currentTimeMillis();
        int renamedCount = 0;
        ResourceStorage resStorage = parser.getResStorage();
        ValuesParser valuesParser = new ValuesParser(parser.getStrings(), resStorage.getResourcesNames());
        HashMap<String, ResourceEntry> entryNames = new HashMap<String, ResourceEntry>();
        for (ResourceEntry resEntry : resStorage.getResources()) {
            String val = valuesParser.getSimpleValueString(resEntry);
            if (val == null) continue;
            entryNames.put(val, resEntry);
        }
        for (ResourceFile resource : resources) {
            ResourceEntry resEntry = (ResourceEntry)entryNames.get(resource.getOriginalName());
            if (resEntry == null || !resource.setAlias(resEntry, useHeaders)) continue;
            ++renamedCount;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Renamed obfuscated resources: {}, duration: {}ms", (Object)renamedCount, (Object)(System.currentTimeMillis() - start));
        }
    }

    private void initInnerClasses() {
        ArrayList<ClassNode> inner = new ArrayList<ClassNode>();
        for (ClassNode cls2 : this.classes) {
            if (!cls2.getClassInfo().isInner()) continue;
            inner.add(cls2);
        }
        ArrayList<ClassNode> updated = new ArrayList<ClassNode>();
        for (ClassNode cls3 : inner) {
            ClassInfo clsInfo = cls3.getClassInfo();
            ClassNode parent = this.resolveParentClass(clsInfo);
            if (parent == null) {
                updated.add(cls3);
                cls3.notInner();
                continue;
            }
            parent.addInnerClass(cls3);
        }
        for (ClassNode updCls : updated) {
            for (ClassNode innerCls : updCls.getInnerClasses()) {
                innerCls.getClassInfo().updateNames(this);
            }
        }
        for (PackageNode pkg : this.packages) {
            pkg.getClasses().removeIf(cls -> cls.getClassInfo().isInner());
        }
    }

    public void mergePasses(Map<JadxPassType, List<JadxPass>> customPasses) {
        List<String> disabledPasses;
        DecompilationMode mode = this.args.getDecompilationMode();
        if (mode == DecompilationMode.FALLBACK || mode == DecompilationMode.SIMPLE) {
            return;
        }
        new PassMerge(this.preDecompilePasses).merge(customPasses.get(JadxPreparePass.TYPE), p15 -> new PreparePassWrapper((JadxPreparePass)p15));
        new PassMerge(this.processClasses.getPasses()).merge(customPasses.get(JadxDecompilePass.TYPE), p15 -> new DecompilePassWrapper((JadxDecompilePass)p15));
        if (this.args.isRunDebugChecks()) {
            this.preDecompilePasses = DebugChecks.insertPasses(this.preDecompilePasses);
            this.processClasses = new ProcessClass(DebugChecks.insertPasses(this.processClasses.getPasses()));
        }
        if (!(disabledPasses = this.args.getDisabledPasses()).isEmpty()) {
            HashSet<String> disabledSet = new HashSet<String>(disabledPasses);
            Predicate<IDexTreeVisitor> filter = p15 -> {
                if (disabledSet.contains(p15.getName())) {
                    LOG.debug("Disable pass: {}", (Object)p15.getName());
                    return true;
                }
                return false;
            };
            this.preDecompilePasses.removeIf(filter);
            this.processClasses.getPasses().removeIf(filter);
        }
    }

    public void runPreDecompileStage() {
        boolean debugEnabled = LOG.isDebugEnabled();
        for (IDexTreeVisitor pass : this.preDecompilePasses) {
            Utils.checkThreadInterrupt();
            long start = debugEnabled ? System.currentTimeMillis() : 0L;
            try {
                pass.init(this);
            }
            catch (Exception e15) {
                LOG.error("Visitor init failed: {}", (Object)pass.getClass().getSimpleName(), (Object)e15);
            }
            for (ClassNode cls : this.classes) {
                if (cls.isInner()) continue;
                DepthTraversal.visit(pass, cls);
            }
            if (!debugEnabled) continue;
            LOG.debug("Prepare pass: '{}' - {}ms", (Object)pass, (Object)(System.currentTimeMillis() - start));
        }
    }

    public void runPreDecompileStageForClass(ClassNode cls) {
        for (IDexTreeVisitor pass : this.preDecompilePasses) {
            DepthTraversal.visit(pass, cls);
        }
    }

    public void resetPasses() {
        this.preDecompilePasses.clear();
        this.preDecompilePasses.addAll(Jadx.getPreDecompilePassesList());
        this.processClasses.getPasses().clear();
        this.processClasses.getPasses().addAll(Jadx.getPassesList(this.args));
    }

    public void restartVisitors() {
        for (ClassNode cls : this.classes) {
            cls.unload();
            cls.clearAttributes();
            cls.unloadFromCache();
        }
        this.runPreDecompileStage();
    }

    public List<ClassNode> getClasses() {
        return this.classes;
    }

    public List<ClassNode> getClassesWithoutInner() {
        return this.getClasses(false);
    }

    public List<ClassNode> getClasses(boolean includeInner) {
        if (includeInner) {
            return this.classes;
        }
        ArrayList<ClassNode> notInnerClasses = new ArrayList<ClassNode>();
        for (ClassNode cls : this.classes) {
            if (cls.getClassInfo().isInner()) continue;
            notInnerClasses.add(cls);
        }
        return notInnerClasses;
    }

    public List<PackageNode> getPackages() {
        return this.packages;
    }

    @Nullable
    public PackageNode resolvePackage(String fullPkg) {
        return this.pkgMap.get(fullPkg);
    }

    @Nullable
    public PackageNode resolvePackage(@Nullable PackageInfo pkgInfo) {
        return pkgInfo == null ? null : this.pkgMap.get(pkgInfo.getFullName());
    }

    public void addPackage(PackageNode pkg) {
        this.pkgMap.put(pkg.getPkgInfo().getFullName(), pkg);
        this.packages.add(pkg);
    }

    public void removePackage(PackageNode pkg) {
        if (this.pkgMap.remove(pkg.getPkgInfo().getFullName()) != null) {
            this.packages.remove(pkg);
            PackageNode parentPkg = pkg.getParentPkg();
            if (parentPkg != null) {
                parentPkg.getSubPackages().remove(pkg);
                if (parentPkg.isEmpty()) {
                    this.removePackage(parentPkg);
                }
            }
            for (PackageNode subPkg : pkg.getSubPackages()) {
                this.removePackage(subPkg);
            }
        }
    }

    public void sortPackages() {
        Collections.sort(this.packages);
    }

    public void removeClsFromPackage(PackageNode pkg, ClassNode cls) {
        boolean removed = pkg.getClasses().remove(cls);
        if (removed && pkg.isEmpty()) {
            this.removePackage(pkg);
        }
    }

    public void runPackagesUpdate() {
        for (PackageNode pkg : this.getPackages()) {
            if (!pkg.isRoot()) continue;
            pkg.updatePackages();
        }
    }

    @Nullable
    public ClassNode resolveClass(ClassInfo clsInfo) {
        return this.clsMap.get(clsInfo);
    }

    @Nullable
    public ClassNode resolveClass(ArgType clsType) {
        if (!clsType.isTypeKnown() || clsType.isGenericType()) {
            return null;
        }
        if (clsType.getWildcardBound() == ArgType.WildcardBound.UNBOUND) {
            return null;
        }
        if (clsType.isGeneric()) {
            clsType = ArgType.object(clsType.getObject());
        }
        return this.resolveClass(ClassInfo.fromType(this, clsType));
    }

    @Nullable
    public ClassNode resolveClass(String fullName) {
        ClassInfo clsInfo = ClassInfo.fromName(this, fullName);
        return this.resolveClass(clsInfo);
    }

    @Nullable
    public ClassNode resolveRawClass(String rawFullName) {
        return this.rawClsMap.get(rawFullName);
    }

    @Nullable
    public ClassNode resolveParentClass(ClassInfo clsInfo) {
        String parClsName;
        int sep;
        ClassInfo parentInfo = clsInfo.getParentClass();
        ClassNode parentNode = this.resolveClass(parentInfo);
        if (parentNode == null && parentInfo != null && (sep = (parClsName = parentInfo.getFullName()).lastIndexOf(46)) > 0 && sep != parClsName.length() - 1) {
            String mthName = parClsName.substring(sep + 1);
            String upperParClsName = parClsName.substring(0, sep);
            ClassNode tmpParent = this.resolveClass(upperParClsName);
            if (tmpParent != null && tmpParent.searchMethodByShortName(mthName) != null) {
                parentNode = tmpParent;
                clsInfo.convertToInner(parentNode);
            }
        }
        return parentNode;
    }

    @Nullable
    public ClassNode searchClassByFullAlias(String fullName) {
        for (ClassNode cls : this.classes) {
            ClassInfo classInfo = cls.getClassInfo();
            if (!classInfo.getFullName().equals(fullName) && !classInfo.getAliasFullName().equals(fullName)) continue;
            return cls;
        }
        return null;
    }

    public Map<String, ClassNode> buildFullAliasClassCache() {
        HashMap<String, ClassNode> classNameCache = new HashMap<String, ClassNode>(this.classes.size());
        for (ClassNode cls : this.classes) {
            ClassInfo classInfo = cls.getClassInfo();
            String fullName = classInfo.getFullName();
            String alias = classInfo.getAliasFullName();
            classNameCache.put(fullName, cls);
            if (alias == null || fullName.equals(alias)) continue;
            classNameCache.put(alias, cls);
        }
        return classNameCache;
    }

    public List<ClassNode> searchClassByShortName(String shortName) {
        ArrayList<ClassNode> list2 = new ArrayList<ClassNode>();
        for (ClassNode cls : this.classes) {
            if (!cls.getClassInfo().getShortName().equals(shortName)) continue;
            list2.add(cls);
        }
        return list2;
    }

    @Nullable
    public MethodNode resolveMethod(@NotNull MethodInfo mth) {
        ClassNode cls = this.resolveClass(mth.getDeclClass());
        if (cls == null) {
            return null;
        }
        MethodNode methodNode = cls.searchMethod(mth);
        if (methodNode != null) {
            return methodNode;
        }
        return this.deepResolveMethod(cls, mth.makeSignature(false));
    }

    @NotNull
    public MethodNode resolveDirectMethod(String rawClsName, String mthShortId) {
        ClassNode clsNode = this.resolveRawClass(rawClsName);
        if (clsNode == null) {
            throw new RuntimeException("Class not found: " + rawClsName);
        }
        MethodNode methodNode = clsNode.searchMethodByShortId(mthShortId);
        if (methodNode == null) {
            throw new RuntimeException("Method not found: " + rawClsName + "." + mthShortId);
        }
        return methodNode;
    }

    @Nullable
    private MethodNode deepResolveMethod(@NotNull ClassNode cls, String signature) {
        MethodNode found;
        ClassNode superNode;
        for (MethodNode m15 : cls.getMethods()) {
            if (!m15.getMethodInfo().getShortId().startsWith(signature)) continue;
            return m15;
        }
        ArgType superClass = cls.getSuperClass();
        if (superClass != null && (superNode = this.resolveClass(superClass)) != null && (found = this.deepResolveMethod(superNode, signature)) != null) {
            return found;
        }
        for (ArgType iFaceType : cls.getInterfaces()) {
            ClassNode iFaceNode = this.resolveClass(iFaceType);
            if (iFaceNode == null || (found = this.deepResolveMethod(iFaceNode, signature)) == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public FieldNode resolveField(FieldInfo field) {
        ClassNode cls = this.resolveClass(field.getDeclClass());
        if (cls == null) {
            return null;
        }
        FieldNode fieldNode = cls.searchField(field);
        if (fieldNode != null) {
            return fieldNode;
        }
        return this.deepResolveField(cls, field);
    }

    @Nullable
    private FieldNode deepResolveField(@NotNull ClassNode cls, FieldInfo fieldInfo) {
        FieldNode found;
        ClassNode superNode;
        FieldNode field = cls.searchFieldByNameAndType(fieldInfo);
        if (field != null) {
            return field;
        }
        ArgType superClass = cls.getSuperClass();
        if (superClass != null && (superNode = this.resolveClass(superClass)) != null && (found = this.deepResolveField(superNode, fieldInfo)) != null) {
            return found;
        }
        for (ArgType iFaceType : cls.getInterfaces()) {
            FieldNode found2;
            ClassNode iFaceNode = this.resolveClass(iFaceType);
            if (iFaceNode == null || (found2 = this.deepResolveField(iFaceNode, fieldInfo)) == null) continue;
            return found2;
        }
        return null;
    }

    public ProcessClass getProcessClasses() {
        return this.processClasses;
    }

    public List<IDexTreeVisitor> getPasses() {
        return this.processClasses.getPasses();
    }

    public List<IDexTreeVisitor> getPreDecompilePasses() {
        return this.preDecompilePasses;
    }

    public void initPasses() {
        this.processClasses.initPasses(this);
    }

    public ICodeWriter makeCodeWriter() {
        JadxArgs jadxArgs = this.args;
        return jadxArgs.getCodeWriterProvider().apply(jadxArgs);
    }

    public void registerCodeDataUpdateListener(ICodeDataUpdateListener listener) {
        this.codeDataUpdateListeners.add(listener);
    }

    public void notifyCodeDataListeners() {
        ICodeData codeData = this.args.getCodeData();
        this.codeDataUpdateListeners.forEach(l15 -> l15.updated(codeData));
    }

    public ClspGraph getClsp() {
        return this.clsp;
    }

    public ErrorsCounter getErrorsCounter() {
        return this.errorsCounter;
    }

    @Nullable
    public String getAppPackage() {
        return this.appPackage;
    }

    @Nullable
    public ClassNode getAppResClass() {
        return this.appResClass;
    }

    public StringUtils getStringUtils() {
        return this.stringUtils;
    }

    public ConstStorage getConstValues() {
        return this.constValues;
    }

    public InfoStorage getInfoStorage() {
        return this.infoStorage;
    }

    public CacheStorage getCacheStorage() {
        return this.cacheStorage;
    }

    public JadxArgs getArgs() {
        return this.args;
    }

    @Nullable
    public JadxDecompiler getDecompiler() {
        return this.decompiler;
    }

    public TypeUpdate getTypeUpdate() {
        return this.typeUpdate;
    }

    public TypeCompare getTypeCompare() {
        return this.typeUpdate.getTypeCompare();
    }

    public ICodeCache getCodeCache() {
        return this.args.getCodeCache();
    }

    public MethodUtils getMethodUtils() {
        return this.methodUtils;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }

    public AttributeStorage getAttributes() {
        return this.attributes;
    }

    public GradleInfoStorage getGradleInfoStorage() {
        return this.gradleInfoStorage;
    }

    public synchronized ManifestAttributes initManifestAttributes() {
        ManifestAttributes attrs = this.manifestAttributes;
        if (attrs == null) {
            this.manifestAttributes = attrs = new ManifestAttributes(this.args.getSecurity());
        }
        return attrs;
    }
}

