/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.JavaPackage;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.PackageInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IDexNode;
import jadx.core.dex.nodes.IPackageUpdate;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageNode
extends LineAttrNode
implements IPackageUpdate,
IDexNode,
ICodeNodeRef,
Comparable<PackageNode> {
    private final RootNode root;
    private final PackageInfo pkgInfo;
    @Nullable
    private final PackageNode parentPkg;
    private final List<PackageNode> subPackages = new ArrayList<PackageNode>();
    private final List<ClassNode> classes = new ArrayList<ClassNode>();
    private PackageInfo aliasPkgInfo;
    private JavaPackage javaNode;

    public static PackageNode getForClass(RootNode root, String fullPkg, ClassNode cls) {
        PackageNode pkg = PackageNode.getOrBuild(root, fullPkg);
        pkg.getClasses().add(cls);
        return pkg;
    }

    public static PackageNode getOrBuild(RootNode root, String fullPkg) {
        PackageNode existPkg = root.resolvePackage(fullPkg);
        if (existPkg != null) {
            return existPkg;
        }
        PackageInfo pgkInfo = PackageInfo.fromFullPkg(root, fullPkg);
        PackageNode parentPkg = PackageNode.getParentPkg(root, pgkInfo);
        PackageNode pkgNode = new PackageNode(root, parentPkg, pgkInfo);
        if (parentPkg != null) {
            parentPkg.getSubPackages().add(pkgNode);
        }
        root.addPackage(pkgNode);
        return pkgNode;
    }

    @Nullable
    private static PackageNode getParentPkg(RootNode root, PackageInfo pgkInfo) {
        PackageInfo parentPkg = pgkInfo.getParentPkg();
        if (parentPkg == null) {
            return null;
        }
        return PackageNode.getOrBuild(root, parentPkg.getFullName());
    }

    private PackageNode(RootNode root, @Nullable PackageNode parentPkg, PackageInfo pkgInfo) {
        this.root = root;
        this.parentPkg = parentPkg;
        this.pkgInfo = pkgInfo;
        this.aliasPkgInfo = pkgInfo;
    }

    @Override
    public void rename(String newName) {
        this.rename(newName, true);
    }

    public void rename(String newName, boolean runUpdates) {
        boolean isFullAlias;
        String alias;
        if (StringUtils.containsChar(newName, '/')) {
            alias = newName.replace('/', '.');
            isFullAlias = true;
        } else if (newName.startsWith(".")) {
            alias = newName.substring(1);
            isFullAlias = true;
        } else {
            alias = newName;
            isFullAlias = StringUtils.containsChar(newName, '.');
        }
        if (isFullAlias) {
            this.setFullAlias(alias, runUpdates);
        } else {
            this.setLeafAlias(alias, runUpdates);
        }
    }

    public void setLeafAlias(String alias, boolean runUpdates) {
        this.aliasPkgInfo = this.pkgInfo.getName().equals(alias) ? this.pkgInfo : PackageInfo.fromShortName(this.root, this.getParentAliasPkgInfo(), alias);
        if (runUpdates) {
            this.updatePackages(this);
        }
    }

    public void setFullAlias(String fullAlias, boolean runUpdates) {
        this.aliasPkgInfo = this.pkgInfo.getFullName().equals(fullAlias) ? this.pkgInfo : PackageInfo.fromFullPkg(this.root, fullAlias);
        if (runUpdates) {
            this.updatePackages(this);
        }
    }

    @Override
    public void onParentPackageUpdate(PackageNode updatedPkg) {
        this.aliasPkgInfo = PackageInfo.fromShortName(this.root, this.getParentAliasPkgInfo(), this.aliasPkgInfo.getName());
        this.updatePackages(updatedPkg);
    }

    public void updatePackages() {
        this.updatePackages(this);
    }

    private void updatePackages(PackageNode updatedPkg) {
        for (PackageNode subPackage : this.subPackages) {
            subPackage.onParentPackageUpdate(updatedPkg);
        }
        for (ClassNode cls : this.classes) {
            cls.onParentPackageUpdate(updatedPkg);
        }
    }

    public String getName() {
        return this.pkgInfo.getName();
    }

    public String getFullName() {
        return this.pkgInfo.getFullName();
    }

    public PackageInfo getPkgInfo() {
        return this.pkgInfo;
    }

    public PackageInfo getAliasPkgInfo() {
        return this.aliasPkgInfo;
    }

    public boolean hasAlias() {
        if (this.pkgInfo == this.aliasPkgInfo) {
            return false;
        }
        return !this.pkgInfo.getName().equals(this.aliasPkgInfo.getName());
    }

    public boolean hasParentAlias() {
        if (this.pkgInfo == this.aliasPkgInfo) {
            return false;
        }
        return !Objects.equals(this.pkgInfo.getParentPkg(), this.aliasPkgInfo.getParentPkg());
    }

    public void removeAlias() {
        this.aliasPkgInfo = this.pkgInfo;
    }

    @Nullable
    public PackageNode getParentPkg() {
        return this.parentPkg;
    }

    @Nullable
    public PackageInfo getParentAliasPkgInfo() {
        return this.parentPkg == null ? null : this.parentPkg.aliasPkgInfo;
    }

    public boolean isRoot() {
        return this.parentPkg == null;
    }

    public boolean isLeaf() {
        return this.subPackages.isEmpty();
    }

    public List<PackageNode> getSubPackages() {
        return this.subPackages;
    }

    public List<ClassNode> getClasses() {
        return this.classes;
    }

    public List<ClassNode> getClassesNoDup() {
        return this.classes.stream().map(ClassNode::getClassInfo).collect(Collectors.toSet()).stream().map(e15 -> this.root.resolveClass((ClassInfo)e15)).collect(Collectors.toList());
    }

    public JavaPackage getJavaNode() {
        return this.javaNode;
    }

    public void setJavaNode(JavaPackage javaNode) {
        this.javaNode = javaNode;
    }

    public boolean isEmpty() {
        return this.classes.isEmpty() && this.subPackages.isEmpty();
    }

    @Override
    public String typeName() {
        return "package";
    }

    @Override
    public ICodeAnnotation.AnnType getAnnType() {
        return ICodeAnnotation.AnnType.PKG;
    }

    @Override
    public RootNode root() {
        return this.root;
    }

    @Override
    public String getInputFileName() {
        return "";
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof PackageNode)) {
            return false;
        }
        return this.pkgInfo.equals(((PackageNode)o15).pkgInfo);
    }

    public int hashCode() {
        return this.pkgInfo.hashCode();
    }

    @Override
    public int compareTo(@NotNull PackageNode other) {
        return this.getPkgInfo().getFullName().compareTo(other.getPkgInfo().getFullName());
    }

    public String toString() {
        return this.getPkgInfo().getFullName();
    }
}

