/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.typeinference.TypeInfo;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSAVar
implements Comparable<SSAVar> {
    private static final Logger LOG = LoggerFactory.getLogger(SSAVar.class);
    private static final Comparator<SSAVar> SSA_VAR_COMPARATOR = Comparator.comparingInt(SSAVar::getRegNum).thenComparingInt(SSAVar::getVersion);
    private final int regNum;
    private final int version;
    private RegisterArg assign;
    private final List<RegisterArg> useList = new ArrayList<RegisterArg>(2);
    private List<PhiInsn> usedInPhi = null;
    private final TypeInfo typeInfo = new TypeInfo();
    @Nullable(value="Set in InitCodeVariables pass")
    private @Nullable(value="Set in InitCodeVariables pass") CodeVar codeVar;

    public SSAVar(int regNum, int v15, @NotNull RegisterArg assign) {
        this.regNum = regNum;
        this.version = v15;
        this.assign = assign;
        assign.setSVar(this);
    }

    public int getRegNum() {
        return this.regNum;
    }

    public int getVersion() {
        return this.version;
    }

    @NotNull
    public RegisterArg getAssign() {
        return this.assign;
    }

    @Nullable
    public InsnNode getAssignInsn() {
        return this.assign.getParentInsn();
    }

    public void setAssign(@NotNull RegisterArg assign) {
        RegisterArg oldAssign = this.assign;
        if (oldAssign == null) {
            this.assign = assign;
        } else if (oldAssign != assign) {
            oldAssign.resetSSAVar();
            this.assign = assign;
        }
    }

    public List<RegisterArg> getUseList() {
        return this.useList;
    }

    public int getUseCount() {
        return this.useList.size();
    }

    @Nullable
    public ArgType getImmutableType() {
        if (this.isTypeImmutable()) {
            return this.assign.getInitType();
        }
        return null;
    }

    public boolean isTypeImmutable() {
        return this.assign.contains(AFlag.IMMUTABLE_TYPE);
    }

    public void markAsImmutable(ArgType type) {
        this.assign.add(AFlag.IMMUTABLE_TYPE);
        ArgType initType = this.assign.getInitType();
        if (!initType.equals(type)) {
            this.assign.forceSetInitType(type);
        }
    }

    public void setType(ArgType type) {
        ArgType imType = this.getImmutableType();
        if (imType != null && !imType.equals(type)) {
            throw new JadxRuntimeException("Can't change immutable type " + String.valueOf(imType) + " to " + String.valueOf(type) + " for " + String.valueOf(this));
        }
        this.updateType(type);
    }

    public void forceSetType(ArgType type) {
        this.updateType(type);
    }

    private void updateType(ArgType type) {
        this.typeInfo.setType(type);
        if (this.codeVar != null) {
            this.codeVar.setType(type);
        }
    }

    public void use(RegisterArg arg) {
        if (arg.getSVar() != null) {
            arg.getSVar().removeUse(arg);
        }
        arg.setSVar(this);
        this.useList.add(arg);
    }

    public void removeUse(RegisterArg arg) {
        this.useList.removeIf(registerArg -> registerArg == arg);
    }

    public void addUsedInPhi(PhiInsn phiInsn) {
        if (this.usedInPhi == null) {
            this.usedInPhi = new ArrayList<PhiInsn>(1);
        }
        this.usedInPhi.add(phiInsn);
    }

    public void removeUsedInPhi(PhiInsn phiInsn) {
        if (this.usedInPhi != null) {
            this.usedInPhi.removeIf(insn -> insn == phiInsn);
            if (this.usedInPhi.isEmpty()) {
                this.usedInPhi = null;
            }
        }
    }

    public void updateUsedInPhiList() {
        this.usedInPhi = null;
        for (RegisterArg reg : this.useList) {
            InsnNode parentInsn = reg.getParentInsn();
            if (parentInsn == null || parentInsn.getType() != InsnType.PHI) continue;
            this.addUsedInPhi((PhiInsn)parentInsn);
        }
    }

    @Nullable
    public PhiInsn getOnlyOneUseInPhi() {
        if (this.usedInPhi != null && this.usedInPhi.size() == 1) {
            return this.usedInPhi.get(0);
        }
        return null;
    }

    public List<PhiInsn> getUsedInPhi() {
        if (this.usedInPhi == null) {
            return Collections.emptyList();
        }
        return this.usedInPhi;
    }

    public List<PhiInsn> getPhiList() {
        InsnNode assignInsn = this.getAssign().getParentInsn();
        if (assignInsn != null && assignInsn.getType() == InsnType.PHI) {
            PhiInsn assignPhi = (PhiInsn)assignInsn;
            if (this.usedInPhi == null) {
                return Collections.singletonList(assignPhi);
            }
            ArrayList<PhiInsn> list2 = new ArrayList<PhiInsn>(1 + this.usedInPhi.size());
            list2.add(assignPhi);
            list2.addAll(this.usedInPhi);
            return list2;
        }
        if (this.usedInPhi == null) {
            return Collections.emptyList();
        }
        return this.usedInPhi;
    }

    public boolean isAssignInPhi() {
        InsnNode assignInsn = this.getAssignInsn();
        return assignInsn != null && assignInsn.getType() == InsnType.PHI;
    }

    public boolean isUsedInPhi() {
        return this.usedInPhi != null && !this.usedInPhi.isEmpty();
    }

    public void setName(String name) {
        if (name != null) {
            if (this.codeVar == null) {
                throw new JadxRuntimeException("CodeVar not initialized for name set in SSAVar: " + String.valueOf(this));
            }
            this.codeVar.setName(name);
        }
    }

    public String getName() {
        if (this.codeVar == null) {
            return null;
        }
        return this.codeVar.getName();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @NotNull
    public CodeVar getCodeVar() {
        if (this.codeVar == null) {
            throw new JadxRuntimeException("Code variable not set in " + String.valueOf(this));
        }
        return this.codeVar;
    }

    public void setCodeVar(@NotNull CodeVar codeVar) {
        this.codeVar = codeVar;
        codeVar.addSsaVar(this);
        ArgType imType = this.getImmutableType();
        if (imType != null) {
            codeVar.setType(imType);
        }
    }

    public void resetTypeAndCodeVar() {
        if (!this.isTypeImmutable()) {
            this.updateType(ArgType.UNKNOWN);
        }
        this.typeInfo.getBounds().clear();
        this.codeVar = null;
    }

    public boolean isCodeVarSet() {
        return this.codeVar != null;
    }

    public String getDetailedVarInfo(MethodNode mth) {
        HashSet<ArgType> types = new HashSet<ArgType>();
        Set names = Collections.emptySet();
        ArrayList<RegisterArg> useArgs = new ArrayList<RegisterArg>(1 + this.useList.size());
        useArgs.add(this.assign);
        useArgs.addAll(this.useList);
        if (mth.contains(AType.LOCAL_VARS_DEBUG_INFO)) {
            names = new HashSet();
            for (RegisterArg arg : useArgs) {
                RegDebugInfoAttr debugInfoAttr = arg.get(AType.REG_DEBUG_INFO);
                if (debugInfoAttr == null) continue;
                names.add(debugInfoAttr.getName());
                types.add(debugInfoAttr.getRegType());
            }
        }
        for (RegisterArg arg : useArgs) {
            ArgType type;
            ArgType initType = arg.getInitType();
            if (initType.isTypeKnown()) {
                types.add(initType);
            }
            if (!(type = arg.getType()).isTypeKnown()) continue;
            types.add(type);
        }
        StringBuilder sb5 = new StringBuilder();
        sb5.append('r').append(this.regNum).append('v').append(this.version);
        if (!names.isEmpty()) {
            String orderedNames = names.stream().sorted().collect(Collectors.joining(", ", "[", "]"));
            sb5.append(", names: ").append(orderedNames);
        }
        if (!types.isEmpty()) {
            String orderedTypes = types.stream().map(String::valueOf).sorted().collect(Collectors.joining(", ", "[", "]"));
            sb5.append(", types: ").append(orderedTypes);
        }
        return sb5.toString();
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof SSAVar)) {
            return false;
        }
        SSAVar ssaVar = (SSAVar)o15;
        return this.regNum == ssaVar.regNum && this.version == ssaVar.version;
    }

    public int hashCode() {
        return 31 * this.regNum + this.version;
    }

    @Override
    public int compareTo(@NotNull SSAVar o15) {
        return SSA_VAR_COMPARATOR.compare(this, o15);
    }

    public String toShortString() {
        return "r" + this.regNum + "v" + this.version;
    }

    public String toString() {
        return this.toShortString() + (String)(StringUtils.notEmpty(this.getName()) ? " '" + this.getName() + "' " : "") + " " + String.valueOf(this.typeInfo.getType());
    }
}

