/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import java.util.Objects;

public class IndexInsnNode
extends InsnNode {
    private Object index;

    public IndexInsnNode(InsnType type, Object index, int argCount) {
        super(type, argCount);
        this.index = index;
    }

    public Object getIndex() {
        return this.index;
    }

    public void updateIndex(Object index) {
        this.index = index;
    }

    public ArgType getIndexAsType() {
        return (ArgType)this.index;
    }

    @Override
    public IndexInsnNode copy() {
        return this.copyCommonParams(new IndexInsnNode(this.insnType, this.index, this.getArgsCount()));
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexInsnNode) || !super.isSame(obj)) {
            return false;
        }
        IndexInsnNode other = (IndexInsnNode)obj;
        return Objects.equals(this.index, other.index);
    }

    @Override
    public String toString() {
        switch (this.insnType) {
            case CAST: 
            case CHECK_CAST: {
                StringBuilder sb5 = new StringBuilder();
                sb5.append(InsnUtils.formatOffset(this.offset)).append(": ");
                sb5.append((Object)this.insnType).append(' ');
                if (this.getResult() != null) {
                    sb5.append(this.getResult()).append(" = ");
                }
                sb5.append('(').append(InsnUtils.indexToString(this.index)).append(") ");
                sb5.append(Utils.listToString(this.getArguments()));
                return sb5.toString();
            }
        }
        return super.toString() + " " + InsnUtils.indexToString(this.index);
    }
}

