/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfOp;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnUtils;
import java.util.List;

public class IfNode
extends GotoNode {
    protected IfOp op;
    private BlockNode thenBlock;
    private BlockNode elseBlock;
    private static final ArgType WIDE_TYPE = ArgType.unknown(PrimitiveType.INT, PrimitiveType.BOOLEAN, PrimitiveType.OBJECT, PrimitiveType.ARRAY, PrimitiveType.BYTE, PrimitiveType.SHORT, PrimitiveType.CHAR);
    private static final ArgType NUMBERS_TYPE = ArgType.unknown(PrimitiveType.INT, PrimitiveType.BYTE, PrimitiveType.SHORT, PrimitiveType.CHAR);

    public IfNode(InsnData insn, IfOp op4) {
        super(InsnType.IF, insn.getTarget(), 2);
        this.op = op4;
        ArgType argType = IfNode.narrowTypeByOp(op4);
        this.addArg(InsnArg.reg(insn, 0, argType));
        if (insn.getRegsCount() == 1) {
            this.addArg(InsnArg.lit(0L, argType));
        } else {
            this.addArg(InsnArg.reg(insn, 1, argType));
        }
    }

    public IfNode(IfOp op4, int targetOffset, InsnArg arg1, InsnArg arg2) {
        this(op4, targetOffset);
        this.addArg(arg1);
        this.addArg(arg2);
    }

    private IfNode(IfOp op4, int targetOffset) {
        super(InsnType.IF, targetOffset, 2);
        this.op = op4;
    }

    private static ArgType narrowTypeByOp(IfOp op4) {
        if (op4 == IfOp.EQ || op4 == IfOp.NE) {
            return WIDE_TYPE;
        }
        return NUMBERS_TYPE;
    }

    public IfOp getOp() {
        return this.op;
    }

    public void invertCondition() {
        this.op = this.op.invert();
        BlockNode tmp = this.thenBlock;
        this.thenBlock = this.elseBlock;
        this.elseBlock = tmp;
    }

    public void normalize() {
        if (this.getOp() == IfOp.NE && this.getArg(1).isFalse()) {
            this.changeCondition(IfOp.EQ, this.getArg(0), LiteralArg.litTrue());
        }
    }

    public void changeCondition(IfOp op4, InsnArg arg1, InsnArg arg2) {
        this.op = op4;
        this.setArg(0, arg1);
        this.setArg(1, arg2);
    }

    @Override
    public void initBlocks(BlockNode curBlock) {
        List<BlockNode> successors = curBlock.getSuccessors();
        this.thenBlock = BlockUtils.getBlockByOffset(this.target, successors);
        this.elseBlock = successors.size() == 1 ? this.thenBlock : BlockUtils.selectOther(this.thenBlock, successors);
    }

    @Override
    public boolean replaceTargetBlock(BlockNode origin, BlockNode replace) {
        boolean replaced = false;
        if (this.thenBlock == origin) {
            this.thenBlock = replace;
            replaced = true;
        }
        if (this.elseBlock == origin) {
            this.elseBlock = replace;
            replaced = true;
        }
        return replaced;
    }

    public BlockNode getThenBlock() {
        return this.thenBlock;
    }

    public BlockNode getElseBlock() {
        return this.elseBlock;
    }

    @Override
    public int getTarget() {
        return this.thenBlock == null ? this.target : this.thenBlock.getStartOffset();
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IfNode) || !super.isSame(obj)) {
            return false;
        }
        IfNode other = (IfNode)obj;
        return this.op == other.op;
    }

    @Override
    public InsnNode copy() {
        IfNode copy = new IfNode(this.op, this.target);
        copy.thenBlock = this.thenBlock;
        copy.elseBlock = this.elseBlock;
        return this.copyCommonParams(copy);
    }

    @Override
    public String toString() {
        return InsnUtils.formatOffset(this.offset) + ": " + InsnUtils.insnTypeToString(this.insnType) + String.valueOf(this.getArg(0)) + " " + this.op.getSymbol() + " " + String.valueOf(this.getArg(1)) + "  -> " + String.valueOf(this.thenBlock != null ? this.thenBlock : InsnUtils.formatOffset(this.target)) + this.attributesString();
    }
}

