/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.MethodOverrideAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaMethod
implements JavaNode {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMethod.class);
    private final MethodNode mth;
    private final JavaClass parent;

    JavaMethod(JavaClass cls, MethodNode m15) {
        this.parent = cls;
        this.mth = m15;
    }

    @Override
    public String getName() {
        return this.mth.getAlias();
    }

    @Override
    public String getFullName() {
        return this.mth.getMethodInfo().getFullName();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.parent.getTopParentClass();
    }

    public AccessInfo getAccessFlags() {
        return this.mth.getAccessFlags();
    }

    public List<ArgType> getArguments() {
        List<ArgType> infoArgTypes = this.mth.getMethodInfo().getArgumentsTypes();
        if (infoArgTypes.isEmpty()) {
            return Collections.emptyList();
        }
        List<ArgType> arguments = this.mth.getArgTypes();
        return Utils.collectionMap(arguments, type -> ArgType.tryToResolveClassAlias(this.mth.root(), type));
    }

    public ArgType getReturnType() {
        ArgType retType = this.mth.getReturnType();
        return ArgType.tryToResolveClassAlias(this.mth.root(), retType);
    }

    @Override
    public List<JavaNode> getUseIn() {
        return this.getDeclaringClass().getRootDecompiler().convertNodes(this.mth.getUseIn());
    }

    public List<JavaMethod> getOverrideRelatedMethods() {
        MethodOverrideAttr ovrdAttr = this.mth.get(AType.METHOD_OVERRIDE);
        if (ovrdAttr == null) {
            return Collections.emptyList();
        }
        JadxDecompiler decompiler = this.getDeclaringClass().getRootDecompiler();
        return ovrdAttr.getRelatedMthNodes().stream().map(decompiler::convertMethodNode).collect(Collectors.toList());
    }

    public boolean isConstructor() {
        return this.mth.getMethodInfo().isConstructor();
    }

    public boolean isClassInit() {
        return this.mth.getMethodInfo().isClassInit();
    }

    @Override
    public int getDefPos() {
        return this.mth.getDefPosition();
    }

    public String getCodeStr() {
        return this.mth.getCodeStr();
    }

    @Override
    public void removeAlias() {
        this.mth.getMethodInfo().removeAlias();
    }

    @Override
    public boolean isOwnCodeAnnotation(ICodeAnnotation ann) {
        if (ann.getAnnType() == ICodeAnnotation.AnnType.METHOD) {
            return ann.equals(this.mth);
        }
        return false;
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return this.mth;
    }

    @ApiStatus.Internal
    public MethodNode getMethodNode() {
        return this.mth;
    }

    public int hashCode() {
        return this.mth.hashCode();
    }

    public boolean equals(Object o15) {
        return this == o15 || o15 instanceof JavaMethod && this.mth.equals(((JavaMethod)o15).mth);
    }

    public String toString() {
        return this.mth.toString();
    }
}

