/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.operators;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.internal.util.Pow2;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscLinkedArrayQueue<T>
implements SimplePlainQueue<T> {
    static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    final AtomicLong producerIndex = new AtomicLong();
    int producerLookAheadStep;
    long producerLookAhead;
    final int producerMask;
    AtomicReferenceArray<Object> producerBuffer;
    final int consumerMask;
    AtomicReferenceArray<Object> consumerBuffer;
    final AtomicLong consumerIndex = new AtomicLong();
    private static final Object HAS_NEXT = new Object();

    public SpscLinkedArrayQueue(int bufferSize) {
        int p2capacity = Pow2.roundToPowerOfTwo(Math.max(8, bufferSize));
        int mask = p2capacity - 1;
        AtomicReferenceArray buffer = new AtomicReferenceArray(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2capacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerLookAhead = mask - 1;
        this.soProducerIndex(0L);
    }

    @Override
    public boolean offer(T e15) {
        if (null == e15) {
            throw new NullPointerException("Null is not a valid element");
        }
        AtomicReferenceArray<Object> buffer = this.producerBuffer;
        long index = this.lpProducerIndex();
        int mask = this.producerMask;
        int offset = SpscLinkedArrayQueue.calcWrappedOffset(index, mask);
        if (index < this.producerLookAhead) {
            return this.writeToQueue(buffer, e15, index, offset);
        }
        int lookAheadStep = this.producerLookAheadStep;
        int lookAheadElementOffset = SpscLinkedArrayQueue.calcWrappedOffset(index + (long)lookAheadStep, mask);
        if (null == SpscLinkedArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
            this.producerLookAhead = index + (long)lookAheadStep - 1L;
            return this.writeToQueue(buffer, e15, index, offset);
        }
        if (null == SpscLinkedArrayQueue.lvElement(buffer, SpscLinkedArrayQueue.calcWrappedOffset(index + 1L, mask))) {
            return this.writeToQueue(buffer, e15, index, offset);
        }
        this.resize(buffer, index, offset, e15, mask);
        return true;
    }

    private boolean writeToQueue(AtomicReferenceArray<Object> buffer, T e15, long index, int offset) {
        SpscLinkedArrayQueue.soElement(buffer, offset, e15);
        this.soProducerIndex(index + 1L);
        return true;
    }

    private void resize(AtomicReferenceArray<Object> oldBuffer, long currIndex, int offset, T e15, long mask) {
        int capacity = oldBuffer.length();
        AtomicReferenceArray<Object> newBuffer = new AtomicReferenceArray<Object>(capacity);
        this.producerBuffer = newBuffer;
        this.producerLookAhead = currIndex + mask - 1L;
        SpscLinkedArrayQueue.soElement(newBuffer, offset, e15);
        this.soNext(oldBuffer, newBuffer);
        SpscLinkedArrayQueue.soElement(oldBuffer, offset, HAS_NEXT);
        this.soProducerIndex(currIndex + 1L);
    }

    private void soNext(AtomicReferenceArray<Object> curr, AtomicReferenceArray<Object> next) {
        SpscLinkedArrayQueue.soElement(curr, SpscLinkedArrayQueue.calcDirectOffset(curr.length() - 1), next);
    }

    private AtomicReferenceArray<Object> lvNextBufferAndUnlink(AtomicReferenceArray<Object> curr, int nextIndex) {
        int nextOffset = SpscLinkedArrayQueue.calcDirectOffset(nextIndex);
        AtomicReferenceArray nextBuffer = (AtomicReferenceArray)SpscLinkedArrayQueue.lvElement(curr, nextOffset);
        SpscLinkedArrayQueue.soElement(curr, nextOffset, null);
        return nextBuffer;
    }

    @Override
    @Nullable
    public T poll() {
        boolean isNextBuffer;
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscLinkedArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e15 = SpscLinkedArrayQueue.lvElement(buffer, offset);
        boolean bl4 = isNextBuffer = e15 == HAS_NEXT;
        if (null != e15 && !isNextBuffer) {
            SpscLinkedArrayQueue.soElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            return (T)e15;
        }
        if (isNextBuffer) {
            return this.newBufferPoll(this.lvNextBufferAndUnlink(buffer, mask + 1), index, mask);
        }
        return null;
    }

    private T newBufferPoll(AtomicReferenceArray<Object> nextBuffer, long index, int mask) {
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscLinkedArrayQueue.calcWrappedOffset(index, mask);
        Object n15 = SpscLinkedArrayQueue.lvElement(nextBuffer, offsetInNew);
        if (null != n15) {
            SpscLinkedArrayQueue.soElement(nextBuffer, offsetInNew, null);
            this.soConsumerIndex(index + 1L);
        }
        return (T)n15;
    }

    @Nullable
    public T peek() {
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscLinkedArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e15 = SpscLinkedArrayQueue.lvElement(buffer, offset);
        if (e15 == HAS_NEXT) {
            return this.newBufferPeek(this.lvNextBufferAndUnlink(buffer, mask + 1), index, mask);
        }
        return (T)e15;
    }

    private T newBufferPeek(AtomicReferenceArray<Object> nextBuffer, long index, int mask) {
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscLinkedArrayQueue.calcWrappedOffset(index, mask);
        return (T)SpscLinkedArrayQueue.lvElement(nextBuffer, offsetInNew);
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lpProducerIndex() {
        return this.producerIndex.get();
    }

    private long lpConsumerIndex() {
        return this.consumerIndex.get();
    }

    private void soProducerIndex(long v15) {
        this.producerIndex.lazySet(v15);
    }

    private void soConsumerIndex(long v15) {
        this.consumerIndex.lazySet(v15);
    }

    private static int calcWrappedOffset(long index, int mask) {
        return SpscLinkedArrayQueue.calcDirectOffset((int)index & mask);
    }

    private static int calcDirectOffset(int index) {
        return index;
    }

    private static void soElement(AtomicReferenceArray<Object> buffer, int offset, Object e15) {
        buffer.lazySet(offset, e15);
    }

    private static Object lvElement(AtomicReferenceArray<Object> buffer, int offset) {
        return buffer.get(offset);
    }

    @Override
    public boolean offer(T first, T second) {
        int m15;
        AtomicReferenceArray<Object> buffer = this.producerBuffer;
        long p15 = this.lvProducerIndex();
        int pi4 = SpscLinkedArrayQueue.calcWrappedOffset(p15 + 2L, m15 = this.producerMask);
        if (null == SpscLinkedArrayQueue.lvElement(buffer, pi4)) {
            pi4 = SpscLinkedArrayQueue.calcWrappedOffset(p15, m15);
            SpscLinkedArrayQueue.soElement(buffer, pi4 + 1, second);
            SpscLinkedArrayQueue.soElement(buffer, pi4, first);
            this.soProducerIndex(p15 + 2L);
        } else {
            int capacity = buffer.length();
            AtomicReferenceArray<Object> newBuffer = new AtomicReferenceArray<Object>(capacity);
            this.producerBuffer = newBuffer;
            pi4 = SpscLinkedArrayQueue.calcWrappedOffset(p15, m15);
            SpscLinkedArrayQueue.soElement(newBuffer, pi4 + 1, second);
            SpscLinkedArrayQueue.soElement(newBuffer, pi4, first);
            this.soNext(buffer, newBuffer);
            SpscLinkedArrayQueue.soElement(buffer, pi4, HAS_NEXT);
            this.soProducerIndex(p15 + 2L);
        }
        return true;
    }
}

