/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SafeObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> downstream;
    Disposable upstream;
    boolean done;

    public SafeObserver(@NonNull Observer<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d15) {
        if (DisposableHelper.validate(this.upstream, d15)) {
            this.upstream = d15;
            try {
                this.downstream.onSubscribe(this);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.done = true;
                try {
                    d15.dispose();
                }
                catch (Throwable e16) {
                    Exceptions.throwIfFatal(e16);
                    RxJavaPlugins.onError(new CompositeException(e15, e16));
                    return;
                }
                RxJavaPlugins.onError(e15);
            }
        }
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void onNext(@NonNull T t15) {
        if (this.done) {
            return;
        }
        if (this.upstream == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t15 == null) {
            NullPointerException ex4 = ExceptionHelper.createNullPointerException("onNext called with a null value.");
            try {
                this.upstream.dispose();
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.onError(new CompositeException(ex4, e15));
                return;
            }
            this.onError(ex4);
            return;
        }
        try {
            this.downstream.onNext(t15);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            try {
                this.upstream.dispose();
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                this.onError(new CompositeException(e15, e16));
                return;
            }
            this.onError(e15);
        }
    }

    void onNextNoSubscription() {
        this.done = true;
        NullPointerException ex4 = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptyDisposable.INSTANCE);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            RxJavaPlugins.onError(new CompositeException(ex4, e15));
            return;
        }
        try {
            this.downstream.onError(ex4);
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            RxJavaPlugins.onError(new CompositeException(ex4, e16));
        }
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.downstream.onSubscribe(EmptyDisposable.INSTANCE);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(new CompositeException(t15, npe, e15));
                return;
            }
            try {
                this.downstream.onError(new CompositeException(t15, npe));
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                RxJavaPlugins.onError(new CompositeException(t15, npe, e16));
            }
            return;
        }
        if (t15 == null) {
            t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
        }
        try {
            this.downstream.onError(t15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(new CompositeException(t15, ex4));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.downstream.onComplete();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            RxJavaPlugins.onError(e15);
        }
    }

    void onCompleteNoSubscription() {
        NullPointerException ex4 = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptyDisposable.INSTANCE);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            RxJavaPlugins.onError(new CompositeException(ex4, e15));
            return;
        }
        try {
            this.downstream.onError(ex4);
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            RxJavaPlugins.onError(new CompositeException(ex4, e16));
        }
    }
}

