/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.schedulers.DisposeOnCancel;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectPeriodicTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledRunnable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.SchedulerRunnableIntrospection;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ExecutorScheduler
extends Scheduler {
    final boolean interruptibleWorker;
    final boolean fair;
    @NonNull
    final Executor executor;

    public ExecutorScheduler(@NonNull Executor executor, boolean interruptibleWorker, boolean fair) {
        this.executor = executor;
        this.interruptibleWorker = interruptibleWorker;
        this.fair = fair;
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return new ExecutorWorker(this.executor, this.interruptibleWorker, this.fair);
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            if (this.executor instanceof ExecutorService) {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun, this.interruptibleWorker);
                Future<Void> f15 = ((ExecutorService)this.executor).submit(task);
                task.setFuture(f15);
                return task;
            }
            if (this.interruptibleWorker) {
                ExecutorWorker.InterruptibleRunnable interruptibleTask = new ExecutorWorker.InterruptibleRunnable(decoratedRun, null);
                this.executor.execute(interruptibleTask);
                return interruptibleTask;
            }
            ExecutorWorker.BooleanRunnable br4 = new ExecutorWorker.BooleanRunnable(decoratedRun);
            this.executor.execute(br4);
            return br4;
        }
        catch (RejectedExecutionException ex4) {
            RxJavaPlugins.onError(ex4);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (this.executor instanceof ScheduledExecutorService) {
            try {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun, this.interruptibleWorker);
                ScheduledFuture<Void> f15 = ((ScheduledExecutorService)this.executor).schedule(task, delay, unit);
                task.setFuture(f15);
                return task;
            }
            catch (RejectedExecutionException ex4) {
                RxJavaPlugins.onError(ex4);
                return EmptyDisposable.INSTANCE;
            }
        }
        DelayedRunnable dr4 = new DelayedRunnable(decoratedRun);
        Disposable delayed = SingleHolder.HELPER.scheduleDirect(new DelayedDispose(dr4), delay, unit);
        dr4.timed.replace(delayed);
        return dr4;
    }

    @Override
    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
        if (this.executor instanceof ScheduledExecutorService) {
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            try {
                ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun, this.interruptibleWorker);
                ScheduledFuture<?> f15 = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(task, initialDelay, period, unit);
                task.setFuture(f15);
                return task;
            }
            catch (RejectedExecutionException ex4) {
                RxJavaPlugins.onError(ex4);
                return EmptyDisposable.INSTANCE;
            }
        }
        return super.schedulePeriodicallyDirect(run, initialDelay, period, unit);
    }

    final class DelayedDispose
    implements Runnable {
        private final DelayedRunnable dr;

        DelayedDispose(DelayedRunnable dr4) {
            this.dr = dr4;
        }

        @Override
        public void run() {
            this.dr.direct.replace(ExecutorScheduler.this.scheduleDirect(this.dr));
        }
    }

    static final class DelayedRunnable
    extends AtomicReference<Runnable>
    implements Runnable,
    Disposable,
    SchedulerRunnableIntrospection {
        private static final long serialVersionUID = -4101336210206799084L;
        final SequentialDisposable timed = new SequentialDisposable();
        final SequentialDisposable direct = new SequentialDisposable();

        DelayedRunnable(Runnable run) {
            super(run);
        }

        @Override
        public void run() {
            Runnable r15 = (Runnable)this.get();
            if (r15 != null) {
                try {
                    try {
                        r15.run();
                    }
                    finally {
                        this.lazySet(null);
                        this.timed.lazySet(DisposableHelper.DISPOSED);
                        this.direct.lazySet(DisposableHelper.DISPOSED);
                    }
                }
                catch (Throwable ex4) {
                    RxJavaPlugins.onError(ex4);
                    throw ex4;
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(null) != null) {
                this.timed.dispose();
                this.direct.dispose();
            }
        }

        @Override
        public Runnable getWrappedRunnable() {
            Runnable r15 = (Runnable)this.get();
            return r15 != null ? r15 : Functions.EMPTY_RUNNABLE;
        }
    }

    public static final class ExecutorWorker
    extends Scheduler.Worker
    implements Runnable {
        final boolean interruptibleWorker;
        final boolean fair;
        final Executor executor;
        final MpscLinkedQueue<Runnable> queue;
        volatile boolean disposed;
        final AtomicInteger wip = new AtomicInteger();
        final CompositeDisposable tasks = new CompositeDisposable();

        public ExecutorWorker(Executor executor, boolean interruptibleWorker, boolean fair) {
            this.executor = executor;
            this.queue = new MpscLinkedQueue();
            this.interruptibleWorker = interruptibleWorker;
            this.fair = fair;
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run) {
            Disposable disposable;
            Disposable task;
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            if (this.interruptibleWorker) {
                InterruptibleRunnable interruptibleTask = new InterruptibleRunnable(decoratedRun, this.tasks);
                this.tasks.add(interruptibleTask);
                task = interruptibleTask;
                disposable = interruptibleTask;
            } else {
                BooleanRunnable runnableTask;
                task = runnableTask = new BooleanRunnable(decoratedRun);
                disposable = runnableTask;
            }
            this.queue.offer((Runnable)((Object)task));
            if (this.wip.getAndIncrement() == 0) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException ex4) {
                    this.disposed = true;
                    this.queue.clear();
                    RxJavaPlugins.onError(ex4);
                    return EmptyDisposable.INSTANCE;
                }
            }
            return disposable;
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
            if (delay <= 0L) {
                return this.schedule(run);
            }
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            SequentialDisposable first = new SequentialDisposable();
            SequentialDisposable mar = new SequentialDisposable(first);
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            ScheduledRunnable sr4 = new ScheduledRunnable(new SequentialDispose(mar, decoratedRun), this.tasks, this.interruptibleWorker);
            this.tasks.add(sr4);
            if (this.executor instanceof ScheduledExecutorService) {
                try {
                    ScheduledFuture<Object> f15 = ((ScheduledExecutorService)this.executor).schedule(sr4, delay, unit);
                    sr4.setFuture(f15);
                }
                catch (RejectedExecutionException ex4) {
                    this.disposed = true;
                    RxJavaPlugins.onError(ex4);
                    return EmptyDisposable.INSTANCE;
                }
            } else {
                Disposable d15 = SingleHolder.HELPER.scheduleDirect(sr4, delay, unit);
                sr4.setFuture(new DisposeOnCancel(d15));
            }
            first.replace(sr4);
            return mar;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.tasks.dispose();
                if (this.wip.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void run() {
            if (this.fair) {
                this.runFair();
            } else {
                this.runEager();
            }
        }

        void runFair() {
            MpscLinkedQueue<Runnable> q15 = this.queue;
            if (this.disposed) {
                q15.clear();
                return;
            }
            Runnable run = q15.poll();
            run.run();
            if (this.disposed) {
                q15.clear();
                return;
            }
            if (this.wip.decrementAndGet() != 0) {
                this.executor.execute(this);
            }
        }

        void runEager() {
            int missed = 1;
            MpscLinkedQueue<Runnable> q15 = this.queue;
            do {
                Runnable run;
                if (this.disposed) {
                    q15.clear();
                    return;
                }
                while ((run = q15.poll()) != null) {
                    run.run();
                    if (!this.disposed) continue;
                    q15.clear();
                    return;
                }
                if (!this.disposed) continue;
                q15.clear();
                return;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        static final class InterruptibleRunnable
        extends AtomicInteger
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = -3603436687413320876L;
            final Runnable run;
            final DisposableContainer tasks;
            volatile Thread thread;
            static final int READY = 0;
            static final int RUNNING = 1;
            static final int FINISHED = 2;
            static final int INTERRUPTING = 3;
            static final int INTERRUPTED = 4;

            InterruptibleRunnable(Runnable run, DisposableContainer tasks) {
                this.run = run;
                this.tasks = tasks;
            }

            @Override
            public void run() {
                block10: {
                    if (this.get() == 0) {
                        this.thread = Thread.currentThread();
                        if (this.compareAndSet(0, 1)) {
                            try {
                                try {
                                    this.run.run();
                                    break block10;
                                }
                                catch (Throwable ex4) {
                                    RxJavaPlugins.onError(ex4);
                                    throw ex4;
                                }
                            }
                            finally {
                                this.thread = null;
                                if (this.compareAndSet(1, 2)) {
                                    this.cleanup();
                                } else {
                                    while (this.get() == 3) {
                                        Thread.yield();
                                    }
                                    Thread.interrupted();
                                }
                            }
                        }
                        this.thread = null;
                    }
                }
            }

            @Override
            public void dispose() {
                int state;
                while ((state = this.get()) < 2) {
                    if (state == 0) {
                        if (!this.compareAndSet(0, 4)) continue;
                        this.cleanup();
                        break;
                    }
                    if (!this.compareAndSet(1, 3)) continue;
                    Thread t15 = this.thread;
                    if (t15 != null) {
                        t15.interrupt();
                        this.thread = null;
                    }
                    this.set(4);
                    this.cleanup();
                    break;
                }
            }

            void cleanup() {
                if (this.tasks != null) {
                    this.tasks.delete(this);
                }
            }

            @Override
            public boolean isDisposed() {
                return this.get() >= 2;
            }
        }

        final class SequentialDispose
        implements Runnable {
            private final SequentialDisposable mar;
            private final Runnable decoratedRun;

            SequentialDispose(SequentialDisposable mar, Runnable decoratedRun) {
                this.mar = mar;
                this.decoratedRun = decoratedRun;
            }

            @Override
            public void run() {
                this.mar.replace(ExecutorWorker.this.schedule(this.decoratedRun));
            }
        }

        static final class BooleanRunnable
        extends AtomicBoolean
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = -2421395018820541164L;
            final Runnable actual;

            BooleanRunnable(Runnable actual) {
                this.actual = actual;
            }

            @Override
            public void run() {
                if (this.get()) {
                    return;
                }
                try {
                    this.actual.run();
                }
                catch (Throwable ex4) {
                    RxJavaPlugins.onError(ex4);
                    throw ex4;
                }
                finally {
                    this.lazySet(true);
                }
            }

            @Override
            public void dispose() {
                this.lazySet(true);
            }

            @Override
            public boolean isDisposed() {
                return this.get();
            }
        }
    }

    static final class SingleHolder {
        static final Scheduler HELPER = Schedulers.single();

        SingleHolder() {
        }
    }
}

