/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableUsing<T, D>
extends Observable<T> {
    final Supplier<? extends D> resourceSupplier;
    final Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public ObservableUsing(Supplier<? extends D> resourceSupplier, Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        ObservableSource<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptyDisposable.error(e15, observer);
            return;
        }
        try {
            source = Objects.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null ObservableSource");
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptyDisposable.error((Throwable)new CompositeException(e16, ex4), observer);
                return;
            }
            EmptyDisposable.error(e16, observer);
            return;
        }
        UsingObserver<? super T, ? super D> us4 = new UsingObserver<T, D>(observer, resource, this.disposer, this.eager);
        source.subscribe(us4);
    }

    static final class UsingObserver<T, D>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 5904473792286235046L;
        final Observer<? super T> downstream;
        final D resource;
        final Consumer<? super D> disposer;
        final boolean eager;
        Disposable upstream;

        UsingObserver(Observer<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
            this.downstream = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e15) {
                        Exceptions.throwIfFatal(e15);
                        t15 = new CompositeException(t15, e15);
                    }
                }
                this.downstream.onError(t15);
            } else {
                this.downstream.onError(t15);
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e15) {
                        Exceptions.throwIfFatal(e15);
                        this.downstream.onError(e15);
                        return;
                    }
                }
                this.downstream.onComplete();
            } else {
                this.downstream.onComplete();
                this.disposeResource();
            }
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        void disposeResource() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    RxJavaPlugins.onError(e15);
                }
            }
        }
    }
}

