/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableRepeatUntil<T>
extends AbstractObservableWithUpstream<T, T> {
    final BooleanSupplier until;

    public ObservableRepeatUntil(Observable<T> source, BooleanSupplier until) {
        super(source);
        this.until = until;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        SequentialDisposable sd5 = new SequentialDisposable();
        observer.onSubscribe(sd5);
        RepeatUntilObserver<T> rs4 = new RepeatUntilObserver<T>(observer, this.until, sd5, this.source);
        rs4.subscribeNext();
    }

    static final class RepeatUntilObserver<T>
    extends AtomicInteger
    implements Observer<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Observer<? super T> downstream;
        final SequentialDisposable upstream;
        final ObservableSource<? extends T> source;
        final BooleanSupplier stop;

        RepeatUntilObserver(Observer<? super T> actual, BooleanSupplier until, SequentialDisposable sd5, ObservableSource<? extends T> source) {
            this.downstream = actual;
            this.upstream = sd5;
            this.source = source;
            this.stop = until;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.upstream.replace(d15);
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            boolean b15;
            try {
                b15 = this.stop.getAsBoolean();
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                return;
            }
            if (b15) {
                this.downstream.onComplete();
            } else {
                this.subscribeNext();
            }
        }

        void subscribeNext() {
            block1: {
                if (this.getAndIncrement() != 0) break block1;
                int missed = 1;
                do {
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

