/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.NoSuchElementException;

public final class ObservableLastSingle<T>
extends Single<T> {
    final ObservableSource<T> source;
    final T defaultItem;

    public ObservableLastSingle(ObservableSource<T> source, T defaultItem) {
        this.source = source;
        this.defaultItem = defaultItem;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new LastObserver<T>(observer, this.defaultItem));
    }

    static final class LastObserver<T>
    implements Observer<T>,
    Disposable {
        final SingleObserver<? super T> downstream;
        final T defaultItem;
        Disposable upstream;
        T item;

        LastObserver(SingleObserver<? super T> actual, T defaultItem) {
            this.downstream = actual;
            this.defaultItem = defaultItem;
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream == DisposableHelper.DISPOSED;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            this.item = t15;
        }

        @Override
        public void onError(Throwable t15) {
            this.upstream = DisposableHelper.DISPOSED;
            this.item = null;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.upstream = DisposableHelper.DISPOSED;
            T v15 = this.item;
            if (v15 != null) {
                this.item = null;
                this.downstream.onSuccess(v15);
            } else {
                v15 = this.defaultItem;
                if (v15 != null) {
                    this.downstream.onSuccess(v15);
                } else {
                    this.downstream.onError(new NoSuchElementException());
                }
            }
        }
    }
}

