/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;

public final class ObservableElementAt<T>
extends AbstractObservableWithUpstream<T, T> {
    final long index;
    final T defaultValue;
    final boolean errorOnFewer;

    public ObservableElementAt(ObservableSource<T> source, long index, T defaultValue, boolean errorOnFewer) {
        super(source);
        this.index = index;
        this.defaultValue = defaultValue;
        this.errorOnFewer = errorOnFewer;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new ElementAtObserver<T>(t15, this.index, this.defaultValue, this.errorOnFewer));
    }

    static final class ElementAtObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final long index;
        final T defaultValue;
        final boolean errorOnFewer;
        Disposable upstream;
        long count;
        boolean done;

        ElementAtObserver(Observer<? super T> actual, long index, T defaultValue, boolean errorOnFewer) {
            this.downstream = actual;
            this.index = index;
            this.defaultValue = defaultValue;
            this.errorOnFewer = errorOnFewer;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            long c15 = this.count;
            if (c15 == this.index) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onNext(t15);
                this.downstream.onComplete();
                return;
            }
            this.count = c15 + 1L;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                T v15 = this.defaultValue;
                if (v15 == null && this.errorOnFewer) {
                    this.downstream.onError(new NoSuchElementException());
                } else {
                    if (v15 != null) {
                        this.downstream.onNext(v15);
                    }
                    this.downstream.onComplete();
                }
            }
        }
    }
}

