/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableCount<T>
extends AbstractObservableWithUpstream<T, Long> {
    public ObservableCount(ObservableSource<T> source) {
        super(source);
    }

    @Override
    public void subscribeActual(Observer<? super Long> t15) {
        this.source.subscribe(new CountObserver(t15));
    }

    static final class CountObserver
    implements Observer<Object>,
    Disposable {
        final Observer<? super Long> downstream;
        Disposable upstream;
        long count;

        CountObserver(Observer<? super Long> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(Object t15) {
            ++this.count;
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.downstream.onNext((Long)this.count);
            this.downstream.onComplete();
        }
    }
}

