/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.observers.BlockingObserver;
import io.reactivex.rxjava3.internal.observers.LambdaObserver;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.BlockingIgnoringReceiver;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public final class ObservableBlockingSubscribe {
    private ObservableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(ObservableSource<? extends T> o15, Observer<? super T> observer) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingObserver bs4 = new BlockingObserver((Queue<Object>)queue);
        observer.onSubscribe(bs4);
        o15.subscribe(bs4);
        while (!bs4.isDisposed()) {
            Object v15 = queue.poll();
            if (v15 == null) {
                try {
                    v15 = queue.take();
                }
                catch (InterruptedException ex4) {
                    bs4.dispose();
                    observer.onError(ex4);
                    return;
                }
            }
            if (!bs4.isDisposed() && v15 != BlockingObserver.TERMINATED && !NotificationLite.acceptFull(v15, observer)) continue;
            break;
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o15) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaObserver ls4 = new LambdaObserver(Functions.emptyConsumer(), callback, callback, Functions.emptyConsumer());
        o15.subscribe(ls4);
        BlockingHelper.awaitForComplete(callback, ls4);
        Throwable e15 = callback.error;
        if (e15 != null) {
            throw ExceptionHelper.wrapOrThrow(e15);
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o15, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        ObservableBlockingSubscribe.subscribe(o15, new LambdaObserver<T>(onNext, onError, onComplete, Functions.emptyConsumer()));
    }
}

