/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.maybe.AbstractMaybeWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class MaybePeek<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Consumer<? super Disposable> onSubscribeCall;
    final Consumer<? super T> onSuccessCall;
    final Consumer<? super Throwable> onErrorCall;
    final Action onCompleteCall;
    final Action onAfterTerminate;
    final Action onDisposeCall;

    public MaybePeek(MaybeSource<T> source, Consumer<? super Disposable> onSubscribeCall, Consumer<? super T> onSuccessCall, Consumer<? super Throwable> onErrorCall, Action onCompleteCall, Action onAfterTerminate, Action onDispose) {
        super(source);
        this.onSubscribeCall = onSubscribeCall;
        this.onSuccessCall = onSuccessCall;
        this.onErrorCall = onErrorCall;
        this.onCompleteCall = onCompleteCall;
        this.onAfterTerminate = onAfterTerminate;
        this.onDisposeCall = onDispose;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new MaybePeekObserver<T>(observer, this));
    }

    static final class MaybePeekObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final MaybePeek<T> parent;
        Disposable upstream;

        MaybePeekObserver(MaybeObserver<? super T> actual, MaybePeek<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void dispose() {
            try {
                this.parent.onDisposeCall.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                try {
                    this.parent.onSubscribeCall.accept(d15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    d15.dispose();
                    this.upstream = DisposableHelper.DISPOSED;
                    EmptyDisposable.error(ex4, this.downstream);
                    return;
                }
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            if (this.upstream == DisposableHelper.DISPOSED) {
                return;
            }
            try {
                this.parent.onSuccessCall.accept(value);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.onErrorInner(ex4);
                return;
            }
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onSuccess(value);
            this.onAfterTerminate();
        }

        @Override
        public void onError(Throwable e15) {
            if (this.upstream == DisposableHelper.DISPOSED) {
                RxJavaPlugins.onError(e15);
                return;
            }
            this.onErrorInner(e15);
        }

        void onErrorInner(Throwable e15) {
            try {
                this.parent.onErrorCall.accept(e15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                e15 = new CompositeException(e15, ex4);
            }
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(e15);
            this.onAfterTerminate();
        }

        @Override
        public void onComplete() {
            if (this.upstream == DisposableHelper.DISPOSED) {
                return;
            }
            try {
                this.parent.onCompleteCall.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.onErrorInner(ex4);
                return;
            }
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onComplete();
            this.onAfterTerminate();
        }

        void onAfterTerminate() {
            try {
                this.parent.onAfterTerminate.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

