/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableZip<T, R>
extends Flowable<R> {
    final Publisher<? extends T>[] sources;
    final Iterable<? extends Publisher<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public FlowableZip(Publisher<? extends T>[] sources, Iterable<? extends Publisher<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s15) {
        Publisher<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Publisher[8];
            for (Publisher<? extends T> publisher : this.sourcesIterable) {
                if (count == sources.length) {
                    Publisher[] b15 = new Publisher[count + (count >> 2)];
                    System.arraycopy(sources, 0, b15, 0, count);
                    sources = b15;
                }
                sources[count++] = publisher;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s15);
            return;
        }
        ZipCoordinator<? extends T, R> coordinator = new ZipCoordinator<T, R>(s15, this.zipper, count, this.bufferSize, this.delayError);
        s15.onSubscribe(coordinator);
        coordinator.subscribe(sources, count);
    }

    static final class ZipSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4627193790118206028L;
        final ZipCoordinator<T, R> parent;
        final int prefetch;
        final int limit;
        SimpleQueue<T> queue;
        long produced;
        volatile boolean done;
        int sourceMode;

        ZipSubscriber(ZipCoordinator<T, R> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.setOnce(this, s15)) {
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription f15 = (QueueSubscription)s15;
                    int m15 = f15.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = f15;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = f15;
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s15.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.sourceMode != 2) {
                this.queue.offer(t15);
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.error(this, t15);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public void request(long n15) {
            if (this.sourceMode != 1) {
                long p15 = this.produced + n15;
                if (p15 >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p15);
                } else {
                    this.produced = p15;
                }
            }
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = -2434867452883857743L;
        final Subscriber<? super R> downstream;
        final ZipSubscriber<T, R>[] subscribers;
        final Function<? super Object[], ? extends R> zipper;
        final AtomicLong requested;
        final AtomicThrowable errors;
        final boolean delayErrors;
        volatile boolean cancelled;
        final Object[] current;

        ZipCoordinator(Subscriber<? super R> actual, Function<? super Object[], ? extends R> zipper, int n15, int prefetch, boolean delayErrors) {
            this.downstream = actual;
            this.zipper = zipper;
            this.delayErrors = delayErrors;
            ZipSubscriber[] a15 = new ZipSubscriber[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                a15[i15] = new ZipSubscriber(this, prefetch);
            }
            this.current = new Object[n15];
            this.subscribers = a15;
            this.requested = new AtomicLong();
            this.errors = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T>[] sources, int n15) {
            ZipSubscriber<T, R>[] a15 = this.subscribers;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (this.cancelled || !this.delayErrors && this.errors.get() != null) {
                    return;
                }
                sources[i15].subscribe(a15[i15]);
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
            }
        }

        void error(ZipSubscriber<T, R> inner, Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                inner.done = true;
                this.drain();
            }
        }

        void cancelAll() {
            for (ZipSubscriber<T, R> s15 : this.subscribers) {
                s15.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a15 = this.downstream;
            ZipSubscriber<T, R>[] qs4 = this.subscribers;
            int n15 = qs4.length;
            Object[] values2 = this.current;
            int missed = 1;
            do {
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; r15 != e15; ++e15) {
                    R v15;
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    boolean empty = false;
                    for (int j15 = 0; j15 < n15; ++j15) {
                        boolean sourceEmpty;
                        ZipSubscriber<T, R> inner = qs4[j15];
                        if (values2[j15] != null) continue;
                        boolean d15 = inner.done;
                        SimpleQueue q15 = inner.queue;
                        Object v16 = null;
                        try {
                            v16 = q15 != null ? q15.poll() : null;
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            this.errors.tryAddThrowableOrReport(ex4);
                            if (!this.delayErrors) {
                                this.cancelAll();
                                this.errors.tryTerminateConsumer(a15);
                                return;
                            }
                            d15 = true;
                        }
                        boolean bl4 = sourceEmpty = v16 == null;
                        if (d15 && sourceEmpty) {
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(a15);
                            return;
                        }
                        if (!sourceEmpty) {
                            values2[j15] = v16;
                            continue;
                        }
                        empty = true;
                    }
                    if (empty) break;
                    try {
                        v15 = Objects.requireNonNull(this.zipper.apply((Object[])values2.clone()), "The zipper returned a null value");
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        this.cancelAll();
                        this.errors.tryAddThrowableOrReport(ex5);
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    a15.onNext(v15);
                    Arrays.fill(values2, null);
                }
                if (r15 == e15) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    for (int j16 = 0; j16 < n15; ++j16) {
                        boolean empty;
                        ZipSubscriber<T, R> inner = qs4[j16];
                        if (values2[j16] != null) continue;
                        boolean d16 = inner.done;
                        SimpleQueue q16 = inner.queue;
                        Object v17 = null;
                        try {
                            v17 = q16 != null ? q16.poll() : null;
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            this.errors.tryAddThrowableOrReport(ex6);
                            if (!this.delayErrors) {
                                this.cancelAll();
                                this.errors.tryTerminateConsumer(a15);
                                return;
                            }
                            d16 = true;
                        }
                        boolean bl5 = empty = v17 == null;
                        if (d16 && empty) {
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(a15);
                            return;
                        }
                        if (empty) continue;
                        values2[j16] = v17;
                    }
                }
                if (e15 == 0L) continue;
                for (ZipSubscriber<T, R> inner : qs4) {
                    inner.request(e15);
                }
                if (r15 == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

