/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableScanSeed<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Supplier<R> seedSupplier;

    public FlowableScanSeed(Flowable<T> source, Supplier<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        R r15;
        try {
            r15 = Objects.requireNonNull(this.seedSupplier.get(), "The seed supplied is null");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptySubscription.error(e15, s15);
            return;
        }
        this.source.subscribe(new ScanSeedSubscriber<T, R>(s15, this.accumulator, r15, FlowableScanSeed.bufferSize()));
    }

    static final class ScanSeedSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -1776795561228106469L;
        final Subscriber<? super R> downstream;
        final BiFunction<R, ? super T, R> accumulator;
        final SimplePlainQueue<R> queue;
        final AtomicLong requested;
        final int prefetch;
        final int limit;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        Subscription upstream;
        R value;
        int consumed;

        ScanSeedSubscriber(Subscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value, int prefetch) {
            this.downstream = actual;
            this.accumulator = accumulator;
            this.value = value;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.queue = new SpscArrayQueue<R>(prefetch);
            this.queue.offer(value);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(this.prefetch - 1);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            R v15 = this.value;
            try {
                v15 = Objects.requireNonNull(this.accumulator.apply(v15, t15), "The accumulator returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.cancel();
                this.onError(ex4);
                return;
            }
            this.value = v15;
            this.queue.offer(v15);
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> a15 = this.downstream;
            SimplePlainQueue<R> q15 = this.queue;
            int lim = this.limit;
            int c15 = this.consumed;
            do {
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    boolean empty;
                    Throwable ex4;
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    boolean d15 = this.done;
                    if (d15 && (ex4 = this.error) != null) {
                        q15.clear();
                        a15.onError(ex4);
                        return;
                    }
                    R v15 = q15.poll();
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        a15.onComplete();
                        return;
                    }
                    if (empty) break;
                    a15.onNext(v15);
                    if (++c15 != lim) continue;
                    c15 = 0;
                    this.upstream.request(lim);
                }
                if (e15 == r15 && this.done) {
                    Throwable ex5 = this.error;
                    if (ex5 != null) {
                        q15.clear();
                        a15.onError(ex5);
                        return;
                    }
                    if (q15.isEmpty()) {
                        a15.onComplete();
                        return;
                    }
                }
                if (e15 != 0L) {
                    BackpressureHelper.produced(this.requested, e15);
                }
                this.consumed = c15;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

