/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRetryPredicate<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super Throwable> predicate;
    final long count;

    public FlowableRetryPredicate(Flowable<T> source, long count, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
        this.count = count;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        SubscriptionArbiter sa5 = new SubscriptionArbiter(false);
        s15.onSubscribe(sa5);
        RetrySubscriber<T> rs4 = new RetrySubscriber<T>(s15, this.count, this.predicate, sa5, this.source);
        rs4.subscribeNext();
    }

    static final class RetrySubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> downstream;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        final Predicate<? super Throwable> predicate;
        long remaining;
        long produced;

        RetrySubscriber(Subscriber<? super T> actual, long count, Predicate<? super Throwable> predicate, SubscriptionArbiter sa5, Publisher<? extends T> source) {
            this.downstream = actual;
            this.sa = sa5;
            this.source = source;
            this.predicate = predicate;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            this.sa.setSubscription(s15);
        }

        @Override
        public void onNext(T t15) {
            ++this.produced;
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            long r15 = this.remaining;
            if (r15 != Long.MAX_VALUE) {
                this.remaining = r15 - 1L;
            }
            if (r15 == 0L) {
                this.downstream.onError(t15);
            } else {
                boolean b15;
                try {
                    b15 = this.predicate.test(t15);
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.downstream.onError(new CompositeException(t15, e15));
                    return;
                }
                if (!b15) {
                    this.downstream.onError(t15);
                    return;
                }
                this.subscribeNext();
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        void subscribeNext() {
            block3: {
                if (this.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    long p15 = this.produced;
                    if (p15 != 0L) {
                        this.produced = 0L;
                        this.sa.produced(p15);
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

