/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends U> mapper;

    public FlowableMap(Flowable<T> source, Function<? super T, ? extends U> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapConditionalSubscriber<T, U>((ConditionalSubscriber)s15, this.mapper));
        } else {
            this.source.subscribe(new MapSubscriber<T, U>(s15, this.mapper));
        }
    }

    static final class MapConditionalSubscriber<T, U>
    extends BasicFuseableConditionalSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapConditionalSubscriber(ConditionalSubscriber<? super U> actual, Function<? super T, ? extends U> function) {
            super(actual);
            this.mapper = function;
        }

        @Override
        public void onNext(T t15) {
            U v15;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper function returned a null value.");
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return;
            }
            this.downstream.onNext(v15);
        }

        @Override
        public boolean tryOnNext(T t15) {
            U v15;
            if (this.done) {
                return true;
            }
            if (this.sourceMode != 0) {
                this.downstream.tryOnNext(null);
                return true;
            }
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper function returned a null value.");
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return true;
            }
            return this.downstream.tryOnNext(v15);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Throwable {
            Object t15 = this.qs.poll();
            return t15 != null ? (U)Objects.requireNonNull(this.mapper.apply(t15), "The mapper function returned a null value.") : null;
        }
    }

    static final class MapSubscriber<T, U>
    extends BasicFuseableSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t15) {
            U v15;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper function returned a null value.");
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return;
            }
            this.downstream.onNext(v15);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Throwable {
            Object t15 = this.qs.poll();
            return t15 != null ? (U)Objects.requireNonNull(this.mapper.apply(t15), "The mapper function returned a null value.") : null;
        }
    }
}

