/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.fuseable.CancellableQueueFuseable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;

public final class FlowableFromRunnable<T>
extends Flowable<T>
implements Supplier<T> {
    final Runnable run;

    public FlowableFromRunnable(Runnable run) {
        this.run = run;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> subscriber) {
        CancellableQueueFuseable qs4 = new CancellableQueueFuseable();
        subscriber.onSubscribe(qs4);
        if (!qs4.isDisposed()) {
            try {
                this.run.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                if (!qs4.isDisposed()) {
                    subscriber.onError(ex4);
                } else {
                    RxJavaPlugins.onError(ex4);
                }
                return;
            }
            if (!qs4.isDisposed()) {
                subscriber.onComplete();
            }
        }
    }

    @Override
    public T get() throws Throwable {
        this.run.run();
        return null;
    }
}

