/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.fuseable.AbstractEmptyQueueFuseable;
import io.reactivex.rxjava3.internal.fuseable.HasUpstreamCompletableSource;
import org.reactivestreams.Subscriber;

public final class FlowableFromCompletable<T>
extends Flowable<T>
implements HasUpstreamCompletableSource {
    final CompletableSource source;

    public FlowableFromCompletable(CompletableSource source) {
        this.source = source;
    }

    @Override
    public CompletableSource source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> observer) {
        this.source.subscribe(new FromCompletableObserver<T>(observer));
    }

    public static final class FromCompletableObserver<T>
    extends AbstractEmptyQueueFuseable<T>
    implements CompletableObserver {
        final Subscriber<? super T> downstream;
        Disposable upstream;

        public FromCompletableObserver(Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void cancel() {
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onComplete() {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e15) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(e15);
        }
    }
}

