/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMergeArrayDelayError;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeDelayErrorIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeDelayErrorIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        Iterator<? extends CompletableSource> iterator2;
        CompositeDisposable set = new CompositeDisposable();
        observer.onSubscribe(set);
        try {
            iterator2 = Objects.requireNonNull(this.sources.iterator(), "The source iterator returned is null");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            observer.onError(e15);
            return;
        }
        AtomicInteger wip = new AtomicInteger(1);
        AtomicThrowable errors = new AtomicThrowable();
        set.add(new CompletableMergeArrayDelayError.TryTerminateAndReportDisposable(errors));
        while (true) {
            CompletableSource c15;
            boolean b15;
            if (set.isDisposed()) {
                return;
            }
            try {
                b15 = iterator2.hasNext();
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                errors.tryAddThrowableOrReport(e16);
                break;
            }
            if (!b15) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c15 = Objects.requireNonNull(iterator2.next(), "The iterator returned a null CompletableSource");
            }
            catch (Throwable e17) {
                Exceptions.throwIfFatal(e17);
                errors.tryAddThrowableOrReport(e17);
                break;
            }
            if (set.isDisposed()) {
                return;
            }
            wip.getAndIncrement();
            c15.subscribe(new CompletableMergeArrayDelayError.MergeInnerCompletableObserver(observer, set, errors, wip));
        }
        if (wip.decrementAndGet() == 0) {
            errors.tryTerminateConsumer(observer);
        }
    }
}

