/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import java.util.concurrent.CountDownLatch;

public final class BlockingDisposableMultiObserver<T>
extends CountDownLatch
implements MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver,
Disposable {
    T value;
    Throwable error;
    final SequentialDisposable upstream = new SequentialDisposable();

    public BlockingDisposableMultiObserver() {
        super(1);
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
        this.countDown();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void onSubscribe(@NonNull Disposable d15) {
        DisposableHelper.setOnce(this.upstream, d15);
    }

    @Override
    public void onSuccess(@NonNull T t15) {
        this.value = t15;
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    @Override
    public void onError(@NonNull Throwable e15) {
        this.error = e15;
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    @Override
    public void onComplete() {
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    public void blockingConsume(CompletableObserver observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex4) {
                this.dispose();
                observer.onError(ex4);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex5 = this.error;
        if (ex5 != null) {
            observer.onError(ex5);
        } else {
            observer.onComplete();
        }
    }

    public void blockingConsume(SingleObserver<? super T> observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex4) {
                this.dispose();
                observer.onError(ex4);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex5 = this.error;
        if (ex5 != null) {
            observer.onError(ex5);
        } else {
            observer.onSuccess(this.value);
        }
    }

    public void blockingConsume(MaybeObserver<? super T> observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex4) {
                this.dispose();
                observer.onError(ex4);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex5 = this.error;
        if (ex5 != null) {
            observer.onError(ex5);
        } else {
            T v15 = this.value;
            if (v15 == null) {
                observer.onComplete();
            } else {
                observer.onSuccess(v15);
            }
        }
    }
}

