/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import java.util.Objects;
import java.util.Optional;
import org.reactivestreams.Subscriber;

public final class FlowableMapOptional<T, R>
extends Flowable<R> {
    final Flowable<T> source;
    final Function<? super T, Optional<? extends R>> mapper;

    public FlowableMapOptional(Flowable<T> source, Function<? super T, Optional<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapOptionalConditionalSubscriber<T, R>((ConditionalSubscriber)s15, this.mapper));
        } else {
            this.source.subscribe(new MapOptionalSubscriber<T, R>(s15, this.mapper));
        }
    }

    static final class MapOptionalConditionalSubscriber<T, R>
    extends BasicFuseableConditionalSubscriber<T, R> {
        final Function<? super T, Optional<? extends R>> mapper;

        MapOptionalConditionalSubscriber(ConditionalSubscriber<? super R> downstream, Function<? super T, Optional<? extends R>> mapper) {
            super(downstream);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            Optional<R> result;
            if (this.done) {
                return true;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return true;
            }
            try {
                result = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Optional");
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return true;
            }
            if (result.isPresent()) {
                return this.downstream.tryOnNext(result.get());
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public R poll() throws Throwable {
            Object item;
            while ((item = this.qs.poll()) != null) {
                Optional<R> result = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null Optional");
                if (result.isPresent()) {
                    return result.get();
                }
                if (this.sourceMode != 2) continue;
                this.qs.request(1L);
            }
            return null;
        }
    }

    static final class MapOptionalSubscriber<T, R>
    extends BasicFuseableSubscriber<T, R>
    implements ConditionalSubscriber<T> {
        final Function<? super T, Optional<? extends R>> mapper;

        MapOptionalSubscriber(Subscriber<? super R> downstream, Function<? super T, Optional<? extends R>> mapper) {
            super(downstream);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            Optional<R> result;
            if (this.done) {
                return true;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return true;
            }
            try {
                result = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Optional");
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return true;
            }
            if (result.isPresent()) {
                this.downstream.onNext(result.get());
                return true;
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public R poll() throws Throwable {
            Object item;
            while ((item = this.qs.poll()) != null) {
                Optional<R> result = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null Optional");
                if (result.isPresent()) {
                    return result.get();
                }
                if (this.sourceMode != 2) continue;
                this.qs.request(1L);
            }
            return null;
        }
    }
}

