/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.core;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.Objects;

public final class Notification<T> {
    final Object value;
    static final Notification<Object> COMPLETE = new Notification(null);

    private Notification(@Nullable Object value) {
        this.value = value;
    }

    public boolean isOnComplete() {
        return this.value == null;
    }

    public boolean isOnError() {
        return NotificationLite.isError(this.value);
    }

    public boolean isOnNext() {
        Object o15 = this.value;
        return o15 != null && !NotificationLite.isError(o15);
    }

    @Nullable
    public T getValue() {
        Object o15 = this.value;
        if (o15 != null && !NotificationLite.isError(o15)) {
            return (T)this.value;
        }
        return null;
    }

    @Nullable
    public Throwable getError() {
        Object o15 = this.value;
        if (NotificationLite.isError(o15)) {
            return NotificationLite.getError(o15);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Notification) {
            Notification n15 = (Notification)obj;
            return Objects.equals(this.value, n15.value);
        }
        return false;
    }

    public int hashCode() {
        Object o15 = this.value;
        return o15 != null ? o15.hashCode() : 0;
    }

    public String toString() {
        Object o15 = this.value;
        if (o15 == null) {
            return "OnCompleteNotification";
        }
        if (NotificationLite.isError(o15)) {
            return "OnErrorNotification[" + NotificationLite.getError(o15) + "]";
        }
        return "OnNextNotification[" + this.value + "]";
    }

    @NonNull
    public static <T> Notification<T> createOnNext(T value) {
        Objects.requireNonNull(value, "value is null");
        return new Notification<T>(value);
    }

    @NonNull
    public static <T> Notification<T> createOnError(@NonNull Throwable error) {
        Objects.requireNonNull(error, "error is null");
        return new Notification<T>(NotificationLite.error(error));
    }

    @NonNull
    public static <T> Notification<T> createOnComplete() {
        return COMPLETE;
    }
}

