/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.ole2;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.LittleEndianRandomAccessFile;
import com.twelvemonkeys.io.MemoryCacheSeekableStream;
import com.twelvemonkeys.io.Seekable;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.ole2.CorruptDocumentException;
import com.twelvemonkeys.io.ole2.Entry;
import com.twelvemonkeys.io.ole2.SIdChain;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.imageio.stream.ImageInputStream;

public final class CompoundDocument
implements AutoCloseable {
    static final byte[] MAGIC = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final int FREE_SID = -1;
    private static final int END_OF_CHAIN_SID = -2;
    private static final int SAT_SECTOR_SID = -3;
    private static final int MSAT_SECTOR_SID = -4;
    public static final int HEADER_SIZE = 512;
    public static final long EPOCH_OFFSET = -11644477200000L;
    private final DataInput input;
    private UUID uUID;
    private int sectorSize;
    private int shortSectorSize;
    private int directorySId;
    private int minStreamSize;
    private int shortSATSId;
    private int shortSATSize;
    private int[] masterSAT;
    private int[] SAT;
    private int[] shortSAT;
    private Entry rootEntry;
    private SIdChain shortStreamSIdChain;
    private SIdChain directorySIdChain;

    public CompoundDocument(File file2) throws IOException {
        this.input = new LittleEndianRandomAccessFile(FileUtil.resolve(file2), "r");
        this.readHeader();
    }

    public CompoundDocument(InputStream inputStream) throws IOException {
        this(new MemoryCacheSeekableStream(inputStream));
    }

    CompoundDocument(SeekableInputStream seekableInputStream) throws IOException {
        this.input = new SeekableLittleEndianDataInputStream(seekableInputStream);
        this.readHeader();
    }

    public CompoundDocument(ImageInputStream imageInputStream) throws IOException {
        this.input = Validate.notNull(imageInputStream, "input");
        imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.readHeader();
    }

    @Override
    public void close() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            ((RandomAccessFile)this.input).close();
        } else if (this.input instanceof LittleEndianRandomAccessFile) {
            ((LittleEndianRandomAccessFile)this.input).close();
        }
    }

    public static boolean canRead(DataInput dataInput) {
        return CompoundDocument.canRead(dataInput, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canRead(DataInput dataInput, boolean bl4) {
        long l15;
        block26: {
            l15 = -1L;
            if (bl4) {
                try {
                    if (dataInput instanceof InputStream && ((InputStream)((Object)dataInput)).markSupported()) {
                        ((InputStream)((Object)dataInput)).mark(8);
                        break block26;
                    }
                    if (dataInput instanceof ImageInputStream) {
                        ((ImageInputStream)dataInput).mark();
                        break block26;
                    }
                    if (dataInput instanceof RandomAccessFile) {
                        l15 = ((RandomAccessFile)dataInput).getFilePointer();
                        break block26;
                    }
                    if (dataInput instanceof LittleEndianRandomAccessFile) {
                        l15 = ((LittleEndianRandomAccessFile)dataInput).getFilePointer();
                        break block26;
                    }
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        try {
            byte[] byArray = new byte[8];
            dataInput.readFully(byArray);
            boolean bl5 = Arrays.equals(byArray, MAGIC);
            return bl5;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bl4) {
                try {
                    if (dataInput instanceof InputStream && ((InputStream)((Object)dataInput)).markSupported()) {
                        ((InputStream)((Object)dataInput)).reset();
                    } else if (dataInput instanceof ImageInputStream) {
                        ((ImageInputStream)dataInput).reset();
                    } else if (dataInput instanceof RandomAccessFile) {
                        ((RandomAccessFile)dataInput).seek(l15);
                    } else if (dataInput instanceof LittleEndianRandomAccessFile) {
                        ((LittleEndianRandomAccessFile)dataInput).seek(l15);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return false;
    }

    private void readHeader() throws IOException {
        int n15;
        if (this.masterSAT != null) {
            return;
        }
        if (!CompoundDocument.canRead(this.input, false)) {
            throw new CorruptDocumentException("Not an OLE 2 Compound Document");
        }
        this.uUID = new UUID(this.input.readLong(), this.input.readLong());
        this.input.readUnsignedShort();
        this.input.readUnsignedShort();
        int n16 = this.input.readUnsignedShort();
        if (n16 == 65535) {
            throw new CorruptDocumentException("Cannot read big endian OLE 2 Compound Documents");
        }
        if (n16 != 65534) {
            throw new CorruptDocumentException(String.format("Unknown byte order marker: 0x%04x, expected 0xfffe or 0xffff", n16));
        }
        this.sectorSize = 1 << this.input.readUnsignedShort();
        this.shortSectorSize = 1 << this.input.readUnsignedShort();
        if (this.skipBytesFully(10) != 10) {
            throw new CorruptDocumentException();
        }
        int n17 = this.input.readInt();
        this.directorySId = this.input.readInt();
        if (this.skipBytesFully(4) != 4) {
            throw new CorruptDocumentException();
        }
        this.minStreamSize = this.input.readInt();
        this.shortSATSId = this.input.readInt();
        this.shortSATSize = this.input.readInt();
        int n18 = this.input.readInt();
        int n19 = this.input.readInt();
        this.masterSAT = new int[n17];
        int n25 = Math.min(n17, 109);
        for (n15 = 0; n15 < n25; ++n15) {
            this.masterSAT[n15] = this.input.readInt();
        }
        if (n18 == -2) {
            n15 = 436 - n17 * 4;
            if (this.skipBytesFully(n15) != n15) {
                throw new CorruptDocumentException();
            }
        } else {
            this.seekToSId(n18, -1L);
            n15 = n25;
            for (int i15 = 0; i15 < n19; ++i15) {
                int n26;
                block5: for (n26 = 0; n26 < 127; ++n26) {
                    int n27 = this.input.readInt();
                    switch (n27) {
                        case -1: {
                            continue block5;
                        }
                        default: {
                            this.masterSAT[n15++] = n27;
                        }
                    }
                }
                n26 = this.input.readInt();
                if (n26 == -2) break;
                this.seekToSId(n26, -1L);
            }
        }
    }

    private int skipBytesFully(int n15) throws IOException {
        int n16;
        int n17;
        for (n16 = n15; n16 > 0 && (n17 = this.input.skipBytes(n15)) > 0; n16 -= n17) {
        }
        return n15 - n16;
    }

    private void readSAT() throws IOException {
        int n15;
        int n16;
        int n17;
        if (this.SAT != null) {
            return;
        }
        int n18 = this.sectorSize / 4;
        this.SAT = new int[this.masterSAT.length * n18];
        for (int i15 = 0; i15 < this.masterSAT.length; ++i15) {
            this.seekToSId(this.masterSAT[i15], -1L);
            for (n17 = 0; n17 < n18; ++n17) {
                n16 = this.input.readInt();
                n15 = n17 + i15 * n18;
                this.SAT[n15] = n16;
            }
        }
        SIdChain sIdChain = this.getSIdChain(this.shortSATSId, -1L);
        this.shortSAT = new int[this.shortSATSize * n18];
        for (n17 = 0; n17 < this.shortSATSize; ++n17) {
            this.seekToSId(sIdChain.get(n17), -1L);
            for (n16 = 0; n16 < n18; ++n16) {
                n15 = this.input.readInt();
                int n19 = n16 + n17 * n18;
                this.shortSAT[n19] = n15;
            }
        }
    }

    private SIdChain getSIdChain(int n15, long l15) throws IOException {
        SIdChain sIdChain = new SIdChain();
        int[] nArray = this.isShortStream(l15) ? this.shortSAT : this.SAT;
        int n16 = n15;
        while (n16 != -2 && n16 != -1) {
            sIdChain.addSID(n16);
            n16 = nArray[n16];
        }
        return sIdChain;
    }

    private boolean isShortStream(long l15) {
        return l15 != -1L && l15 < (long)this.minStreamSize;
    }

    private void seekToSId(int n15, long l15) throws IOException {
        long l16;
        if (this.isShortStream(l15)) {
            Entry entry = this.getRootEntry();
            if (this.shortStreamSIdChain == null) {
                this.shortStreamSIdChain = this.getSIdChain(entry.startSId, entry.streamSize);
            }
            int n16 = this.sectorSize / this.shortSectorSize;
            int n17 = n15 / n16;
            int n18 = n15 - n17 * n16;
            l16 = 512L + (long)this.shortStreamSIdChain.get(n17) * (long)this.sectorSize + (long)n18 * (long)this.shortSectorSize;
        } else {
            l16 = 512L + (long)n15 * (long)this.sectorSize;
        }
        if (this.input instanceof LittleEndianRandomAccessFile) {
            ((LittleEndianRandomAccessFile)this.input).seek(l16);
        } else if (this.input instanceof ImageInputStream) {
            ((ImageInputStream)this.input).seek(l16);
        } else {
            ((SeekableLittleEndianDataInputStream)this.input).seek(l16);
        }
    }

    private void seekToDId(int n15) throws IOException {
        if (this.directorySIdChain == null) {
            this.directorySIdChain = this.getSIdChain(this.directorySId, -1L);
        }
        int n16 = this.sectorSize / 128;
        int n17 = n15 / n16;
        int n18 = n15 - n17 * n16;
        int n19 = this.directorySIdChain.get(n17);
        this.seekToSId(n19, -1L);
        if (this.input instanceof LittleEndianRandomAccessFile) {
            LittleEndianRandomAccessFile littleEndianRandomAccessFile = (LittleEndianRandomAccessFile)this.input;
            littleEndianRandomAccessFile.seek(littleEndianRandomAccessFile.getFilePointer() + (long)(n18 * 128));
        } else if (this.input instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)this.input;
            imageInputStream.seek(imageInputStream.getStreamPosition() + (long)(n18 * 128));
        } else {
            SeekableLittleEndianDataInputStream seekableLittleEndianDataInputStream = (SeekableLittleEndianDataInputStream)this.input;
            seekableLittleEndianDataInputStream.seek(seekableLittleEndianDataInputStream.getStreamPosition() + (long)(n18 * 128));
        }
    }

    SeekableInputStream getInputStreamForSId(int n15, int n16) throws IOException {
        SIdChain sIdChain = this.getSIdChain(n15, n16);
        int n17 = n16 < this.minStreamSize ? this.shortSectorSize : this.sectorSize;
        return new MemoryCacheSeekableStream(new Stream(sIdChain, n16, n17, this));
    }

    private InputStream getDirectoryStreamForDId(int n15) throws IOException {
        byte[] byArray = new byte[128];
        this.seekToDId(n15);
        this.input.readFully(byArray);
        return new ByteArrayInputStream(byArray);
    }

    Entry getEntry(int n15, Entry entry) throws IOException {
        Entry entry2 = Entry.readEntry(new LittleEndianDataInputStream(this.getDirectoryStreamForDId(n15)));
        entry2.parent = entry;
        entry2.document = this;
        return entry2;
    }

    SortedSet<Entry> getEntries(int n15, Entry entry) throws IOException {
        return this.getEntriesRecursive(n15, entry, new TreeSet<Entry>());
    }

    private SortedSet<Entry> getEntriesRecursive(int n15, Entry entry, SortedSet<Entry> sortedSet) throws IOException {
        Entry entry2 = this.getEntry(n15, entry);
        if (!sortedSet.add(entry2)) {
            throw new CorruptDocumentException("Cyclic chain reference for entry: " + n15);
        }
        if (entry2.prevDId != -1) {
            this.getEntriesRecursive(entry2.prevDId, entry, sortedSet);
        }
        if (entry2.nextDId != -1) {
            this.getEntriesRecursive(entry2.nextDId, entry, sortedSet);
        }
        return sortedSet;
    }

    Entry getEntry(String string) throws IOException {
        String string2;
        String[] stringArray;
        if (StringUtil.isEmpty(string) || !string.startsWith("/")) {
            throw new IllegalArgumentException("Path must be absolute, and contain a valid path: " + string);
        }
        Entry entry = this.getRootEntry();
        if (string.equals("/")) {
            return entry;
        }
        String[] stringArray2 = stringArray = StringUtil.toStringArray(string, "/");
        int n15 = stringArray2.length;
        for (int i15 = 0; i15 < n15 && (entry = entry.getChildEntry(string2 = stringArray2[i15])) != null; ++i15) {
        }
        return entry;
    }

    public Entry getRootEntry() throws IOException {
        if (this.rootEntry == null) {
            this.readSAT();
            this.rootEntry = this.getEntry(0, null);
            if (this.rootEntry.type != 5) {
                throw new CorruptDocumentException("Invalid root storage type: " + this.rootEntry.type);
            }
        }
        return this.rootEntry;
    }

    public String toString() {
        return String.format("%s[uuid: %s, sector size: %d/%d bytes, directory SID: %d, master SAT: %s entries]", this.getClass().getSimpleName(), this.uUID, this.sectorSize, this.shortSectorSize, this.directorySId, this.masterSAT.length);
    }

    public static long toJavaTimeInMillis(long l15) {
        if (l15 == 0L) {
            return 0L;
        }
        return (l15 >> 1) / 5000L + -11644477200000L;
    }

    static class SeekableLittleEndianDataInputStream
    extends LittleEndianDataInputStream
    implements Seekable {
        private final SeekableInputStream seekable;

        public SeekableLittleEndianDataInputStream(SeekableInputStream seekableInputStream) {
            super(seekableInputStream);
            this.seekable = seekableInputStream;
        }

        @Override
        public void seek(long l15) throws IOException {
            this.seekable.seek(l15);
        }

        @Override
        public boolean isCachedFile() {
            return this.seekable.isCachedFile();
        }

        @Override
        public boolean isCachedMemory() {
            return this.seekable.isCachedMemory();
        }

        @Override
        public boolean isCached() {
            return this.seekable.isCached();
        }

        @Override
        public long getStreamPosition() throws IOException {
            return this.seekable.getStreamPosition();
        }

        @Override
        public long getFlushedPosition() throws IOException {
            return this.seekable.getFlushedPosition();
        }

        @Override
        public void flushBefore(long l15) throws IOException {
            this.seekable.flushBefore(l15);
        }

        @Override
        public void flush() throws IOException {
            this.seekable.flush();
        }

        @Override
        public void reset() throws IOException {
            this.seekable.reset();
        }

        @Override
        public void mark() {
            this.seekable.mark();
        }
    }

    static class Stream
    extends InputStream {
        private final SIdChain chain;
        private final CompoundDocument document;
        private final long length;
        private long streamPos;
        private int nextSectorPos;
        private byte[] buffer;
        private int bufferPos;

        public Stream(SIdChain sIdChain, int n15, int n16, CompoundDocument compoundDocument) {
            this.chain = sIdChain;
            this.length = n15;
            this.buffer = new byte[n16];
            this.bufferPos = this.buffer.length;
            this.document = compoundDocument;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)(this.buffer.length - this.bufferPos), this.length - this.streamPos);
        }

        @Override
        public int read() throws IOException {
            if (this.available() <= 0 && !this.fillBuffer()) {
                return -1;
            }
            ++this.streamPos;
            return this.buffer[this.bufferPos++] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fillBuffer() throws IOException {
            if (this.streamPos < this.length && this.nextSectorPos < this.chain.length()) {
                CompoundDocument compoundDocument = this.document;
                synchronized (compoundDocument) {
                    this.document.seekToSId(this.chain.get(this.nextSectorPos), this.length);
                    this.document.input.readFully(this.buffer);
                }
                ++this.nextSectorPos;
                this.bufferPos = 0;
                return true;
            }
            return false;
        }

        @Override
        public int read(byte[] byArray, int n15, int n16) throws IOException {
            if (this.available() <= 0 && !this.fillBuffer()) {
                return -1;
            }
            int n17 = Math.min(n16, this.available());
            System.arraycopy(this.buffer, this.bufferPos, byArray, n15, n17);
            this.bufferPos += n17;
            this.streamPos += (long)n17;
            return n17;
        }

        @Override
        public void close() throws IOException {
            this.buffer = null;
        }
    }
}

