/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Encoder;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class EncoderStream
extends FilterOutputStream {
    private final Encoder encoder;
    private final boolean flushOnWrite;
    private final ByteBuffer buffer;

    public EncoderStream(OutputStream outputStream, Encoder encoder) {
        this(outputStream, encoder, false);
    }

    public EncoderStream(OutputStream outputStream, Encoder encoder, boolean bl4) {
        super(outputStream);
        this.encoder = encoder;
        this.flushOnWrite = bl4;
        this.buffer = ByteBuffer.allocate(1024);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.encodeBuffer();
        super.flush();
    }

    private void encodeBuffer() throws IOException {
        if (this.buffer.position() != 0) {
            this.buffer.flip();
            this.encoder.encode(this.out, this.buffer);
            this.buffer.clear();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n15, int n16) throws IOException {
        if (!this.flushOnWrite && n16 < this.buffer.remaining()) {
            this.buffer.put(byArray, n15, n16);
        } else {
            this.encodeBuffer();
            this.encoder.encode(this.out, ByteBuffer.wrap(byArray, n15, n16));
        }
    }

    @Override
    public void write(int n15) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.encodeBuffer();
        }
        this.buffer.put((byte)n15);
    }
}

