/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class Base64Decoder
implements Decoder {
    static final byte[] PEM_ARRAY;
    static final byte[] PEM_CONVERT_ARRAY;
    private byte[] decodeBuffer = new byte[4];

    protected static int readFully(InputStream inputStream, byte[] byArray, int n15, int n16) throws IOException {
        for (int i15 = 0; i15 < n16; ++i15) {
            int n17 = inputStream.read();
            if (n17 == -1) {
                return i15 != 0 ? i15 : -1;
            }
            byArray[i15 + n15] = (byte)n17;
        }
        return n16;
    }

    protected boolean decodeAtom(InputStream inputStream, ByteBuffer byteBuffer, int n15) throws IOException {
        int n16;
        int n17 = -1;
        int n18 = -1;
        int n19 = -1;
        int n25 = -1;
        if (n15 < 2) {
            throw new IOException("BASE64Decoder: Not enough bytes for an atom.");
        }
        do {
            if ((n16 = inputStream.read()) != -1) continue;
            return false;
        } while (n16 == 10 || n16 == 13);
        this.decodeBuffer[0] = (byte)n16;
        n16 = Base64Decoder.readFully(inputStream, this.decodeBuffer, 1, n15 - 1);
        if (n16 == -1) {
            return false;
        }
        int n26 = n15;
        if (n26 > 3 && this.decodeBuffer[3] == 61) {
            n26 = 3;
        }
        if (n26 > 2 && this.decodeBuffer[2] == 61) {
            n26 = 2;
        }
        switch (n26) {
            case 4: {
                n25 = PEM_CONVERT_ARRAY[this.decodeBuffer[3] & 0xFF];
            }
            case 3: {
                n19 = PEM_CONVERT_ARRAY[this.decodeBuffer[2] & 0xFF];
            }
            case 2: {
                n18 = PEM_CONVERT_ARRAY[this.decodeBuffer[1] & 0xFF];
                n17 = PEM_CONVERT_ARRAY[this.decodeBuffer[0] & 0xFF];
            }
        }
        switch (n26) {
            case 2: {
                byteBuffer.put((byte)(n17 << 2 & 0xFC | n18 >>> 4 & 3));
                break;
            }
            case 3: {
                byteBuffer.put((byte)(n17 << 2 & 0xFC | n18 >>> 4 & 3));
                byteBuffer.put((byte)(n18 << 4 & 0xF0 | n19 >>> 2 & 0xF));
                break;
            }
            case 4: {
                byteBuffer.put((byte)(n17 << 2 & 0xFC | n18 >>> 4 & 3));
                byteBuffer.put((byte)(n18 << 4 & 0xF0 | n19 >>> 2 & 0xF));
                byteBuffer.put((byte)(n19 << 6 & 0xC0 | n25 & 0x3F));
            }
        }
        return true;
    }

    @Override
    public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        int n15;
        int n16;
        do {
            n16 = 72;
            n15 = 0;
            while (n15 + 4 < n16 && this.decodeAtom(inputStream, byteBuffer, 4)) {
                n15 += 4;
            }
        } while (this.decodeAtom(inputStream, byteBuffer, n16 - n15) && byteBuffer.remaining() > 54);
        return byteBuffer.position();
    }

    static {
        int n15;
        PEM_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        PEM_CONVERT_ARRAY = new byte[256];
        for (n15 = 0; n15 < 255; ++n15) {
            Base64Decoder.PEM_CONVERT_ARRAY[n15] = -1;
        }
        for (n15 = 0; n15 < PEM_ARRAY.length; ++n15) {
            Base64Decoder.PEM_CONVERT_ARRAY[Base64Decoder.PEM_ARRAY[n15]] = (byte)n15;
        }
    }
}

