/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FileUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.channels.FileChannel;

public class LittleEndianRandomAccessFile
implements DataInput,
DataOutput {
    private RandomAccessFile file;

    public LittleEndianRandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(FileUtil.resolve(string), string2);
    }

    public LittleEndianRandomAccessFile(File file2, String string) throws FileNotFoundException {
        this.file = new RandomAccessFile(file2, string);
    }

    public void close() throws IOException {
        this.file.close();
    }

    public FileChannel getChannel() {
        return this.file.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        return this.file.getFD();
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.file.read(byArray);
    }

    public int read(byte[] byArray, int n15, int n16) throws IOException {
        return this.file.read(byArray, n15, n16);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.file.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n15, int n16) throws IOException {
        this.file.readFully(byArray, n15, n16);
    }

    @Override
    public String readLine() throws IOException {
        return this.file.readLine();
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n15 = this.file.read();
        if (n15 < 0) {
            throw new EOFException();
        }
        return n15 != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n15 = this.file.read();
        if (n15 < 0) {
            throw new EOFException();
        }
        return (byte)n15;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n15 = this.file.read();
        if (n15 < 0) {
            throw new EOFException();
        }
        return n15;
    }

    @Override
    public short readShort() throws IOException {
        int n15 = this.file.read();
        int n16 = this.file.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        return (short)((n16 << 24 >>> 16) + (n15 << 24) >>> 24);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n15 = this.file.read();
        int n16 = this.file.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        return (n16 << 8) + n15;
    }

    @Override
    public char readChar() throws IOException {
        int n15 = this.file.read();
        int n16 = this.file.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        return (char)((n16 << 24 >>> 16) + (n15 << 24 >>> 24));
    }

    @Override
    public int readInt() throws IOException {
        int n15 = this.file.read();
        int n16 = this.file.read();
        int n17 = this.file.read();
        int n18 = this.file.read();
        if (n18 < 0) {
            throw new EOFException();
        }
        return (n18 << 24) + (n17 << 24 >>> 8) + (n16 << 24 >>> 16) + (n15 << 24 >>> 24);
    }

    @Override
    public long readLong() throws IOException {
        long l15 = this.file.read();
        long l16 = this.file.read();
        long l17 = this.file.read();
        long l18 = this.file.read();
        long l19 = this.file.read();
        long l25 = this.file.read();
        long l26 = this.file.read();
        long l27 = this.file.read();
        if (l27 < 0L) {
            throw new EOFException();
        }
        return (l27 << 56) + (l26 << 56 >>> 8) + (l25 << 56 >>> 16) + (l19 << 56 >>> 24) + (l18 << 56 >>> 32) + (l17 << 56 >>> 40) + (l16 << 56 >>> 48) + (l15 << 56 >>> 56);
    }

    @Override
    public String readUTF() throws IOException {
        int n15 = this.file.read();
        int n16 = this.file.read();
        if (n16 < 0) {
            throw new EOFException();
        }
        int n17 = (n15 << 8) + n16;
        char[] cArray = new char[n17];
        int n18 = 0;
        int n19 = 0;
        while (n18 < n17) {
            int n25;
            int n26 = this.readUnsignedByte();
            int n27 = n26 >> 4;
            if (n27 < 8) {
                ++n18;
                cArray[n19++] = (char)n26;
                continue;
            }
            if (n27 == 12 || n27 == 13) {
                if ((n18 += 2) > n17) {
                    throw new UTFDataFormatException();
                }
                n25 = this.readUnsignedByte();
                if ((n25 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n19++] = (char)((n26 & 0x1F) << 6 | n25 & 0x3F);
                continue;
            }
            if (n27 == 14) {
                if ((n18 += 3) > n17) {
                    throw new UTFDataFormatException();
                }
                n25 = this.readUnsignedByte();
                int n28 = this.readUnsignedByte();
                if ((n25 & 0xC0) != 128 || (n28 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n19++] = (char)((n26 & 0xF) << 12 | (n25 & 0x3F) << 6 | n28 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n19);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void seek(long l15) throws IOException {
        this.file.seek(l15);
    }

    public void setLength(long l15) throws IOException {
        this.file.setLength(l15);
    }

    @Override
    public int skipBytes(int n15) throws IOException {
        return this.file.skipBytes(n15);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.file.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n15, int n16) throws IOException {
        this.file.write(byArray, n15, n16);
    }

    @Override
    public void write(int n15) throws IOException {
        this.file.write(n15);
    }

    @Override
    public void writeBoolean(boolean bl4) throws IOException {
        if (bl4) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int n15) throws IOException {
        this.file.write(n15);
    }

    @Override
    public void writeShort(int n15) throws IOException {
        this.file.write(n15 & 0xFF);
        this.file.write(n15 >>> 8 & 0xFF);
    }

    @Override
    public void writeChar(int n15) throws IOException {
        this.file.write(n15 & 0xFF);
        this.file.write(n15 >>> 8 & 0xFF);
    }

    @Override
    public void writeInt(int n15) throws IOException {
        this.file.write(n15 & 0xFF);
        this.file.write(n15 >>> 8 & 0xFF);
        this.file.write(n15 >>> 16 & 0xFF);
        this.file.write(n15 >>> 24 & 0xFF);
    }

    @Override
    public void writeLong(long l15) throws IOException {
        this.file.write((int)l15 & 0xFF);
        this.file.write((int)(l15 >>> 8) & 0xFF);
        this.file.write((int)(l15 >>> 16) & 0xFF);
        this.file.write((int)(l15 >>> 24) & 0xFF);
        this.file.write((int)(l15 >>> 32) & 0xFF);
        this.file.write((int)(l15 >>> 40) & 0xFF);
        this.file.write((int)(l15 >>> 48) & 0xFF);
        this.file.write((int)(l15 >>> 56) & 0xFF);
    }

    @Override
    public final void writeFloat(float f15) throws IOException {
        this.writeInt(Float.floatToIntBits(f15));
    }

    @Override
    public final void writeDouble(double d15) throws IOException {
        this.writeLong(Double.doubleToLongBits(d15));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n15 = string.length();
        for (int i15 = 0; i15 < n15; ++i15) {
            this.file.write((byte)string.charAt(i15));
        }
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n15 = string.length();
        for (int i15 = 0; i15 < n15; ++i15) {
            char c15 = string.charAt(i15);
            this.file.write(c15 & 0xFF);
            this.file.write(c15 >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        char c15;
        int n15;
        int n16 = string.length();
        int n17 = 0;
        for (n15 = 0; n15 < n16; ++n15) {
            c15 = string.charAt(n15);
            if (c15 >= '\u0001' && c15 <= '\u007f') {
                ++n17;
                continue;
            }
            if (c15 > '\u07ff') {
                n17 += 3;
                continue;
            }
            n17 += 2;
        }
        if (n17 > 65535) {
            throw new UTFDataFormatException();
        }
        this.file.write(n17 >>> 8 & 0xFF);
        this.file.write(n17 & 0xFF);
        for (n15 = 0; n15 < n16; ++n15) {
            c15 = string.charAt(n15);
            if (c15 >= '\u0001' && c15 <= '\u007f') {
                this.file.write(c15);
                continue;
            }
            if (c15 > '\u07ff') {
                this.file.write(0xE0 | c15 >> 12 & 0xF);
                this.file.write(0x80 | c15 >> 6 & 0x3F);
                this.file.write(0x80 | c15 & 0x3F);
                continue;
            }
            this.file.write(0xC0 | c15 >> 6 & 0x1F);
            this.file.write(0x80 | c15 & 0x3F);
        }
    }
}

