/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.color.DiscreteAlphaIndexColorModel;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.Int16ImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.UInt32ImageTypeSpecifier;
import com.twelvemonkeys.lang.Validate;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.imageio.ImageTypeSpecifier;

public final class ImageTypeSpecifiers {
    private static final ImageTypeSpecifier TYPE_INT_RGB = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, 3, false);
    private static final ImageTypeSpecifier TYPE_INT_BGR = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 24, 255, 65280, 0xFF0000, 0, 3, false);
    private static final ImageTypeSpecifier TYPE_USHORT_565_RGB = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 16, 63488, 2016, 31, 0, 1, false);
    private static final ImageTypeSpecifier TYPE_USHORT_555_RGB = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 15, 31744, 992, 31, 0, 1, false);

    private ImageTypeSpecifiers() {
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n15) {
        switch (n15) {
            case 1: {
                return TYPE_INT_RGB;
            }
            case 4: {
                return TYPE_INT_BGR;
            }
            case 8: {
                return TYPE_USHORT_565_RGB;
            }
            case 9: {
                return TYPE_USHORT_555_RGB;
            }
        }
        return ImageTypeSpecifier.createFromBufferedImageType(n15);
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n15, int n16, int n17, int n18, int n19, boolean bl4) {
        int n25 = ImageTypeSpecifiers.calculateRequiredBits(n15 | n16 | n17 | n18);
        if (n25 != 32) {
            return ImageTypeSpecifiers.createPackedOddBits(colorSpace, n25, n15, n16, n17, n18, n19, bl4);
        }
        return ImageTypeSpecifier.createPacked(colorSpace, n15, n16, n17, n18, n19, bl4);
    }

    private static int calculateRequiredBits(int n15) {
        int n16 = 1;
        while ((n15 >>>= 1) != 0) {
            ++n16;
        }
        return n16;
    }

    static ImageTypeSpecifier createPackedOddBits(ColorSpace colorSpace, int n15, int n16, int n17, int n18, int n19, int n25, boolean bl4) {
        Validate.notNull(colorSpace, "colorSpace");
        Validate.isTrue(colorSpace.getType() == 5, colorSpace, "ColorSpace must be TYPE_RGB");
        Validate.isTrue(n16 != 0 || n17 != 0 || n18 != 0 || n19 != 0, "No mask has at least 1 bit set");
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, n15, n16, n17, n18, n19, bl4, n25);
        return new ImageTypeSpecifier(directColorModel, ((ColorModel)directColorModel).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n15, boolean bl4, boolean bl5) {
        if (n15 == 3) {
            return UInt32ImageTypeSpecifier.createInterleaved(colorSpace, nArray, bl4, bl5);
        }
        return ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n15, bl4, bl5);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n15, boolean bl4, boolean bl5) {
        if (n15 == 3) {
            return UInt32ImageTypeSpecifier.createBanded(colorSpace, nArray, nArray2, bl4, bl5);
        }
        return ImageTypeSpecifier.createBanded(colorSpace, nArray, nArray2, n15, bl4, bl5);
    }

    public static ImageTypeSpecifier createGrayscale(int n15, int n16) {
        if (n15 == 16 && n16 == 2) {
            return new Int16ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0}, false, false);
        }
        if (n15 == 32 && n16 == 3) {
            return UInt32ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0}, false, false);
        }
        if (n16 == 4 || n16 == 5) {
            return ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0}, n16, false, false);
        }
        return ImageTypeSpecifier.createGrayscale(n15, n16, false);
    }

    public static ImageTypeSpecifier createGrayscale(int n15, int n16, boolean bl4) {
        if (n15 == 16 && n16 == 2) {
            return new Int16ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0, 1}, true, bl4);
        }
        if (n15 == 32 && n16 == 3) {
            return UInt32ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0, 1}, true, bl4);
        }
        if (n16 == 4 || n16 == 5) {
            return ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0, 1}, n16, true, bl4);
        }
        return ImageTypeSpecifier.createGrayscale(n15, n16, false, bl4);
    }

    public static ImageTypeSpecifier createPackedGrayscale(ColorSpace colorSpace, int n15, int n16) {
        IndexColorModel indexColorModel;
        Object object;
        Validate.notNull(colorSpace, "colorSpace");
        Validate.isTrue(colorSpace.getType() == 6, colorSpace, "ColorSpace must be TYPE_GRAY");
        Validate.isTrue(n15 == 1 || n15 == 2 || n15 == 4, n15, "bits must be 1, 2, or 4: %s");
        Validate.isTrue(n16 == 0, n16, "dataType must be TYPE_BYTE: %s");
        int n17 = 1 << n15;
        if (ColorSpace.getInstance(1003).equals(colorSpace)) {
            object = new byte[n17];
            for (int i15 = 0; i15 < n17; ++i15) {
                object[i15] = (byte)(i15 * 255 / (n17 - 1));
            }
            indexColorModel = new IndexColorModel(n15, n17, (byte[])object, (byte[])object, (byte[])object);
        } else {
            object = new byte[n17];
            byte[] byArray = new byte[n17];
            byte[] byArray2 = new byte[n17];
            for (int i16 = 0; i16 < n17; ++i16) {
                float[] fArray = new float[]{(float)i16 / (float)(n17 - 1)};
                float[] fArray2 = colorSpace.toRGB(fArray);
                object[i16] = (byte)Math.round(fArray2[0] * 255.0f);
                byArray[i16] = (byte)Math.round(fArray2[1] * 255.0f);
                byArray2[i16] = (byte)Math.round(fArray2[2] * 255.0f);
            }
            indexColorModel = new IndexColorModel(n15, n17, (byte[])object, byArray, byArray2);
        }
        object = new MultiPixelPackedSampleModel(n16, 1, 1, n15);
        return new ImageTypeSpecifier(indexColorModel, (SampleModel)object);
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n15, int n16) {
        return ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, n15, n16);
    }

    public static ImageTypeSpecifier createIndexed(int[] nArray, boolean bl4, int n15, int n16, int n17) {
        return ImageTypeSpecifiers.createFromIndexColorModel(new IndexColorModel(n16, nArray.length, nArray, 0, bl4, n15, n17));
    }

    public static ImageTypeSpecifier createFromIndexColorModel(IndexColorModel indexColorModel) {
        return new IndexedImageTypeSpecifier(indexColorModel);
    }

    public static ImageTypeSpecifier createDiscreteAlphaIndexedFromIndexColorModel(IndexColorModel indexColorModel) {
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        return new ImageTypeSpecifier(discreteAlphaIndexColorModel, ((ColorModel)discreteAlphaIndexColorModel).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createDiscreteExtraSamplesIndexedFromIndexColorModel(IndexColorModel indexColorModel, int n15, boolean bl4) {
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel, n15, bl4);
        return new ImageTypeSpecifier(discreteAlphaIndexColorModel, ((ColorModel)discreteAlphaIndexColorModel).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        int n15;
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (renderedImage instanceof BufferedImage && (n15 = ((BufferedImage)renderedImage).getType()) != 0 && n15 != 12 && n15 != 13) {
            return ImageTypeSpecifiers.createFromBufferedImageType(n15);
        }
        return new ImageTypeSpecifier(renderedImage);
    }
}

