/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.vp8;

import com.twelvemonkeys.imageio.plugins.webp.vp8.Globals;
import com.twelvemonkeys.imageio.plugins.webp.vp8.IDCT;
import com.twelvemonkeys.imageio.plugins.webp.vp8.SubBlock;
import com.twelvemonkeys.imageio.plugins.webp.vp8.VP8Frame;
import java.io.IOException;

final class MacroBlock {
    private int filterLevel;
    private final boolean keepDebugInfo;
    private int segmentId;
    private int skipCoeff;
    private boolean skipInnerLoopFilter;
    final SubBlock[][] uSubBlocks;
    private int uVFilterLevel;
    private int uvMode;
    final SubBlock[][] vSubBlocks;
    private final int x;
    private final int y;
    final SubBlock y2SubBlock;
    private int yMode;
    final SubBlock[][] ySubBlocks;

    MacroBlock(int n15, int n16, boolean bl4) {
        SubBlock subBlock;
        SubBlock subBlock2;
        int n17;
        int n18;
        this.x = n15 - 1;
        this.y = n16 - 1;
        this.keepDebugInfo = bl4;
        this.ySubBlocks = new SubBlock[4][4];
        this.uSubBlocks = new SubBlock[2][2];
        this.vSubBlocks = new SubBlock[2][2];
        for (n18 = 0; n18 < 4; ++n18) {
            for (n17 = 0; n17 < 4; ++n17) {
                subBlock2 = null;
                subBlock = null;
                if (n17 > 0) {
                    subBlock2 = this.ySubBlocks[n17 - 1][n18];
                }
                if (n18 > 0) {
                    subBlock = this.ySubBlocks[n17][n18 - 1];
                }
                this.ySubBlocks[n17][n18] = new SubBlock(this, subBlock, subBlock2, SubBlock.Plane.Y1);
            }
        }
        for (n18 = 0; n18 < 2; ++n18) {
            for (n17 = 0; n17 < 2; ++n17) {
                subBlock2 = null;
                subBlock = null;
                if (n17 > 0) {
                    subBlock2 = this.uSubBlocks[n17 - 1][n18];
                }
                if (n18 > 0) {
                    subBlock = this.uSubBlocks[n17][n18 - 1];
                }
                this.uSubBlocks[n17][n18] = new SubBlock(this, subBlock, subBlock2, SubBlock.Plane.U);
            }
        }
        for (n18 = 0; n18 < 2; ++n18) {
            for (n17 = 0; n17 < 2; ++n17) {
                subBlock2 = null;
                subBlock = null;
                if (n17 > 0) {
                    subBlock2 = this.vSubBlocks[n17 - 1][n18];
                }
                if (n18 > 0) {
                    subBlock = this.vSubBlocks[n17][n18 - 1];
                }
                this.vSubBlocks[n17][n18] = new SubBlock(this, subBlock, subBlock2, SubBlock.Plane.V);
            }
        }
        this.y2SubBlock = new SubBlock(this, null, null, SubBlock.Plane.Y2);
    }

    public void decodeMacroBlock(VP8Frame vP8Frame) throws IOException {
        MacroBlock macroBlock = this;
        if (macroBlock.getSkipCoeff() > 0) {
            if (macroBlock.getYMode() != 4) {
                macroBlock.skipInnerLoopFilter = true;
            }
        } else {
            this.decodeMacroBlockTokens(vP8Frame, macroBlock.getYMode() != 4);
        }
    }

    private void decodeMacroBlockTokens(VP8Frame vP8Frame, boolean bl4) throws IOException {
        if (bl4) {
            this.skipInnerLoopFilter = this.decodePlaneTokens(vP8Frame, 1, SubBlock.Plane.Y2, false);
        }
        this.skipInnerLoopFilter |= this.decodePlaneTokens(vP8Frame, 4, SubBlock.Plane.Y1, bl4);
        this.skipInnerLoopFilter |= this.decodePlaneTokens(vP8Frame, 2, SubBlock.Plane.U, false);
        this.skipInnerLoopFilter |= this.decodePlaneTokens(vP8Frame, 2, SubBlock.Plane.V, false);
        this.skipInnerLoopFilter = !this.skipInnerLoopFilter;
    }

    private boolean decodePlaneTokens(VP8Frame vP8Frame, int n15, SubBlock.Plane plane, boolean bl4) throws IOException {
        MacroBlock macroBlock = this;
        boolean bl5 = false;
        for (int i15 = 0; i15 < n15; ++i15) {
            for (int i16 = 0; i16 < n15; ++i16) {
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                SubBlock subBlock = macroBlock.getSubBlock(plane, i16, i15);
                SubBlock subBlock2 = vP8Frame.getLeftSubBlock(subBlock, plane);
                SubBlock subBlock3 = vP8Frame.getAboveSubBlock(subBlock, plane);
                if (subBlock2.hasNoZeroToken()) {
                    n16 = 1;
                }
                n18 += n16;
                if (subBlock3.hasNoZeroToken()) {
                    n17 = 1;
                }
                subBlock.decodeSubBlock(vP8Frame.getTokenBoolDecoder(), vP8Frame.getCoefProbs(), n18 += n17, SubBlock.planeToType(plane, bl4), bl4);
                bl5 |= subBlock.hasNoZeroToken();
            }
        }
        return bl5;
    }

    public void dequantMacroBlock(VP8Frame vP8Frame) {
        MacroBlock macroBlock = this;
        if (macroBlock.getYMode() != 4) {
            SubBlock subBlock;
            int n15;
            int n16;
            SubBlock subBlock2 = macroBlock.getY2SubBlock();
            int n17 = vP8Frame.getSegmentQuants().getSegQuants()[this.getSegmentId()].getY2ac_delta_q();
            int n18 = vP8Frame.getSegmentQuants().getSegQuants()[this.getSegmentId()].getY2dc();
            int[] nArray = new int[16];
            nArray[0] = subBlock2.getTokens()[0] * n18;
            for (n16 = 1; n16 < 16; ++n16) {
                nArray[n16] = subBlock2.getTokens()[n16] * n17;
            }
            subBlock2.setDiff(IDCT.iwalsh4x4(nArray));
            for (n16 = 0; n16 < 4; ++n16) {
                for (n15 = 0; n15 < 4; ++n15) {
                    subBlock = macroBlock.getYSubBlock(n15, n16);
                    subBlock.dequantSubBlock(vP8Frame, subBlock2.getDiff()[n15][n16]);
                }
            }
            macroBlock.predictY(vP8Frame);
            macroBlock.predictUV(vP8Frame);
            for (n16 = 0; n16 < 2; ++n16) {
                for (n15 = 0; n15 < 2; ++n15) {
                    subBlock = macroBlock.getUSubBlock(n15, n16);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock = macroBlock.getVSubBlock(n16, n15);
                    subBlock.dequantSubBlock(vP8Frame, null);
                }
            }
            macroBlock.recon_mb();
        } else {
            SubBlock subBlock;
            int n19;
            int n25;
            for (n25 = 0; n25 < 4; ++n25) {
                for (n19 = 0; n19 < 4; ++n19) {
                    subBlock = macroBlock.getYSubBlock(n19, n25);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock.predict(vP8Frame);
                    subBlock.reconstruct();
                }
            }
            macroBlock.predictUV(vP8Frame);
            for (n25 = 0; n25 < 2; ++n25) {
                for (n19 = 0; n19 < 2; ++n19) {
                    subBlock = macroBlock.getUSubBlock(n19, n25);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock.reconstruct();
                }
            }
            for (n25 = 0; n25 < 2; ++n25) {
                for (n19 = 0; n19 < 2; ++n19) {
                    subBlock = macroBlock.getVSubBlock(n19, n25);
                    subBlock.dequantSubBlock(vP8Frame, null);
                    subBlock.reconstruct();
                }
            }
        }
    }

    public void drawDebug() {
        for (int i15 = 0; i15 < 4; ++i15) {
            for (int i16 = 0; i16 < 4; ++i16) {
                SubBlock subBlock = this.ySubBlocks[i16][0];
                subBlock.drawDebugH();
                subBlock = this.ySubBlocks[0][i15];
                subBlock.drawDebugV();
            }
        }
    }

    public String getDebugString() {
        String string = " YMode: " + Globals.getModeAsString(this.yMode);
        string = string + "\n UVMode: " + Globals.getModeAsString(this.uvMode);
        string = string + "\n SegmentID: " + this.segmentId;
        string = string + "\n Filter Level: " + this.filterLevel;
        string = string + "\n UV Filter Level: " + this.uVFilterLevel;
        string = string + "\n Skip Coeff: " + this.skipCoeff;
        return string;
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public SubBlock getBottomSubBlock(int n15, SubBlock.Plane plane) {
        switch (plane) {
            case Y1: {
                return this.ySubBlocks[n15][3];
            }
            case U: {
                return this.uSubBlocks[n15][1];
            }
            case V: {
                return this.vSubBlocks[n15][1];
            }
            case Y2: {
                return this.y2SubBlock;
            }
        }
        throw new IllegalArgumentException("Bad plane: " + (Object)((Object)plane));
    }

    public SubBlock getLeftSubBlock(int n15, SubBlock.Plane plane) {
        switch (plane) {
            case Y1: {
                return this.ySubBlocks[0][n15];
            }
            case U: {
                return this.uSubBlocks[0][n15];
            }
            case V: {
                return this.vSubBlocks[0][n15];
            }
            case Y2: {
                return this.y2SubBlock;
            }
        }
        throw new IllegalArgumentException("Bad plane: " + (Object)((Object)plane));
    }

    public SubBlock getRightSubBlock(int n15, SubBlock.Plane plane) {
        switch (plane) {
            case Y1: {
                return this.ySubBlocks[3][n15];
            }
            case U: {
                return this.uSubBlocks[1][n15];
            }
            case V: {
                return this.vSubBlocks[1][n15];
            }
            case Y2: {
                return this.y2SubBlock;
            }
        }
        throw new IllegalArgumentException("Bad plane: " + (Object)((Object)plane));
    }

    public int getSkipCoeff() {
        return this.skipCoeff;
    }

    public SubBlock getSubBlock(SubBlock.Plane plane, int n15, int n16) {
        switch (plane) {
            case Y1: {
                return this.getYSubBlock(n15, n16);
            }
            case U: {
                return this.getUSubBlock(n15, n16);
            }
            case V: {
                return this.getVSubBlock(n15, n16);
            }
            case Y2: {
                return this.getY2SubBlock();
            }
        }
        throw new IllegalArgumentException("Bad plane: " + (Object)((Object)plane));
    }

    public int getSubblockX(SubBlock subBlock) {
        if (subBlock.getPlane() == SubBlock.Plane.Y1) {
            for (int i15 = 0; i15 < 4; ++i15) {
                for (int i16 = 0; i16 < 4; ++i16) {
                    if (this.ySubBlocks[i16][i15] != subBlock) continue;
                    return i16;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.Plane.U) {
            for (int i17 = 0; i17 < 2; ++i17) {
                for (int i18 = 0; i18 < 2; ++i18) {
                    if (this.uSubBlocks[i18][i17] != subBlock) continue;
                    return i18;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.Plane.V) {
            for (int i19 = 0; i19 < 2; ++i19) {
                for (int i25 = 0; i25 < 2; ++i25) {
                    if (this.vSubBlocks[i25][i19] != subBlock) continue;
                    return i25;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.Plane.Y2) {
            return 0;
        }
        return -100;
    }

    public int getSubblockY(SubBlock subBlock) {
        if (subBlock.getPlane() == SubBlock.Plane.Y1) {
            for (int i15 = 0; i15 < 4; ++i15) {
                for (int i16 = 0; i16 < 4; ++i16) {
                    if (this.ySubBlocks[i16][i15] != subBlock) continue;
                    return i15;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.Plane.U) {
            for (int i17 = 0; i17 < 2; ++i17) {
                for (int i18 = 0; i18 < 2; ++i18) {
                    if (this.uSubBlocks[i18][i17] != subBlock) continue;
                    return i17;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.Plane.V) {
            for (int i19 = 0; i19 < 2; ++i19) {
                for (int i25 = 0; i25 < 2; ++i25) {
                    if (this.vSubBlocks[i25][i19] != subBlock) continue;
                    return i19;
                }
            }
        } else if (subBlock.getPlane() == SubBlock.Plane.Y2) {
            return 0;
        }
        return -100;
    }

    public SubBlock getUSubBlock(int n15, int n16) {
        return this.uSubBlocks[n15][n16];
    }

    public int getUVFilterLevel() {
        return this.uVFilterLevel;
    }

    public int getUvMode() {
        return this.uvMode;
    }

    public SubBlock getVSubBlock(int n15, int n16) {
        return this.vSubBlocks[n15][n16];
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public SubBlock getY2SubBlock() {
        return this.y2SubBlock;
    }

    public int getYMode() {
        return this.yMode;
    }

    public SubBlock getYSubBlock(int n15, int n16) {
        return this.ySubBlocks[n15][n16];
    }

    public boolean isKeepDebugInfo() {
        return this.keepDebugInfo;
    }

    public boolean isSkip_inner_lf() {
        return this.skipInnerLoopFilter;
    }

    public void predictUV(VP8Frame vP8Frame) {
        MacroBlock macroBlock = vP8Frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock macroBlock2 = vP8Frame.getMacroBlock(this.x - 1, this.y);
        switch (this.uvMode) {
            case 0: {
                int n15;
                int n16;
                int n17;
                int n18;
                boolean bl4 = false;
                boolean bl5 = false;
                int n19 = 0;
                int n25 = 0;
                if (this.x > 0) {
                    bl5 = true;
                }
                if (this.y > 0) {
                    bl4 = true;
                }
                if (bl4 || bl5) {
                    SubBlock subBlock;
                    SubBlock subBlock2;
                    int n26;
                    if (bl4) {
                        for (n26 = 0; n26 < 2; ++n26) {
                            subBlock2 = macroBlock.getUSubBlock(n26, 1);
                            subBlock = macroBlock.getVSubBlock(n26, 1);
                            for (n18 = 0; n18 < 4; ++n18) {
                                n19 += subBlock2.getDest()[n18][3];
                                n25 += subBlock.getDest()[n18][3];
                            }
                        }
                    }
                    if (bl5) {
                        for (n26 = 0; n26 < 2; ++n26) {
                            subBlock2 = macroBlock2.getUSubBlock(1, n26);
                            subBlock = macroBlock2.getVSubBlock(1, n26);
                            for (n18 = 0; n18 < 4; ++n18) {
                                n19 += subBlock2.getDest()[3][n18];
                                n25 += subBlock.getDest()[3][n18];
                            }
                        }
                    }
                    n26 = 2;
                    if (bl4) {
                        ++n26;
                    }
                    if (bl5) {
                        ++n26;
                    }
                    n17 = n19 + (1 << n26 - 1) >> n26;
                    n16 = n25 + (1 << n26 - 1) >> n26;
                } else {
                    n17 = 128;
                    n16 = 128;
                }
                int[][] nArray = new int[4][4];
                for (int i15 = 0; i15 < 4; ++i15) {
                    for (int i16 = 0; i16 < 4; ++i16) {
                        nArray[i16][i15] = n17;
                    }
                }
                int[][] nArray2 = new int[4][4];
                for (n15 = 0; n15 < 4; ++n15) {
                    for (n18 = 0; n18 < 4; ++n18) {
                        nArray2[n18][n15] = n16;
                    }
                }
                for (n15 = 0; n15 < 2; ++n15) {
                    for (n18 = 0; n18 < 2; ++n18) {
                        SubBlock subBlock = this.uSubBlocks[n18][n15];
                        SubBlock subBlock3 = this.vSubBlocks[n18][n15];
                        subBlock.setPredict(nArray);
                        subBlock3.setPredict(nArray2);
                    }
                }
                break;
            }
            case 1: {
                int n27;
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray2 = new SubBlock[2];
                for (n27 = 0; n27 < 2; ++n27) {
                    subBlockArray[n27] = macroBlock.getUSubBlock(n27, 1);
                    subBlockArray2[n27] = macroBlock.getVSubBlock(n27, 1);
                }
                for (n27 = 0; n27 < 2; ++n27) {
                    for (int i17 = 0; i17 < 2; ++i17) {
                        SubBlock subBlock = this.uSubBlocks[n27][i17];
                        SubBlock subBlock4 = this.vSubBlocks[n27][i17];
                        int[][] nArray = new int[4][4];
                        int[][] nArray3 = new int[4][4];
                        for (int i18 = 0; i18 < 4; ++i18) {
                            for (int i19 = 0; i19 < 4; ++i19) {
                                nArray[i18][i19] = subBlockArray[n27].getMacroBlockPredict(1)[i18][3];
                                nArray3[i18][i19] = subBlockArray2[n27].getMacroBlockPredict(1)[i18][3];
                            }
                        }
                        subBlock.setPredict(nArray);
                        subBlock4.setPredict(nArray3);
                    }
                }
                break;
            }
            case 2: {
                int n28;
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray3 = new SubBlock[2];
                for (n28 = 0; n28 < 2; ++n28) {
                    subBlockArray[n28] = macroBlock2.getUSubBlock(1, n28);
                    subBlockArray3[n28] = macroBlock2.getVSubBlock(1, n28);
                }
                for (n28 = 0; n28 < 2; ++n28) {
                    for (int i25 = 0; i25 < 2; ++i25) {
                        SubBlock subBlock = this.uSubBlocks[i25][n28];
                        SubBlock subBlock5 = this.vSubBlocks[i25][n28];
                        int[][] nArray = new int[4][4];
                        int[][] nArray4 = new int[4][4];
                        for (int i26 = 0; i26 < 4; ++i26) {
                            for (int i27 = 0; i27 < 4; ++i27) {
                                nArray[i27][i26] = subBlockArray[n28].getMacroBlockPredict(2)[3][i26];
                                nArray4[i27][i26] = subBlockArray3[n28].getMacroBlockPredict(2)[3][i26];
                            }
                        }
                        subBlock.setPredict(nArray);
                        subBlock5.setPredict(nArray4);
                    }
                }
                break;
            }
            case 3: {
                int n29;
                MacroBlock macroBlock3 = vP8Frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock subBlock = macroBlock3.getUSubBlock(1, 1);
                int n35 = subBlock.getDest()[3][3];
                SubBlock subBlock6 = macroBlock3.getVSubBlock(1, 1);
                int n36 = subBlock6.getDest()[3][3];
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray4 = new SubBlock[2];
                SubBlock[] subBlockArray5 = new SubBlock[2];
                SubBlock[] subBlockArray6 = new SubBlock[2];
                for (n29 = 0; n29 < 2; ++n29) {
                    subBlockArray[n29] = macroBlock.getUSubBlock(n29, 1);
                    subBlockArray4[n29] = macroBlock2.getUSubBlock(1, n29);
                    subBlockArray5[n29] = macroBlock.getVSubBlock(n29, 1);
                    subBlockArray6[n29] = macroBlock2.getVSubBlock(1, n29);
                }
                for (n29 = 0; n29 < 2; ++n29) {
                    for (int i28 = 0; i28 < 4; ++i28) {
                        for (int i29 = 0; i29 < 2; ++i29) {
                            for (int i35 = 0; i35 < 4; ++i35) {
                                int n37 = subBlockArray4[n29].getDest()[3][i28] + subBlockArray[i29].getDest()[i35][3] - n35;
                                n37 = Globals.clamp(n37, 255);
                                this.uSubBlocks[i29][n29].setPixel(i35, i28, n37);
                                int n38 = subBlockArray6[n29].getDest()[3][i28] + subBlockArray5[i29].getDest()[i35][3] - n36;
                                n38 = Globals.clamp(n38, 255);
                                this.vSubBlocks[i29][n29].setPixel(i35, i28, n38);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("TODO predict_mb_uv: " + this.yMode));
            }
        }
    }

    public void predictY(VP8Frame vP8Frame) {
        MacroBlock macroBlock = vP8Frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock macroBlock2 = vP8Frame.getMacroBlock(this.x - 1, this.y);
        switch (this.yMode) {
            case 0: {
                int n15;
                int n16;
                int n17;
                boolean bl4 = false;
                boolean bl5 = false;
                int n18 = 0;
                if (this.x > 0) {
                    bl5 = true;
                }
                if (this.y > 0) {
                    bl4 = true;
                }
                if (bl4 || bl5) {
                    SubBlock subBlock;
                    int n19;
                    if (bl4) {
                        for (n19 = 0; n19 < 4; ++n19) {
                            subBlock = macroBlock.getYSubBlock(n19, 3);
                            for (n17 = 0; n17 < 4; ++n17) {
                                n18 += subBlock.getDest()[n17][3];
                            }
                        }
                    }
                    if (bl5) {
                        for (n19 = 0; n19 < 4; ++n19) {
                            subBlock = macroBlock2.getYSubBlock(3, n19);
                            for (n17 = 0; n17 < 4; ++n17) {
                                n18 += subBlock.getDest()[3][n17];
                            }
                        }
                    }
                    n19 = 3;
                    if (bl4) {
                        ++n19;
                    }
                    if (bl5) {
                        ++n19;
                    }
                    n16 = n18 + (1 << n19 - 1) >> n19;
                } else {
                    n16 = 128;
                }
                int[][] nArray = new int[4][4];
                for (n15 = 0; n15 < 4; ++n15) {
                    for (n17 = 0; n17 < 4; ++n17) {
                        nArray[n17][n15] = n16;
                    }
                }
                for (n15 = 0; n15 < 4; ++n15) {
                    for (n17 = 0; n17 < 4; ++n17) {
                        SubBlock subBlock = this.ySubBlocks[n17][n15];
                        subBlock.setPredict(nArray);
                    }
                }
                break;
            }
            case 1: {
                int n25;
                SubBlock[] subBlockArray = new SubBlock[4];
                for (n25 = 0; n25 < 4; ++n25) {
                    subBlockArray[n25] = macroBlock.getYSubBlock(n25, 3);
                }
                for (n25 = 0; n25 < 4; ++n25) {
                    for (int i15 = 0; i15 < 4; ++i15) {
                        SubBlock subBlock = this.ySubBlocks[i15][n25];
                        int[][] nArray = new int[4][4];
                        for (int i16 = 0; i16 < 4; ++i16) {
                            for (int i17 = 0; i17 < 4; ++i17) {
                                nArray[i17][i16] = subBlockArray[i15].getPredict(2, false)[i17][3];
                            }
                        }
                        subBlock.setPredict(nArray);
                    }
                }
                break;
            }
            case 2: {
                int n26;
                SubBlock[] subBlockArray = new SubBlock[4];
                for (n26 = 0; n26 < 4; ++n26) {
                    subBlockArray[n26] = macroBlock2.getYSubBlock(3, n26);
                }
                for (n26 = 0; n26 < 4; ++n26) {
                    for (int i18 = 0; i18 < 4; ++i18) {
                        SubBlock subBlock = this.ySubBlocks[i18][n26];
                        int[][] nArray = new int[4][4];
                        for (int i19 = 0; i19 < 4; ++i19) {
                            for (int i25 = 0; i25 < 4; ++i25) {
                                nArray[i25][i19] = subBlockArray[n26].getPredict(0, true)[3][i19];
                            }
                        }
                        subBlock.setPredict(nArray);
                    }
                }
                break;
            }
            case 3: {
                int n27;
                MacroBlock macroBlock3 = vP8Frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock subBlock = macroBlock3.getYSubBlock(3, 3);
                int n28 = subBlock.getDest()[3][3];
                SubBlock[] subBlockArray = new SubBlock[4];
                SubBlock[] subBlockArray2 = new SubBlock[4];
                for (n27 = 0; n27 < 4; ++n27) {
                    subBlockArray[n27] = macroBlock.getYSubBlock(n27, 3);
                }
                for (n27 = 0; n27 < 4; ++n27) {
                    subBlockArray2[n27] = macroBlock2.getYSubBlock(3, n27);
                }
                for (n27 = 0; n27 < 4; ++n27) {
                    for (int i26 = 0; i26 < 4; ++i26) {
                        for (int i27 = 0; i27 < 4; ++i27) {
                            for (int i28 = 0; i28 < 4; ++i28) {
                                int n29 = subBlockArray2[n27].getDest()[3][i26] + subBlockArray[i27].getDest()[i28][3] - n28;
                                this.ySubBlocks[i27][n27].setPixel(i28, i26, Globals.clamp(n29, 255));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                System.out.println("TODO predict_mb_y: " + this.yMode);
                System.exit(0);
            }
        }
    }

    public void recon_mb() {
        SubBlock subBlock;
        int n15;
        int n16;
        for (n16 = 0; n16 < 4; ++n16) {
            for (n15 = 0; n15 < 4; ++n15) {
                subBlock = this.ySubBlocks[n15][n16];
                subBlock.reconstruct();
            }
        }
        for (n16 = 0; n16 < 2; ++n16) {
            for (n15 = 0; n15 < 2; ++n15) {
                subBlock = this.uSubBlocks[n15][n16];
                subBlock.reconstruct();
            }
        }
        for (n16 = 0; n16 < 2; ++n16) {
            for (n15 = 0; n15 < 2; ++n15) {
                subBlock = this.vSubBlocks[n15][n16];
                subBlock.reconstruct();
            }
        }
    }

    public void setFilterLevel(int n15) {
        this.filterLevel = n15;
    }

    public void setSegmentId(int n15) {
        this.segmentId = n15;
    }

    public void setSkipCoeff(int n15) {
        this.skipCoeff = n15;
    }

    public void setUVFilterLevel(int n15) {
        this.uVFilterLevel = n15;
    }

    public void setUvMode(int n15) {
        this.uvMode = n15;
    }

    public void setYMode(int n15) {
        this.yMode = n15;
    }

    public String toString() {
        return "x: " + this.x + "y: " + this.y;
    }

    public int getSegmentId() {
        return this.segmentId;
    }
}

