/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.vp8;

import com.twelvemonkeys.imageio.plugins.webp.vp8.MacroBlock;
import com.twelvemonkeys.imageio.plugins.webp.vp8.Segment;
import com.twelvemonkeys.imageio.plugins.webp.vp8.SubBlock;

final class LoopFilter {
    LoopFilter() {
    }

    private static int clamp(int n15) {
        return Math.max(Math.min(n15, 127), -128);
    }

    private static int common_adjust(boolean bl4, Segment segment) {
        int n15 = LoopFilter.u2s(segment.P1);
        int n16 = LoopFilter.u2s(segment.P0);
        int n17 = LoopFilter.u2s(segment.Q0);
        int n18 = LoopFilter.u2s(segment.Q1);
        int n19 = LoopFilter.clamp((bl4 ? LoopFilter.clamp(n15 - n18) : 0) + 3 * (n17 - n16));
        int n25 = LoopFilter.clamp(n19 + 3) >> 3;
        n19 = LoopFilter.clamp(n19 + 4) >> 3;
        segment.Q0 = LoopFilter.s2u(n17 - n19);
        segment.P0 = LoopFilter.s2u(n16 + n25);
        return n19;
    }

    private static boolean filter_yes(int n15, int n16, int n17, int n18, int n19, int n25, int n26, int n27, int n28, int n29) {
        return Math.abs(n25 - n26) * 2 + Math.abs(n19 - n27) / 2 <= n16 && Math.abs(n17 - n18) <= n15 && Math.abs(n18 - n19) <= n15 && Math.abs(n19 - n25) <= n15 && Math.abs(n29 - n28) <= n15 && Math.abs(n28 - n27) <= n15 && Math.abs(n27 - n26) <= n15;
    }

    private static Segment getSegH(SubBlock subBlock, SubBlock subBlock2, int n15) {
        Segment segment = new Segment();
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        segment.P0 = nArray2[3][n15];
        segment.P1 = nArray2[2][n15];
        segment.P2 = nArray2[1][n15];
        segment.P3 = nArray2[0][n15];
        segment.Q0 = nArray[0][n15];
        segment.Q1 = nArray[1][n15];
        segment.Q2 = nArray[2][n15];
        segment.Q3 = nArray[3][n15];
        return segment;
    }

    private static Segment getSegV(SubBlock subBlock, SubBlock subBlock2, int n15) {
        Segment segment = new Segment();
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        segment.P0 = nArray2[n15][3];
        segment.P1 = nArray2[n15][2];
        segment.P2 = nArray2[n15][1];
        segment.P3 = nArray2[n15][0];
        segment.Q0 = nArray[n15][0];
        segment.Q1 = nArray[n15][1];
        segment.Q2 = nArray[n15][2];
        segment.Q3 = nArray[n15][3];
        return segment;
    }

    private static boolean hev(int n15, int n16, int n17, int n18, int n19) {
        return Math.abs(n16 - n17) > n15 || Math.abs(n19 - n18) > n15;
    }

    static void loopFilterBlock(MacroBlock macroBlock, MacroBlock macroBlock2, MacroBlock macroBlock3, int n15, boolean bl4, int n16) {
        if (bl4) {
            LoopFilter.loopFilterSimpleBlock(macroBlock, macroBlock2, macroBlock3, n16);
        } else {
            LoopFilter.loopFilterUVBlock(macroBlock, macroBlock2, macroBlock3, n16, n15);
            LoopFilter.loopFilterYBlock(macroBlock, macroBlock2, macroBlock3, n16, n15);
        }
    }

    static void loopFilterSimpleBlock(MacroBlock macroBlock, MacroBlock macroBlock2, MacroBlock macroBlock3, int n15) {
        int n16 = macroBlock.getFilterLevel();
        if (n16 != 0) {
            Segment segment;
            SubBlock subBlock;
            int n17;
            int n18;
            int n19 = macroBlock.getFilterLevel();
            if (n15 > 0 && (n19 >>= n15 > 4 ? 2 : 1) > 9 - n15) {
                n19 = 9 - n15;
            }
            if (n19 == 0) {
                n19 = 1;
            }
            if ((n18 = n16 * 2 + n19) < 1) {
                n18 = 1;
            }
            int n25 = n18 + 4;
            if (macroBlock2 != null) {
                for (n17 = 0; n17 < 4; ++n17) {
                    SubBlock subBlock2 = macroBlock.getSubBlock(SubBlock.Plane.Y1, 0, n17);
                    subBlock = macroBlock2.getSubBlock(SubBlock.Plane.Y1, 3, n17);
                    for (int i15 = 0; i15 < 4; ++i15) {
                        Segment segment2 = LoopFilter.getSegH(subBlock2, subBlock, i15);
                        LoopFilter.simple_segment(n25, segment2);
                        LoopFilter.setSegH(subBlock2, subBlock, segment2, i15);
                    }
                }
            }
            if (!macroBlock.isSkip_inner_lf()) {
                for (n17 = 1; n17 < 4; ++n17) {
                    for (int i16 = 0; i16 < 4; ++i16) {
                        subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, n17 - 1, i16);
                        SubBlock subBlock3 = macroBlock.getSubBlock(SubBlock.Plane.Y1, n17, i16);
                        for (int i17 = 0; i17 < 4; ++i17) {
                            segment = LoopFilter.getSegH(subBlock3, subBlock, i17);
                            LoopFilter.simple_segment(n18, segment);
                            LoopFilter.setSegH(subBlock3, subBlock, segment, i17);
                        }
                    }
                }
            }
            if (macroBlock3 != null) {
                for (n17 = 0; n17 < 4; ++n17) {
                    SubBlock subBlock4 = macroBlock3.getSubBlock(SubBlock.Plane.Y1, n17, 3);
                    subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, n17, 0);
                    for (int i18 = 0; i18 < 4; ++i18) {
                        Segment segment3 = LoopFilter.getSegV(subBlock, subBlock4, i18);
                        LoopFilter.simple_segment(n25, segment3);
                        LoopFilter.setSegV(subBlock, subBlock4, segment3, i18);
                    }
                }
            }
            if (!macroBlock.isSkip_inner_lf()) {
                for (n17 = 1; n17 < 4; ++n17) {
                    for (int i19 = 0; i19 < 4; ++i19) {
                        subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, i19, n17 - 1);
                        SubBlock subBlock5 = macroBlock.getSubBlock(SubBlock.Plane.Y1, i19, n17);
                        for (int i25 = 0; i25 < 4; ++i25) {
                            segment = LoopFilter.getSegV(subBlock5, subBlock, i25);
                            LoopFilter.simple_segment(n18, segment);
                            LoopFilter.setSegV(subBlock5, subBlock, segment, i25);
                        }
                    }
                }
            }
        }
    }

    static void loopFilterUVBlock(MacroBlock macroBlock, MacroBlock macroBlock2, MacroBlock macroBlock3, int n15, int n16) {
        int n17 = macroBlock.getFilterLevel();
        if (n17 != 0) {
            Segment segment;
            SubBlock subBlock;
            SubBlock subBlock2;
            SubBlock subBlock3;
            int n18;
            int n19 = macroBlock.getFilterLevel();
            if (n15 > 0 && (n19 >>= n15 > 4 ? 2 : 1) > 9 - n15) {
                n19 = 9 - n15;
            }
            if (n19 == 0) {
                n19 = 1;
            }
            int n25 = 0;
            if (n16 == 0) {
                if (n17 >= 40) {
                    n25 = 2;
                } else if (n17 >= 15) {
                    n25 = 1;
                }
            } else if (n17 >= 40) {
                n25 = 3;
            } else if (n17 >= 20) {
                n25 = 2;
            } else if (n17 >= 15) {
                n25 = 1;
            }
            int n26 = (n17 + 2) * 2 + n19;
            int n27 = n17 * 2 + n19;
            if (macroBlock2 != null) {
                for (n18 = 0; n18 < 2; ++n18) {
                    SubBlock subBlock4 = macroBlock.getSubBlock(SubBlock.Plane.U, 0, n18);
                    subBlock3 = macroBlock2.getSubBlock(SubBlock.Plane.U, 1, n18);
                    subBlock2 = macroBlock.getSubBlock(SubBlock.Plane.V, 0, n18);
                    subBlock = macroBlock2.getSubBlock(SubBlock.Plane.V, 1, n18);
                    for (int i15 = 0; i15 < 4; ++i15) {
                        Segment segment2 = LoopFilter.getSegH(subBlock4, subBlock3, i15);
                        LoopFilter.MBfilter(n25, n19, n26, segment2);
                        LoopFilter.setSegH(subBlock4, subBlock3, segment2, i15);
                        segment2 = LoopFilter.getSegH(subBlock2, subBlock, i15);
                        LoopFilter.MBfilter(n25, n19, n26, segment2);
                        LoopFilter.setSegH(subBlock2, subBlock, segment2, i15);
                    }
                }
            }
            if (!macroBlock.isSkip_inner_lf()) {
                for (n18 = 1; n18 < 2; ++n18) {
                    for (int i16 = 0; i16 < 2; ++i16) {
                        subBlock3 = macroBlock.getSubBlock(SubBlock.Plane.U, n18 - 1, i16);
                        subBlock2 = macroBlock.getSubBlock(SubBlock.Plane.U, n18, i16);
                        subBlock = macroBlock.getSubBlock(SubBlock.Plane.V, n18 - 1, i16);
                        SubBlock subBlock5 = macroBlock.getSubBlock(SubBlock.Plane.V, n18, i16);
                        for (int i17 = 0; i17 < 4; ++i17) {
                            segment = LoopFilter.getSegH(subBlock2, subBlock3, i17);
                            LoopFilter.subblock_filter(n25, n19, n27, segment);
                            LoopFilter.setSegH(subBlock2, subBlock3, segment, i17);
                            segment = LoopFilter.getSegH(subBlock5, subBlock, i17);
                            LoopFilter.subblock_filter(n25, n19, n27, segment);
                            LoopFilter.setSegH(subBlock5, subBlock, segment, i17);
                        }
                    }
                }
            }
            if (macroBlock3 != null) {
                for (n18 = 0; n18 < 2; ++n18) {
                    SubBlock subBlock6 = macroBlock3.getSubBlock(SubBlock.Plane.U, n18, 1);
                    subBlock3 = macroBlock.getSubBlock(SubBlock.Plane.U, n18, 0);
                    subBlock2 = macroBlock3.getSubBlock(SubBlock.Plane.V, n18, 1);
                    subBlock = macroBlock.getSubBlock(SubBlock.Plane.V, n18, 0);
                    for (int i18 = 0; i18 < 4; ++i18) {
                        Segment segment3 = LoopFilter.getSegV(subBlock3, subBlock6, i18);
                        LoopFilter.MBfilter(n25, n19, n26, segment3);
                        LoopFilter.setSegV(subBlock3, subBlock6, segment3, i18);
                        segment3 = LoopFilter.getSegV(subBlock, subBlock2, i18);
                        LoopFilter.MBfilter(n25, n19, n26, segment3);
                        LoopFilter.setSegV(subBlock, subBlock2, segment3, i18);
                    }
                }
            }
            if (!macroBlock.isSkip_inner_lf()) {
                for (n18 = 1; n18 < 2; ++n18) {
                    for (int i19 = 0; i19 < 2; ++i19) {
                        subBlock3 = macroBlock.getSubBlock(SubBlock.Plane.U, i19, n18 - 1);
                        subBlock2 = macroBlock.getSubBlock(SubBlock.Plane.U, i19, n18);
                        subBlock = macroBlock.getSubBlock(SubBlock.Plane.V, i19, n18 - 1);
                        SubBlock subBlock7 = macroBlock.getSubBlock(SubBlock.Plane.V, i19, n18);
                        for (int i25 = 0; i25 < 4; ++i25) {
                            segment = LoopFilter.getSegV(subBlock2, subBlock3, i25);
                            LoopFilter.subblock_filter(n25, n19, n27, segment);
                            LoopFilter.setSegV(subBlock2, subBlock3, segment, i25);
                            segment = LoopFilter.getSegV(subBlock7, subBlock, i25);
                            LoopFilter.subblock_filter(n25, n19, n27, segment);
                            LoopFilter.setSegV(subBlock7, subBlock, segment, i25);
                        }
                    }
                }
            }
        }
    }

    static void loopFilterYBlock(MacroBlock macroBlock, MacroBlock macroBlock2, MacroBlock macroBlock3, int n15, int n16) {
        int n17 = macroBlock.getFilterLevel();
        if (n17 != 0) {
            Segment segment;
            SubBlock subBlock;
            int n18;
            int n19 = macroBlock.getFilterLevel();
            if (n15 > 0 && (n19 >>= n15 > 4 ? 2 : 1) > 9 - n15) {
                n19 = 9 - n15;
            }
            if (n19 == 0) {
                n19 = 1;
            }
            int n25 = 0;
            if (n16 == 0) {
                if (n17 >= 40) {
                    n25 = 2;
                } else if (n17 >= 15) {
                    n25 = 1;
                }
            } else if (n17 >= 40) {
                n25 = 3;
            } else if (n17 >= 20) {
                n25 = 2;
            } else if (n17 >= 15) {
                n25 = 1;
            }
            int n26 = (n17 + 2) * 2 + n19;
            int n27 = n17 * 2 + n19;
            if (macroBlock2 != null) {
                for (n18 = 0; n18 < 4; ++n18) {
                    SubBlock subBlock2 = macroBlock.getSubBlock(SubBlock.Plane.Y1, 0, n18);
                    subBlock = macroBlock2.getSubBlock(SubBlock.Plane.Y1, 3, n18);
                    for (int i15 = 0; i15 < 4; ++i15) {
                        Segment segment2 = LoopFilter.getSegH(subBlock2, subBlock, i15);
                        LoopFilter.MBfilter(n25, n19, n26, segment2);
                        LoopFilter.setSegH(subBlock2, subBlock, segment2, i15);
                    }
                }
            }
            if (!macroBlock.isSkip_inner_lf()) {
                for (n18 = 1; n18 < 4; ++n18) {
                    for (int i16 = 0; i16 < 4; ++i16) {
                        subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, n18 - 1, i16);
                        SubBlock subBlock3 = macroBlock.getSubBlock(SubBlock.Plane.Y1, n18, i16);
                        for (int i17 = 0; i17 < 4; ++i17) {
                            segment = LoopFilter.getSegH(subBlock3, subBlock, i17);
                            LoopFilter.subblock_filter(n25, n19, n27, segment);
                            LoopFilter.setSegH(subBlock3, subBlock, segment, i17);
                        }
                    }
                }
            }
            if (macroBlock3 != null) {
                for (n18 = 0; n18 < 4; ++n18) {
                    SubBlock subBlock4 = macroBlock3.getSubBlock(SubBlock.Plane.Y1, n18, 3);
                    subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, n18, 0);
                    for (int i18 = 0; i18 < 4; ++i18) {
                        Segment segment3 = LoopFilter.getSegV(subBlock, subBlock4, i18);
                        LoopFilter.MBfilter(n25, n19, n26, segment3);
                        LoopFilter.setSegV(subBlock, subBlock4, segment3, i18);
                    }
                }
            }
            if (!macroBlock.isSkip_inner_lf()) {
                for (n18 = 1; n18 < 4; ++n18) {
                    for (int i19 = 0; i19 < 4; ++i19) {
                        subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, i19, n18 - 1);
                        SubBlock subBlock5 = macroBlock.getSubBlock(SubBlock.Plane.Y1, i19, n18);
                        for (int i25 = 0; i25 < 4; ++i25) {
                            segment = LoopFilter.getSegV(subBlock5, subBlock, i25);
                            LoopFilter.subblock_filter(n25, n19, n27, segment);
                            LoopFilter.setSegV(subBlock5, subBlock, segment, i25);
                        }
                    }
                }
            }
        }
    }

    private static void MBfilter(int n15, int n16, int n17, Segment segment) {
        int n18 = LoopFilter.u2s(segment.P3);
        int n19 = LoopFilter.u2s(segment.P2);
        int n25 = LoopFilter.u2s(segment.P1);
        int n26 = LoopFilter.u2s(segment.P0);
        int n27 = LoopFilter.u2s(segment.Q0);
        int n28 = LoopFilter.u2s(segment.Q1);
        int n29 = LoopFilter.u2s(segment.Q2);
        int n35 = LoopFilter.u2s(segment.Q3);
        if (LoopFilter.filter_yes(n16, n17, n35, n29, n28, n27, n26, n25, n19, n18)) {
            if (!LoopFilter.hev(n15, n25, n26, n27, n28)) {
                int n36 = LoopFilter.clamp(LoopFilter.clamp(n25 - n28) + 3 * (n27 - n26));
                int n37 = 27 * n36 + 63 >> 7;
                segment.Q0 = LoopFilter.s2u(n27 - n37);
                segment.P0 = LoopFilter.s2u(n26 + n37);
                n37 = 18 * n36 + 63 >> 7;
                segment.Q1 = LoopFilter.s2u(n28 - n37);
                segment.P1 = LoopFilter.s2u(n25 + n37);
                n37 = 9 * n36 + 63 >> 7;
                segment.Q2 = LoopFilter.s2u(n29 - n37);
                segment.P2 = LoopFilter.s2u(n19 + n37);
            } else {
                LoopFilter.common_adjust(true, segment);
            }
        }
    }

    private static int s2u(int n15) {
        return LoopFilter.clamp(n15) + 128;
    }

    private static void setSegH(SubBlock subBlock, SubBlock subBlock2, Segment segment, int n15) {
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        nArray2[3][n15] = segment.P0;
        nArray2[2][n15] = segment.P1;
        nArray2[1][n15] = segment.P2;
        nArray2[0][n15] = segment.P3;
        nArray[0][n15] = segment.Q0;
        nArray[1][n15] = segment.Q1;
        nArray[2][n15] = segment.Q2;
        nArray[3][n15] = segment.Q3;
    }

    private static void setSegV(SubBlock subBlock, SubBlock subBlock2, Segment segment, int n15) {
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        nArray2[n15][3] = segment.P0;
        nArray2[n15][2] = segment.P1;
        nArray2[n15][1] = segment.P2;
        nArray2[n15][0] = segment.P3;
        nArray[n15][0] = segment.Q0;
        nArray[n15][1] = segment.Q1;
        nArray[n15][2] = segment.Q2;
        nArray[n15][3] = segment.Q3;
    }

    private static void simple_segment(int n15, Segment segment) {
        if (Math.abs(segment.P0 - segment.Q0) * 2 + Math.abs(segment.P1 - segment.Q1) / 2 <= n15) {
            LoopFilter.common_adjust(true, segment);
        }
    }

    private static void subblock_filter(int n15, int n16, int n17, Segment segment) {
        int n18 = LoopFilter.u2s(segment.P3);
        int n19 = LoopFilter.u2s(segment.P2);
        int n25 = LoopFilter.u2s(segment.P1);
        int n26 = LoopFilter.u2s(segment.P0);
        int n27 = LoopFilter.u2s(segment.Q0);
        int n28 = LoopFilter.u2s(segment.Q1);
        int n29 = LoopFilter.u2s(segment.Q2);
        int n35 = LoopFilter.u2s(segment.Q3);
        if (LoopFilter.filter_yes(n16, n17, n35, n29, n28, n27, n26, n25, n19, n18)) {
            boolean bl4 = LoopFilter.hev(n15, n25, n26, n27, n28);
            int n36 = LoopFilter.common_adjust(bl4, segment) + 1 >> 1;
            if (!bl4) {
                segment.Q1 = LoopFilter.s2u(n28 - n36);
                segment.P1 = LoopFilter.s2u(n25 + n36);
            }
        }
    }

    private static int u2s(int n15) {
        return n15 - 128;
    }
}

