/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.imageio.plugins.webp.LSBBitReader;
import com.twelvemonkeys.imageio.plugins.webp.lossless.ColorCache;
import com.twelvemonkeys.imageio.plugins.webp.lossless.ColorIndexingTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.ColorTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.HuffmanCodeGroup;
import com.twelvemonkeys.imageio.plugins.webp.lossless.HuffmanInfo;
import com.twelvemonkeys.imageio.plugins.webp.lossless.PredictorTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.SubtractGreenTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;
import com.twelvemonkeys.imageio.util.RasterUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;

public final class VP8LDecoder {
    private static final byte[] DISTANCES = new byte[]{24, 7, 23, 25, 40, 6, 39, 41, 22, 26, 38, 42, 56, 5, 55, 57, 21, 27, 54, 58, 37, 43, 72, 4, 71, 73, 20, 28, 53, 59, 70, 74, 36, 44, 88, 69, 75, 52, 60, 3, 87, 89, 19, 29, 86, 90, 35, 45, 68, 76, 85, 91, 51, 61, 104, 2, 103, 105, 18, 30, 102, 106, 34, 46, 84, 92, 67, 77, 101, 107, 50, 62, 120, 1, 119, 121, 83, 93, 17, 31, 100, 108, 66, 78, 118, 122, 33, 47, 117, 123, 49, 63, 99, 109, 82, 94, 0, 116, 124, 65, 79, 16, 32, 98, 110, 48, 115, 125, 81, 95, 64, 114, 126, 97, 111, 80, 113, 127, 96, 112};
    private final ImageInputStream imageInput;
    private final LSBBitReader lsbBitReader;

    public VP8LDecoder(ImageInputStream imageInputStream, boolean bl4) {
        this.imageInput = imageInputStream;
        this.lsbBitReader = new LSBBitReader(imageInputStream);
    }

    public void readVP8Lossless(WritableRaster writableRaster, boolean bl4, ImageReadParam imageReadParam, int n15, int n16) throws IOException {
        WritableRaster writableRaster2;
        WritableRaster writableRaster3;
        if (bl4) {
            this.imageInput.seek(this.imageInput.getStreamPosition() + 5L);
        }
        int n17 = n15;
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        while (bl4 && this.lsbBitReader.readBit() == 1) {
            n17 = this.readTransform(n17, n16, arrayList);
        }
        int n18 = 0;
        if (this.lsbBitReader.readBit() == 1 && ((n18 = (int)this.lsbBitReader.readBits(4)) < 1 || n18 > 11)) {
            throw new IIOException("Corrupt WebP stream, colorCacheBits < 1 || > 11: " + n18);
        }
        HuffmanInfo huffmanInfo = this.readHuffmanCodes(n17, n16, n18, bl4);
        ColorCache colorCache = null;
        if (n18 > 0) {
            colorCache = new ColorCache(n18);
        }
        if (bl4) {
            Rectangle rectangle = new Rectangle(n15, n16);
            writableRaster3 = this.createDecodeRaster(writableRaster, imageReadParam, rectangle);
            writableRaster2 = writableRaster3.createWritableChild(0, 0, n17, n16, 0, 0, null);
        } else {
            writableRaster2 = writableRaster3 = writableRaster;
        }
        this.decodeImage(writableRaster2, huffmanInfo, colorCache);
        for (Transform transform : arrayList) {
            transform.applyInverse(writableRaster3);
        }
        if (writableRaster3 != writableRaster) {
            VP8LDecoder.copyIntoRasterWithParams(writableRaster3, writableRaster, imageReadParam);
        }
    }

    private WritableRaster createDecodeRaster(WritableRaster writableRaster, ImageReadParam imageReadParam, Rectangle rectangle) {
        boolean bl4 = false;
        if (imageReadParam != null) {
            if (imageReadParam.getSourceRegion() != null && !imageReadParam.getSourceRegion().contains(rectangle) || imageReadParam.getSourceXSubsampling() != 1 || imageReadParam.getSourceYSubsampling() != 1) {
                return Raster.createInterleavedRaster(0, rectangle.width, rectangle.height, 4 * rectangle.width, 4, new int[]{0, 1, 2, 3}, null);
            }
            rectangle.setLocation(imageReadParam.getDestinationOffset());
            bl4 = true;
        }
        if (!writableRaster.getBounds().contains(rectangle)) {
            return Raster.createInterleavedRaster(0, rectangle.width, rectangle.height, 4 * rectangle.width, 4, new int[]{0, 1, 2, 3}, null);
        }
        return bl4 ? writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, null) : writableRaster;
    }

    public static void copyIntoRasterWithParams(Raster raster, WritableRaster writableRaster, ImageReadParam imageReadParam) {
        Point point;
        Rectangle rectangle = imageReadParam != null && imageReadParam.getSourceRegion() != null ? imageReadParam.getSourceRegion() : raster.getBounds();
        int n15 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n16 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        int n17 = imageReadParam != null ? imageReadParam.getSubsamplingXOffset() : 0;
        int n18 = imageReadParam != null ? imageReadParam.getSubsamplingYOffset() : 0;
        Point point2 = point = imageReadParam != null ? imageReadParam.getDestinationOffset() : new Point(0, 0);
        if (n15 == 1 && n16 == 1) {
            writableRaster.setRect(point.x, point.y, raster);
        } else {
            byte[] byArray = new byte[4];
            int n19 = writableRaster.getWidth() + writableRaster.getMinX();
            int n25 = writableRaster.getHeight() + writableRaster.getMinY();
            int n26 = point.y;
            int n27 = rectangle.y + n18;
            while (n26 < n25) {
                int n28 = point.x;
                int n29 = rectangle.x + n17;
                while (n28 < n19) {
                    raster.getDataElements(n29, n27, byArray);
                    writableRaster.setDataElements(n28, n26, byArray);
                    ++n28;
                    n29 += n15;
                }
                ++n26;
                n27 += n16;
            }
        }
    }

    private void decodeImage(WritableRaster writableRaster, HuffmanInfo huffmanInfo, ColorCache colorCache) throws IOException {
        int n15 = writableRaster.getWidth();
        int n16 = writableRaster.getHeight();
        int n17 = huffmanInfo.metaCodeBits == 0 ? -1 : (1 << huffmanInfo.metaCodeBits) - 1;
        HuffmanCodeGroup huffmanCodeGroup = huffmanInfo.huffmanGroups[0];
        byte[] byArray = new byte[4];
        for (int i15 = 0; i15 < n16; ++i15) {
            for (int i16 = 0; i16 < n15; ++i16) {
                short s15;
                if ((i16 & n17) == 0 && huffmanInfo.huffmanMetaCodes != null) {
                    s15 = huffmanInfo.huffmanMetaCodes.getSample(i16 >> huffmanInfo.metaCodeBits, i15 >> huffmanInfo.metaCodeBits, 0);
                    huffmanCodeGroup = huffmanInfo.huffmanGroups[s15];
                }
                if ((s15 = huffmanCodeGroup.mainCode.readSymbol(this.lsbBitReader)) < 256) {
                    this.decodeLiteral(writableRaster, colorCache, huffmanCodeGroup, byArray, i15, i16, s15);
                    continue;
                }
                if (s15 < 280) {
                    int n18 = this.decodeBwRef(writableRaster, colorCache, n15, huffmanCodeGroup, byArray, s15, i16, i15);
                    i15 += (--i16 + n18) / n15;
                    i16 = (i16 + n18) % n15;
                    if (i15 >= n16 || i16 >= n15 || huffmanInfo.huffmanMetaCodes == null) continue;
                    int n19 = huffmanInfo.huffmanMetaCodes.getSample(i16 >> huffmanInfo.metaCodeBits, i15 >> huffmanInfo.metaCodeBits, 0);
                    huffmanCodeGroup = huffmanInfo.huffmanGroups[n19];
                    continue;
                }
                this.decodeCached(writableRaster, colorCache, byArray, i15, i16, s15);
            }
        }
    }

    private void decodeCached(WritableRaster writableRaster, ColorCache colorCache, byte[] byArray, int n15, int n16, short s15) {
        int n17 = colorCache.lookup(s15 - 256 - 24);
        byArray[0] = (byte)(n17 >> 16 & 0xFF);
        byArray[1] = (byte)(n17 >> 8 & 0xFF);
        byArray[2] = (byte)(n17 & 0xFF);
        byArray[3] = (byte)(n17 >>> 24);
        writableRaster.setDataElements(n16, n15, byArray);
    }

    private void decodeLiteral(WritableRaster writableRaster, ColorCache colorCache, HuffmanCodeGroup huffmanCodeGroup, byte[] byArray, int n15, int n16, short s15) throws IOException {
        byte by = (byte)huffmanCodeGroup.redCode.readSymbol(this.lsbBitReader);
        byte by4 = (byte)huffmanCodeGroup.blueCode.readSymbol(this.lsbBitReader);
        byte by5 = (byte)huffmanCodeGroup.alphaCode.readSymbol(this.lsbBitReader);
        byArray[0] = by;
        byArray[1] = (byte)s15;
        byArray[2] = by4;
        byArray[3] = by5;
        writableRaster.setDataElements(n16, n15, byArray);
        if (colorCache != null) {
            colorCache.insert((by5 & 0xFF) << 24 | (by & 0xFF) << 16 | (s15 & 0xFF) << 8 | by4 & 0xFF);
        }
    }

    private int decodeBwRef(WritableRaster writableRaster, ColorCache colorCache, int n15, HuffmanCodeGroup huffmanCodeGroup, byte[] byArray, short s15, int n16, int n17) throws IOException {
        int n18;
        int n19;
        int n25;
        int n26 = this.lz77decode(s15 - 256);
        short s16 = huffmanCodeGroup.distanceCode.readSymbol(this.lsbBitReader);
        int n27 = this.lz77decode(s16);
        if (n27 > 120) {
            n25 = n27 - 120;
            n19 = n17 - n25 / n15;
            n18 = n16 - n25 % n15;
        } else {
            n18 = n16 - (8 - (DISTANCES[n27 - 1] & 0xF));
            n19 = n17 - (DISTANCES[n27 - 1] >> 4);
        }
        if (n18 < 0) {
            --n19;
            n18 += n15;
        } else if (n18 >= n15) {
            n18 -= n15;
            ++n19;
        }
        for (n25 = n26; n25 > 0; --n25) {
            if (n16 == n15) {
                n16 = 0;
                ++n17;
            }
            writableRaster.getDataElements(n18++, n19, byArray);
            writableRaster.setDataElements(n16, n17, byArray);
            if (n18 == n15) {
                n18 = 0;
                ++n19;
            }
            if (colorCache != null) {
                colorCache.insert((byArray[3] & 0xFF) << 24 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF);
            }
            ++n16;
        }
        return n26;
    }

    private int lz77decode(int n15) throws IOException {
        if (n15 < 4) {
            return n15 + 1;
        }
        int n16 = n15 - 2 >> 1;
        int n17 = 2 + (n15 & 1) << n16;
        return n17 + (int)this.lsbBitReader.readBits(n16) + 1;
    }

    private int readTransform(int n15, int n16, List<Transform> list2) throws IOException {
        int n17 = (int)this.lsbBitReader.readBits(2);
        switch (n17) {
            case 0: 
            case 1: {
                byte by = (byte)(this.lsbBitReader.readBits(3) + 2L);
                int n18 = VP8LDecoder.subSampleSize(n15, by);
                int n19 = VP8LDecoder.subSampleSize(n16, by);
                WritableRaster writableRaster = Raster.createInterleavedRaster(0, n18, n19, 4 * n18, 4, new int[]{0, 1, 2, 3}, null);
                this.readVP8Lossless(writableRaster, false, null, n18, n19);
                if (n17 == 0) {
                    list2.add(0, new PredictorTransform(writableRaster, by));
                    break;
                }
                list2.add(0, new ColorTransform(writableRaster, by));
                break;
            }
            case 2: {
                list2.add(0, new SubtractGreenTransform());
                break;
            }
            case 3: {
                byte by;
                int n25 = (int)this.lsbBitReader.readBits(8) + 1;
                int n26 = n25 > 16 ? 256 : (n25 > 4 ? 16 : (n25 > 2 ? 4 : 2));
                byte[] byArray = new byte[n26 * 4];
                this.readVP8Lossless(Raster.createInterleavedRaster(new DataBufferByte(byArray, n25 * 4), n25, 1, n25 * 4, 4, new int[]{0, 1, 2, 3}, null), false, null, n25, 1);
                for (by = 4; by < byArray.length; ++by) {
                    byte by4 = by;
                    byArray[by4] = (byte)(byArray[by4] + byArray[by - 4]);
                }
                by = (byte)(n25 > 16 ? 0 : (n25 > 4 ? 1 : (n25 > 2 ? 2 : 3)));
                n15 = VP8LDecoder.subSampleSize(n15, by);
                list2.add(0, new ColorIndexingTransform(byArray, by));
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid transformType: " + n17));
            }
        }
        return n15;
    }

    private HuffmanInfo readHuffmanCodes(int n15, int n16, int n17, boolean bl4) throws IOException {
        Object object;
        int n18 = 1;
        int n19 = 0;
        WritableRaster writableRaster = null;
        if (bl4 && this.lsbBitReader.readBit() == 1) {
            n19 = (int)this.lsbBitReader.readBits(3) + 2;
            int n25 = VP8LDecoder.subSampleSize(n15, n19);
            int n26 = VP8LDecoder.subSampleSize(n16, n19);
            object = Raster.createPackedRaster(3, n25, n26, new int[]{65280, 255, -16777216, 0xFF0000}, null);
            this.readVP8Lossless(RasterUtils.asByteRaster((WritableRaster)object), false, null, n25, n26);
            int[] nArray = ((DataBufferInt)((Raster)object).getDataBuffer()).getData();
            int n27 = Integer.MIN_VALUE;
            for (int n28 : nArray) {
                n27 = Math.max(n27, n28 & 0xFFFF);
            }
            n18 = n27 + 1;
            writableRaster = Raster.createPackedRaster(((Raster)object).getDataBuffer(), n25, n26, n25, new int[]{65535}, null);
        }
        object = new HuffmanCodeGroup[n18];
        for (int i15 = 0; i15 < ((HuffmanCodeGroup[])object).length; ++i15) {
            object[i15] = new HuffmanCodeGroup(this.lsbBitReader, n17);
        }
        return new HuffmanInfo(writableRaster, n19, (HuffmanCodeGroup[])object);
    }

    private static int subSampleSize(int n15, int n16) {
        return n15 + (1 << n16) - 1 >> n16;
    }
}

