/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.ColorSpaces;

public final class YCbCrConverter {
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;

    public static void convertYCbCr2RGB(byte[] byArray, byte[] byArray2, double[] dArray, double[] dArray2, int n15) {
        double d15;
        double d16;
        double d17;
        if (dArray2 == null) {
            d17 = byArray[n15] & 0xFF;
            d16 = (byArray[n15 + 1] & 0xFF) - 128;
            d15 = (byArray[n15 + 2] & 0xFF) - 128;
        } else {
            d17 = ((double)(byArray[n15] & 0xFF) - dArray2[0]) * 255.0 / (dArray2[1] - dArray2[0]);
            d16 = ((double)(byArray[n15 + 1] & 0xFF) - dArray2[2]) * 127.0 / (dArray2[3] - dArray2[2]);
            d15 = ((double)(byArray[n15 + 2] & 0xFF) - dArray2[4]) * 127.0 / (dArray2[5] - dArray2[4]);
        }
        double d18 = dArray[0];
        double d19 = dArray[1];
        double d25 = dArray[2];
        int n16 = (int)Math.round(d15 * (2.0 - 2.0 * d18) + d17);
        int n17 = (int)Math.round(d16 * (2.0 - 2.0 * d25) + d17);
        int n18 = (int)Math.round((d17 - d18 * (double)n16 - d25 * (double)n17) / d19);
        byArray2[n15] = YCbCrConverter.clamp(n16);
        byArray2[n15 + 2] = YCbCrConverter.clamp(n17);
        byArray2[n15 + 1] = YCbCrConverter.clamp(n18);
    }

    public static void convertJPEGYCbCr2RGB(byte[] byArray, byte[] byArray2, int n15) {
        int n16 = byArray[n15] & 0xFF;
        int n17 = byArray[n15 + 1] & 0xFF;
        int n18 = byArray[n15 + 2] & 0xFF;
        byArray2[n15] = YCbCrConverter.clamp(n16 + JPEG.Cr_R_LUT[n18]);
        byArray2[n15 + 1] = YCbCrConverter.clamp(n16 + (JPEG.Cb_G_LUT[n17] + JPEG.Cr_G_LUT[n18] >> 16));
        byArray2[n15 + 2] = YCbCrConverter.clamp(n16 + JPEG.Cb_B_LUT[n17]);
    }

    public static void convertRec601YCbCr2RGB(byte[] byArray, byte[] byArray2, int n15) {
        int n16 = byArray[n15] & 0xFF;
        int n17 = byArray[n15 + 1] & 0xFF;
        int n18 = byArray[n15 + 2] & 0xFF;
        byArray2[n15] = YCbCrConverter.clamp(ITU_R_601.Y_LUT[n16] + ITU_R_601.Cr_R_LUT[n18]);
        byArray2[n15 + 1] = YCbCrConverter.clamp(ITU_R_601.Y_LUT[n16] + (ITU_R_601.Cr_G_LUT[n18] + ITU_R_601.Cb_G_LUT[n17] >> 16));
        byArray2[n15 + 2] = YCbCrConverter.clamp(ITU_R_601.Y_LUT[n16] + ITU_R_601.Cb_B_LUT[n17]);
    }

    private static byte clamp(int n15) {
        return (byte)Math.max(0, Math.min(255, n15));
    }

    private static final class ITU_R_601 {
        private static final int[] Cr_R_LUT = new int[256];
        private static final int[] Cb_B_LUT = new int[256];
        private static final int[] Cr_G_LUT = new int[256];
        private static final int[] Cb_G_LUT = new int[256];
        private static final int[] Y_LUT = new int[256];

        private ITU_R_601() {
        }

        private static void buildYCCtoRGBtable() {
            if (ColorSpaces.DEBUG) {
                System.err.println("Building ITU-R REC.601 YCbCr conversion table");
            }
            int n15 = 0;
            int n16 = -128;
            while (n15 <= 255) {
                ITU_R_601.Cr_R_LUT[n15] = 104597 * n16 + 32768 >> 16;
                ITU_R_601.Cb_B_LUT[n15] = 132201 * n16 + 32768 >> 16;
                ITU_R_601.Cr_G_LUT[n15] = -53279 * n16;
                ITU_R_601.Cb_G_LUT[n15] = -25674 * n16 + 32768;
                ITU_R_601.Y_LUT[n15] = 76309 * (n15 - 16) + 32768 >> 16;
                ++n15;
                ++n16;
            }
        }

        static {
            ITU_R_601.buildYCCtoRGBtable();
        }
    }

    private static final class JPEG {
        private static final int[] Cr_R_LUT = new int[256];
        private static final int[] Cb_B_LUT = new int[256];
        private static final int[] Cr_G_LUT = new int[256];
        private static final int[] Cb_G_LUT = new int[256];

        private JPEG() {
        }

        private static void buildYCCtoRGBtable() {
            if (ColorSpaces.DEBUG) {
                System.err.println("Building JPEG YCbCr conversion table");
            }
            int n15 = 0;
            int n16 = -128;
            while (n15 <= 255) {
                JPEG.Cr_R_LUT[n15] = (int)(91881.972 * (double)n16 + 32768.0) >> 16;
                JPEG.Cb_B_LUT[n15] = (int)(116130.292 * (double)n16 + 32768.0) >> 16;
                JPEG.Cr_G_LUT[n15] = -46802 * n16;
                JPEG.Cb_G_LUT[n15] = -22554 * n16 + 32768;
                ++n15;
                ++n16;
            }
        }

        static {
            JPEG.buildYCCtoRGBtable();
        }
    }
}

