/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.lang.Validate;

public final class CIELabColorConverter {
    private final float[] whitePoint;

    public CIELabColorConverter(Illuminant illuminant) {
        this.whitePoint = Validate.notNull(illuminant, "illuminant").getWhitePoint();
    }

    private float clamp(float f15) {
        if (f15 < 0.0f) {
            return 0.0f;
        }
        if (f15 > 255.0f) {
            return 255.0f;
        }
        return f15;
    }

    public void toRGB(float f15, float f16, float f17, float[] fArray) {
        this.XYZtoRGB(this.LABtoXYZ(f15, f16, f17, fArray), fArray);
    }

    private float[] LABtoXYZ(float f15, float f16, float f17, float[] fArray) {
        float f18 = (f15 + 16.0f) / 116.0f;
        float f19 = f18 * f18 * f18;
        float f25 = f16 / 500.0f + f18;
        float f26 = f25 * f25 * f25;
        float f27 = f18 - f17 / 200.0f;
        float f28 = f27 * f27 * f27;
        f18 = f19 > 0.008856f ? f19 : (f18 - 0.13793103f) / 7.787f;
        f25 = f26 > 0.008856f ? f26 : (f25 - 0.13793103f) / 7.787f;
        f27 = f28 > 0.008856f ? f28 : (f27 - 0.13793103f) / 7.787f;
        fArray[0] = f25 * this.whitePoint[0];
        fArray[1] = f18 * this.whitePoint[1];
        fArray[2] = f27 * this.whitePoint[2];
        return fArray;
    }

    private float[] XYZtoRGB(float[] fArray, float[] fArray2) {
        return this.XYZtoRGB(fArray[0], fArray[1], fArray[2], fArray2);
    }

    private float[] XYZtoRGB(float f15, float f16, float f17, float[] fArray) {
        float f18 = f15 / 100.0f;
        float f19 = f16 / 100.0f;
        float f25 = f17 / 100.0f;
        float f26 = f18 * 3.2406f + f19 * -1.5372f + f25 * -0.4986f;
        float f27 = f18 * -0.9689f + f19 * 1.8758f + f25 * 0.0415f;
        float f28 = f18 * 0.0557f + f19 * -0.204f + f25 * 1.057f;
        f26 = f26 > 0.0031308f ? 1.055f * (float)CIELabColorConverter.pow(f26, 0.4166666666666667) - 0.055f : (f26 *= 12.92f);
        f27 = f27 > 0.0031308f ? 1.055f * (float)CIELabColorConverter.pow(f27, 0.4166666666666667) - 0.055f : (f27 *= 12.92f);
        f28 = f28 > 0.0031308f ? 1.055f * (float)CIELabColorConverter.pow(f28, 0.4166666666666667) - 0.055f : (f28 *= 12.92f);
        fArray[0] = this.clamp(f26 * 255.0f);
        fArray[1] = this.clamp(f27 * 255.0f);
        fArray[2] = this.clamp(f28 * 255.0f);
        return fArray;
    }

    static double pow(double d15, double d16) {
        long l15 = Double.doubleToLongBits(d15);
        long l16 = (long)(d16 * (double)(l15 - 4606921280493453312L)) + 4606921280493453312L;
        return Double.longBitsToDouble(l16);
    }

    public static enum Illuminant {
        D50(new float[]{96.4212f, 100.0f, 82.5188f}),
        D65(new float[]{95.0429f, 100.0f, 108.89f});

        private final float[] whitePoint;

        private Illuminant(float[] fArray) {
            this.whitePoint = Validate.isTrue(fArray != null && fArray.length == 3, fArray, "Bad white point definition: %s");
        }

        public float[] getWhitePoint() {
            return this.whitePoint;
        }
    }
}

