/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

class InverseColorMap {
    static final int QUANTBITS = 5;
    static final int TRUNCBITS = 3;
    static final int QUANTMASK_BLUE = 31;
    static final int QUANTMASK_GREEN = 992;
    static final int QUANTMASK_RED = 31744;
    static final int MAXQUANTVAL = 32;
    byte[] rgbMapByte;
    int[] rgbMapInt;
    int numColors;
    int maxColor;
    byte[] inverseRGB;
    int transparentIndex = -1;

    InverseColorMap(byte[] byArray) {
        this(byArray, -1);
    }

    InverseColorMap(int[] nArray) {
        this(nArray, -1);
    }

    InverseColorMap(byte[] byArray, int n15) {
        this.rgbMapByte = byArray;
        this.numColors = this.rgbMapByte.length / 4;
        this.transparentIndex = n15;
        this.inverseRGB = new byte[32768];
        this.initIRGB(new int[32768]);
    }

    InverseColorMap(int[] nArray, int n15) {
        this.rgbMapInt = nArray;
        this.numColors = this.rgbMapInt.length;
        this.transparentIndex = n15;
        this.inverseRGB = new byte[32768];
        this.initIRGB(new int[32768]);
    }

    void initIRGB(int[] nArray) {
        for (int i15 = 0; i15 < this.numColors; ++i15) {
            int n15;
            int n16;
            int n17;
            if (i15 == this.transparentIndex) continue;
            if (this.rgbMapByte != null) {
                n17 = this.rgbMapByte[i15 * 4] & 0xFF;
                n16 = this.rgbMapByte[i15 * 4 + 1] & 0xFF;
                n15 = this.rgbMapByte[i15 * 4 + 2] & 0xFF;
            } else if (this.rgbMapInt != null) {
                n17 = this.rgbMapInt[i15] >> 16 & 0xFF;
                n16 = this.rgbMapInt[i15] >> 8 & 0xFF;
                n15 = this.rgbMapInt[i15] & 0xFF;
            } else {
                throw new IllegalStateException("colormap == null");
            }
            int n18 = n17 - 4;
            int n19 = n16 - 4;
            int n25 = n15 - 4;
            n18 = n18 * n18 + n19 * n19 + n25 * n25;
            int n26 = 2 * (64 - (n17 << 3));
            int n27 = 2 * (64 - (n16 << 3));
            int n28 = 2 * (64 - (n15 << 3));
            int n29 = 0;
            int n35 = 0;
            int n36 = n26;
            while (n35 < 32) {
                int n37 = 0;
                n19 = n18;
                int n38 = n27;
                while (n37 < 32) {
                    int n39 = 0;
                    n25 = n19;
                    int n45 = n28;
                    while (n39 < 32) {
                        if (i15 == 0 || nArray[n29] > n25) {
                            nArray[n29] = n25;
                            this.inverseRGB[n29] = (byte)i15;
                        }
                        n25 += n45;
                        ++n39;
                        ++n29;
                        n45 += 128;
                    }
                    n19 += n38;
                    ++n37;
                    n38 += 128;
                }
                n18 += n36;
                ++n35;
                n36 += 128;
            }
        }
    }

    public final int getIndexNearest(int n15) {
        return this.inverseRGB[(n15 >> 9 & 0x7C00) + (n15 >> 6 & 0x3E0) + (n15 >> 3 & 0x1F)] & 0xFF;
    }

    public final int getIndexNearest(int n15, int n16, int n17) {
        return this.inverseRGB[(n15 << 7 & 0x7C00) + (n16 << 2 & 0x3E0) + (n17 >> 3 & 0x1F)] & 0xFF;
    }
}

