/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.ToNumberStrategy;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.NumberLimits;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public Double readNumber(JsonReader in4) throws IOException {
            return in4.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(JsonReader in4) throws IOException {
            return new LazilyParsedNumber(in4.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(JsonReader in4) throws IOException, JsonParseException {
            String value = in4.nextString();
            if (value.indexOf(46) >= 0) {
                return this.parseAsDouble(value, in4);
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e15) {
                return this.parseAsDouble(value, in4);
            }
        }

        private Number parseAsDouble(String value, JsonReader in4) throws IOException {
            try {
                Double d15 = Double.valueOf(value);
                if ((d15.isInfinite() || d15.isNaN()) && !in4.isLenient()) {
                    throw new MalformedJsonException("JSON forbids NaN and infinities: " + d15 + "; at path " + in4.getPreviousPath());
                }
                return d15;
            }
            catch (NumberFormatException e15) {
                throw new JsonParseException("Cannot parse " + value + "; at path " + in4.getPreviousPath(), e15);
            }
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(JsonReader in4) throws IOException {
            String value = in4.nextString();
            try {
                return NumberLimits.parseBigDecimal(value);
            }
            catch (NumberFormatException e15) {
                throw new JsonParseException("Cannot parse " + value + "; at path " + in4.getPreviousPath(), e15);
            }
        }
    };

}

