/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public final class Longs {
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;

    private Longs() {
    }

    @InlineMe(replacement="Long.hashCode(value)")
    public static int hashCode(long value) {
        return Long.hashCode(value);
    }

    @InlineMe(replacement="Long.compare(a, b)")
    public static int compare(long a15, long b15) {
        return Long.compare(a15, b15);
    }

    public static boolean contains(long[] array, long target) {
        for (long value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(long[] array, long target) {
        return Longs.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(long[] array, long target, int start, int end) {
        for (int i15 = start; i15 < end; ++i15) {
            if (array[i15] != target) continue;
            return i15;
        }
        return -1;
    }

    public static int indexOf(long[] array, long[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i15 = 0; i15 < array.length - target.length + 1; ++i15) {
            for (int j15 = 0; j15 < target.length; ++j15) {
                if (array[i15 + j15] != target[j15]) continue block0;
            }
            return i15;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long target) {
        return Longs.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(long[] array, long target, int start, int end) {
        for (int i15 = end - 1; i15 >= start; --i15) {
            if (array[i15] != target) continue;
            return i15;
        }
        return -1;
    }

    public static long min(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] >= min) continue;
            min = array[i15];
        }
        return min;
    }

    public static long max(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long max = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] <= max) continue;
            max = array[i15];
        }
        return max;
    }

    public static long constrainToRange(long value, long min, long max) {
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", min, max);
        return Math.min(Math.max(value, min), max);
    }

    public static long[] concat(long[] ... arrays) {
        long length = 0L;
        for (long[] array : arrays) {
            length += (long)array.length;
        }
        long[] result = new long[Longs.checkNoOverflow(length)];
        int pos = 0;
        for (long[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    private static int checkNoOverflow(long result) {
        Preconditions.checkArgument(result == (long)((int)result), "the total number of elements (%s) in the arrays must fit in an int", result);
        return (int)result;
    }

    public static byte[] toByteArray(long value) {
        byte[] result = new byte[8];
        for (int i15 = 7; i15 >= 0; --i15) {
            result[i15] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public static long fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 8, "array too small: %s < %s", bytes.length, 8);
        return Longs.fromBytes(bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]);
    }

    public static long fromBytes(byte b15, byte b25, byte b35, byte b45, byte b55, byte b65, byte b75, byte b85) {
        return ((long)b15 & 0xFFL) << 56 | ((long)b25 & 0xFFL) << 48 | ((long)b35 & 0xFFL) << 40 | ((long)b45 & 0xFFL) << 32 | ((long)b55 & 0xFFL) << 24 | ((long)b65 & 0xFFL) << 16 | ((long)b75 & 0xFFL) << 8 | (long)b85 & 0xFFL;
    }

    public static @Nullable Long tryParse(String string) {
        return Longs.tryParse(string, 10);
    }

    public static @Nullable Long tryParse(String string, int radix) {
        int digit;
        int index;
        if (Preconditions.checkNotNull(string).isEmpty()) {
            return null;
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix must be between MIN_RADIX and MAX_RADIX but was " + radix);
        }
        boolean negative = string.charAt(0) == '-';
        int n15 = index = negative ? 1 : 0;
        if (index == string.length()) {
            return null;
        }
        if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix) {
            return null;
        }
        long accum = -digit;
        long cap = Long.MIN_VALUE / (long)radix;
        while (index < string.length()) {
            if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix || accum < cap) {
                return null;
            }
            if ((accum *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    public static Converter<String, Long> stringConverter() {
        return LongConverter.INSTANCE;
    }

    public static long[] ensureCapacity(long[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Arrays.copyOf(array, minLength + padding) : array;
    }

    public static String join(String separator, long ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 10);
        builder.append(array[0]);
        for (int i15 = 1; i15 < array.length; ++i15) {
            builder.append(separator).append(array[i15]);
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(long[] array) {
        Preconditions.checkNotNull(array);
        Longs.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(long[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Longs.reverse(array, fromIndex, toIndex);
    }

    public static void reverse(long[] array) {
        Preconditions.checkNotNull(array);
        Longs.reverse(array, 0, array.length);
    }

    public static void reverse(long[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i15 = fromIndex;
        for (int j15 = toIndex - 1; i15 < j15; ++i15, --j15) {
            long tmp = array[i15];
            array[i15] = array[j15];
            array[j15] = tmp;
        }
    }

    public static void rotate(long[] array, int distance) {
        Longs.rotate(array, distance, 0, array.length);
    }

    public static void rotate(long[] array, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        if (array.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m15 = -distance % length;
        m15 = m15 < 0 ? m15 + length : m15;
        int newFirstIndex = m15 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Longs.reverse(array, fromIndex, newFirstIndex);
        Longs.reverse(array, newFirstIndex, toIndex);
        Longs.reverse(array, fromIndex, toIndex);
    }

    public static long[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof LongArrayAsList) {
            return ((LongArrayAsList)collection).toLongArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        long[] array = new long[len];
        for (int i15 = 0; i15 < len; ++i15) {
            array[i15] = ((Number)Preconditions.checkNotNull(boxedArray[i15])).longValue();
        }
        return array;
    }

    public static List<Long> asList(long ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(backingArray);
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        private AsciiDigits() {
        }

        static int digit(char c15) {
            return c15 < '\u0080' ? asciiDigits[c15] : -1;
        }

        static {
            int i15;
            byte[] result = new byte[128];
            Arrays.fill(result, (byte)-1);
            for (i15 = 0; i15 < 10; ++i15) {
                result[48 + i15] = (byte)i15;
            }
            for (i15 = 0; i15 < 26; ++i15) {
                result[65 + i15] = (byte)(10 + i15);
                result[97 + i15] = (byte)(10 + i15);
            }
            asciiDigits = result;
        }
    }

    private static final class LongConverter
    extends Converter<String, Long>
    implements Serializable {
        static final Converter<String, Long> INSTANCE = new LongConverter();
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 1L;

        private LongConverter() {
        }

        @Override
        protected Long doForward(String value) {
            return Long.decode(value);
        }

        @Override
        protected String doBackward(Long value) {
            return value.toString();
        }

        public String toString() {
            return "Longs.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i15 = 0; i15 < minLength; ++i15) {
                int result = Long.compare(left[i15], right[i15]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Longs.lexicographicalComparator()";
        }
    }

    private static final class LongArrayAsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        final long[] array;
        final int start;
        final int end;
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        LongArrayAsList(long[] array) {
            this(array, 0, array.length);
        }

        LongArrayAsList(long[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        public Spliterator.OfLong spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(@Nullable Object target) {
            return target instanceof Long && Longs.indexOf(this.array, (Long)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@Nullable Object target) {
            int i15;
            if (target instanceof Long && (i15 = Longs.indexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i15 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object target) {
            int i15;
            if (target instanceof Long && (i15 = Longs.lastIndexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i15 - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int index, Long element) {
            Preconditions.checkElementIndex(index, this.size());
            long oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList that = (LongArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i15 = 0; i15 < size; ++i15) {
                    if (this.array[this.start + i15] == that.array[that.start + i15]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i15 = this.start; i15 < this.end; ++i15) {
                result = 31 * result + Long.hashCode(this.array[i15]);
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 10);
            builder.append('[').append(this.array[this.start]);
            for (int i15 = this.start + 1; i15 < this.end; ++i15) {
                builder.append(", ").append(this.array[i15]);
            }
            return builder.append(']').toString();
        }

        long[] toLongArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }
}

