/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser.impl;

import java.util.logging.Logger;

final class CharacterDataParser {
    private static final Logger LOGGER = Logger.getLogger(CharacterDataParser.class.getName());
    private static final boolean DEBUG = false;
    private State state = State.SEGMENT_START;
    private StringBuilder buffer = new StringBuilder();
    private char[] data;
    private int begin;
    private int end;

    CharacterDataParser() {
    }

    public void append(char[] ch4, int offset, int length) {
        int segmentBreaks;
        if (length == 0) {
            return;
        }
        this.data = ch4;
        this.begin = offset;
        this.end = offset + length;
        if (CharacterDataParser.isSegmentBreak(this.data[this.begin])) {
            segmentBreaks = this.trimLeadingWhiteSpace();
            if (this.state == State.SEGMENT_BREAK) {
                ++segmentBreaks;
            }
            if (this.begin > offset && segmentBreaks > 1) {
                --this.begin;
                this.data[this.begin] = 32;
                if (this.state == State.CHARACTER || this.state == State.SEGMENT_BREAK) {
                    this.state = State.WHITESPACE_AFTER_CHAR;
                }
            }
        }
        segmentBreaks = this.trimTrailingWhiteSpace();
        if (this.end < offset + length) {
            this.data[this.end] = segmentBreaks > 0 ? 10 : 32;
            ++this.end;
        }
        if (this.begin >= this.end) {
            return;
        }
        this.buffer.ensureCapacity(this.buffer.length() + this.end - this.begin);
        this.appendData();
    }

    private void appendData() {
        int initialOffset = this.begin;
        while (this.begin < this.end) {
            char c15 = this.data[this.begin];
            boolean segmentBreak = CharacterDataParser.isSegmentBreak(c15);
            boolean whiteSpace = CharacterDataParser.isWhitespace(c15);
            if (!segmentBreak && !whiteSpace) {
                if (this.state == State.WHITESPACE_AFTER_CHAR || this.state.isVisualSpace && this.begin > initialOffset) {
                    this.buffer.append(' ');
                }
                this.state = State.CHARACTER;
                this.buffer.append(c15);
            } else if (whiteSpace) {
                switch (this.state.ordinal()) {
                    case 2: 
                    case 4: {
                        this.state = State.WHITESPACE_AFTER_CHAR;
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.state = State.WHITESPACE_AFTER_SEGMENT_BREAK;
                        break;
                    }
                }
            } else {
                this.state = State.SEGMENT_BREAK;
            }
            ++this.begin;
        }
    }

    public boolean canFlush(boolean dueToSegmentBreak) {
        if (this.state == State.SEGMENT_START) {
            return false;
        }
        return dueToSegmentBreak || this.buffer.length() > 0;
    }

    public char[] flush(boolean dueToSegmentBreak) {
        if (dueToSegmentBreak && this.state != State.CHARACTER) {
            this.buffer.append(' ');
        }
        if (dueToSegmentBreak) {
            this.state = State.SEGMENT_BREAK;
        }
        char[] ch4 = new char[this.buffer.length()];
        this.buffer.getChars(0, ch4.length, ch4, 0);
        this.buffer = new StringBuilder();
        return ch4;
    }

    private int trimLeadingWhiteSpace() {
        int segmentBreakCount = 0;
        while (this.begin < this.end) {
            if (CharacterDataParser.isSegmentBreak(this.data[this.begin])) {
                ++segmentBreakCount;
                ++this.begin;
                continue;
            }
            if (!CharacterDataParser.isWhitespace(this.data[this.begin])) break;
            ++this.begin;
        }
        return segmentBreakCount;
    }

    private int trimTrailingWhiteSpace() {
        int segmentBreakCount = 0;
        while (this.begin < this.end) {
            if (CharacterDataParser.isSegmentBreak(this.data[this.end - 1])) {
                ++segmentBreakCount;
                --this.end;
                continue;
            }
            if (!CharacterDataParser.isWhitespace(this.data[this.end - 1])) break;
            --this.end;
        }
        return segmentBreakCount;
    }

    private static boolean isSegmentBreak(char c15) {
        return c15 == '\n' || c15 == '\r';
    }

    private static boolean isWhitespace(char c15) {
        return c15 == ' ' || c15 == '\t';
    }

    private /* synthetic */ String lambda$flush$2(boolean dueToSegmentBreak) {
        return String.format("Flush segBreak=%s[%s]", dueToSegmentBreak, this.buffer);
    }

    private /* synthetic */ String lambda$append$1(char[] ch4) {
        return String.format("Portion: [%s]", new String(ch4, this.begin, this.end - this.begin).replace("\n", "\\n"));
    }

    private static /* synthetic */ String lambda$append$0(char[] ch4, int offset, int length) {
        return String.format("Append: [%s]", new String(ch4, offset, length).replace("\n", "\\n"));
    }

    private static enum State {
        SEGMENT_START(false),
        SEGMENT_BREAK(true),
        WHITESPACE_AFTER_CHAR(true),
        WHITESPACE_AFTER_SEGMENT_BREAK(true),
        CHARACTER(false);

        private final boolean isVisualSpace;

        private State(boolean isVisualSpace) {
            this.isVisualSpace = isVisualSpace;
        }
    }
}

