/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.paint.impl.jdk;

import com.github.weisj.jsvg.paint.impl.jdk.SVGMultipleGradientPaintContext;
import com.github.weisj.jsvg.paint.impl.jdk.SVGRadialGradientPaint;
import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

final class SVGRadialGradientPaintContext
extends SVGMultipleGradientPaintContext {
    private final boolean isSimpleFocus;
    private final boolean isNonCyclic;
    private final float centerX;
    private final float centerY;
    private float focusX;
    private float focusY;
    private final float radiusSq;
    private final float focusRadius;
    private final float focusRadiusSq;
    private final float constA;
    private final float constB;
    private final float gDeltaDelta;
    private final float trivial;
    private static final float FOCUS_CLAMP_DOWNSCALE = 0.99f;
    private static final int SQRT_LUT_SIZE = 2048;
    private static final float[] sqrtLookup = new float[2049];

    SVGRadialGradientPaintContext(@NotNull SVGRadialGradientPaint paint, @NotNull AffineTransform t15, float cx4, float cy4, float r15, float fx4, float fy4, float fr4, float @NotNull [] fractions, @NotNull @NotNull Color @NotNull [] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace) {
        super(paint, t15, fractions, colors, cycleMethod, colorSpace);
        this.centerX = cx4;
        this.centerY = cy4;
        this.focusX = fx4;
        this.focusY = fy4;
        this.isSimpleFocus = this.focusX == this.centerX && this.focusY == this.centerY && fr4 == 0.0f;
        this.isNonCyclic = cycleMethod == MultipleGradientPaint.CycleMethod.NO_CYCLE;
        this.radiusSq = r15 * r15;
        this.focusRadius = fr4;
        this.focusRadiusSq = fr4 * fr4;
        float dX2 = this.focusX - this.centerX;
        float dY2 = this.focusY - this.centerY;
        double distSq = dX2 * dX2 + dY2 * dY2;
        if (distSq > (double)(this.radiusSq * 0.99f)) {
            float scale = (float)Math.sqrt((double)(this.radiusSq * 0.99f) / distSq);
            this.focusX = this.centerX + (dX2 *= scale);
            this.focusY = this.centerY + (dY2 *= scale);
        }
        this.trivial = (float)Math.sqrt(this.radiusSq - dX2 * dX2);
        this.constA = this.a02 - this.centerX;
        this.constB = this.a12 - this.centerY;
        this.gDeltaDelta = 2.0f * (this.a00 * this.a00 + this.a10 * this.a10) / this.radiusSq;
    }

    @Override
    protected void fillRaster(int[] pixels, int off, int adjust, int x15, int y15, int w15, int h15) {
        if (this.isSimpleFocus && this.isNonCyclic && this.isSimpleLookup) {
            this.simpleNonCyclicFillRaster(pixels, off, adjust, x15, y15, w15, h15);
        } else {
            this.cyclicCircularGradientFillRaster(pixels, off, adjust, x15, y15, w15, h15);
        }
    }

    private void simpleNonCyclicFillRaster(int[] pixels, int off, int adjust, int x15, int y15, int w15, int h15) {
        float rowX = this.a00 * (float)x15 + this.a01 * (float)y15 + this.constA;
        float rowY = this.a10 * (float)x15 + this.a11 * (float)y15 + this.constB;
        float deltaDelta = this.gDeltaDelta;
        adjust += w15;
        int rgbclip = this.gradient[this.fastGradientArraySize];
        for (int j15 = 0; j15 < h15; ++j15) {
            int i15;
            float gRel = (rowX * rowX + rowY * rowY) / this.radiusSq;
            float gDelta = 2.0f * (this.a00 * rowX + this.a10 * rowY) / this.radiusSq + deltaDelta / 2.0f;
            for (i15 = 0; i15 < w15 && gRel >= 1.0f; ++i15) {
                pixels[off + i15] = rgbclip;
                gRel += gDelta;
                gDelta += deltaDelta;
            }
            while (i15 < w15 && gRel < 1.0f) {
                int gIndex;
                if (gRel <= 0.0f) {
                    gIndex = 0;
                } else {
                    float fIndex = gRel * 2048.0f;
                    int iIndex = (int)fIndex;
                    float s05 = sqrtLookup[iIndex];
                    float s15 = sqrtLookup[iIndex + 1] - s05;
                    fIndex = s05 + (fIndex - (float)iIndex) * s15;
                    gIndex = (int)(fIndex * (float)this.fastGradientArraySize);
                }
                pixels[off + i15] = this.gradient[gIndex];
                gRel += gDelta;
                gDelta += deltaDelta;
                ++i15;
            }
            while (i15 < w15) {
                pixels[off + i15] = rgbclip;
                ++i15;
            }
            off += adjust;
            rowX += this.a01;
            rowY += this.a11;
        }
    }

    private void cyclicCircularGradientFillRaster(int[] pixels, int off, int adjust, int x15, int y15, int w15, int h15) {
        double constC = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float constX = this.a00 * (float)x15 + this.a01 * (float)y15 + this.a02;
        float constY = this.a10 * (float)x15 + this.a11 * (float)y15 + this.a12;
        float precalc2 = 2.0f * this.centerY;
        float precalc3 = -2.0f * this.centerX;
        int indexer = off;
        int pixInc = w15 + adjust;
        for (int j15 = 0; j15 < h15; ++j15) {
            float userX = this.a01 * (float)j15 + constX;
            float userY = this.a11 * (float)j15 + constY;
            for (int i15 = 0; i15 < w15; ++i15) {
                int colorAtPoint;
                double solutionY;
                double solutionX;
                if (userX == this.focusX) {
                    solutionX = this.focusX;
                    solutionY = this.centerY;
                    solutionY += userY > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    float slope = (userY - this.focusY) / (userX - this.focusX);
                    float yIntercept = userY - slope * userX;
                    double a15 = slope * slope + 1.0f;
                    double b15 = precalc3 + -2.0f * slope * (this.centerY - yIntercept);
                    double c15 = constC + (double)(yIntercept * (yIntercept - precalc2));
                    float det = (float)Math.sqrt(b15 * b15 - 4.0 * a15 * c15);
                    solutionX = -b15;
                    solutionX += userX < this.focusX ? (double)(-det) : (double)det;
                    solutionY = (double)slope * (solutionX /= 2.0 * a15) + (double)yIntercept;
                }
                pixels[indexer + i15] = colorAtPoint = this.getColorAtPoint(userX, userY, (float)solutionX, (float)solutionY);
                userX += this.a00;
                userY += this.a10;
            }
            indexer += pixInc;
        }
    }

    private int getColorAtPoint(float userX, float userY, float solutionX, float solutionY) {
        float currentToFocusSq = this.getCurrentToFocusSq(userX, userY);
        if (currentToFocusSq <= this.focusRadiusSq) {
            return this.indexIntoGradientsArrays(0.0f);
        }
        return this.getColorAtPointOutsideFocusCircle(solutionX, solutionY, currentToFocusSq);
    }

    private float getCurrentToFocusSq(float x15, float y15) {
        float deltaXSq = x15 - this.focusX;
        deltaXSq *= deltaXSq;
        float deltaYSq = y15 - this.focusY;
        deltaYSq *= deltaYSq;
        return deltaXSq + deltaYSq;
    }

    private int getColorAtPointOutsideFocusCircle(float solutionX, float solutionY, float currentToFocusSq) {
        float intersectToFocusSq = this.getCurrentToFocusSq(solutionX, solutionY);
        float gradientPosition = this.computeGradientPosition(currentToFocusSq, intersectToFocusSq);
        return this.indexIntoGradientsArrays(gradientPosition);
    }

    private float computeGradientPosition(float currentToFocusSq, float intersectToFocusSq) {
        float gradientPosition;
        if (this.focusRadius > 0.0f) {
            float currentToFocus = (float)Math.sqrt(currentToFocusSq);
            float intersectToFocus = (float)Math.sqrt(intersectToFocusSq);
            gradientPosition = (currentToFocus - this.focusRadius) / (intersectToFocus - this.focusRadius);
        } else {
            gradientPosition = (float)Math.sqrt(currentToFocusSq / intersectToFocusSq);
        }
        return gradientPosition;
    }

    static {
        for (int i15 = 0; i15 < sqrtLookup.length; ++i15) {
            SVGRadialGradientPaintContext.sqrtLookup[i15] = (float)Math.sqrt((float)i15 / 2048.0f);
        }
    }
}

