/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.VectorEffect;
import com.github.weisj.jsvg.attributes.font.AttributeFontSpec;
import com.github.weisj.jsvg.attributes.font.FontParser;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.attributes.text.LengthAdjust;
import com.github.weisj.jsvg.attributes.text.TextAnchor;
import com.github.weisj.jsvg.attributes.value.PercentageDimension;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.container.BaseContainerNode;
import com.github.weisj.jsvg.nodes.prototype.HasContext;
import com.github.weisj.jsvg.nodes.prototype.HasShape;
import com.github.weisj.jsvg.nodes.prototype.HasVectorEffects;
import com.github.weisj.jsvg.nodes.prototype.Renderable;
import com.github.weisj.jsvg.nodes.prototype.impl.HasContextImpl;
import com.github.weisj.jsvg.nodes.text.GlyphAdvancement;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.GlyphRenderer;
import com.github.weisj.jsvg.nodes.text.MutableGlyphRun;
import com.github.weisj.jsvg.nodes.text.NullTextOutput;
import com.github.weisj.jsvg.nodes.text.StringTextSegment;
import com.github.weisj.jsvg.nodes.text.TextMetrics;
import com.github.weisj.jsvg.nodes.text.TextSegment;
import com.github.weisj.jsvg.parser.impl.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.impl.NodeRenderer;
import com.github.weisj.jsvg.renderer.impl.context.RenderContextAccessor;
import com.github.weisj.jsvg.renderer.output.Output;
import com.github.weisj.jsvg.renderer.output.TextOutput;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TextContainer
extends BaseContainerNode<TextSegment>
implements TextSegment.RenderableSegment,
HasShape,
HasContext.ByDelegate,
HasVectorEffects,
Renderable {
    private final List<@NotNull TextSegment> segments = new ArrayList<TextSegment>();
    protected AttributeFontSpec fontSpec;
    protected LengthAdjust lengthAdjust;
    protected Length textLength;
    private boolean isVisible;
    private HasContext context;
    private Set<VectorEffect> vectorEffects;

    TextContainer() {
    }

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.fontSpec = FontParser.parseFontSpec(attributeNode);
        this.lengthAdjust = attributeNode.getEnum("lengthAdjust", LengthAdjust.Spacing);
        this.textLength = attributeNode.getLength("textLength", PercentageDimension.NONE, Length.UNSPECIFIED);
        if (this.textLength.raw() < 0.0f) {
            this.textLength = Length.UNSPECIFIED;
        }
        this.isVisible = this.parseIsVisible(attributeNode);
        this.context = HasContextImpl.parse(attributeNode);
        this.vectorEffects = VectorEffect.parse(attributeNode);
    }

    @Override
    @NotNull
    public Set<VectorEffect> vectorEffects() {
        return this.vectorEffects;
    }

    @Override
    @NotNull
    public HasContext contextDelegate() {
        return this.context;
    }

    @NotNull
    @NotNull List<@NotNull TextSegment> segments() {
        return this.segments;
    }

    @Override
    protected boolean acceptChild(@Nullable String id5, @NotNull SVGNode node) {
        return node instanceof TextSegment;
    }

    @Override
    protected void doAdd(@NotNull SVGNode node) {
        this.segments.add((TextSegment)((Object)node));
    }

    @Override
    public final void addContent(char[] content) {
        if (content.length == 0) {
            return;
        }
        this.segments.add(new StringTextSegment(this, this.segments.size(), content));
    }

    @Override
    public List<? extends @NotNull TextSegment> children() {
        return this.segments;
    }

    @NotNull
    abstract Shape glyphShape(@NotNull RenderContext var1);

    @Override
    @NotNull
    public final Shape untransformedElementShape(@NotNull RenderContext context, HasShape.Box box) {
        Shape shape = this.glyphShape(context);
        switch (box) {
            case BoundingBox: {
                return shape;
            }
            case StrokeBox: {
                Area area = new Area(shape);
                area.add(new Area(context.stroke(1.0f).createStrokedShape(shape)));
                return area;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)box));
    }

    protected abstract GlyphCursor createLocalCursor(@NotNull RenderContext var1, @NotNull GlyphCursor var2);

    protected abstract void cleanUpLocalCursor(@NotNull GlyphCursor var1, @NotNull GlyphCursor var2);

    protected final void renderSegment(@NotNull GlyphCursor cursor, @NotNull RenderContext context, @NotNull Output output) {
        TextOutput textOutput = output.textOutput();
        textOutput.beginText();
        this.prepareSegmentForRendering(cursor, context, textOutput);
        double offset = this.textAnchorOffset(RenderContextAccessor.instance().fontRenderContext(context).textAnchor(), cursor);
        context.translate(output, -offset, 0.0);
        this.renderSegmentWithoutLayout(cursor, context, output);
        textOutput.endText();
    }

    private double textAnchorOffset(@NotNull TextAnchor textAnchor, @NotNull GlyphCursor glyphCursor) {
        switch (textAnchor) {
            default: {
                return 0.0;
            }
            case Middle: {
                return glyphCursor.completeGlyphRunMetrics.layoutBounds.getWidth() / 2.0;
            }
            case End: 
        }
        return glyphCursor.completeGlyphRunMetrics.layoutBounds.getWidth();
    }

    void forEachSegment(@NotNull RenderContext context, @NotNull BiConsumer<StringTextSegment, RenderContext> onStringTextSegment, @NotNull BiConsumer<TextSegment.RenderableSegment, RenderContext> onRenderableSegment) {
        for (TextSegment textSegment : this.children()) {
            RenderContext currentContext;
            if (!textSegment.isValid(currentContext = context)) continue;
            if (textSegment instanceof Renderable) {
                currentContext = NodeRenderer.setupRenderContext(textSegment, context);
            }
            if (textSegment instanceof StringTextSegment) {
                onStringTextSegment.accept((StringTextSegment)textSegment, currentContext);
                continue;
            }
            if (textSegment instanceof TextSegment.RenderableSegment) {
                onRenderableSegment.accept((TextSegment.RenderableSegment)textSegment, currentContext);
                continue;
            }
            throw new IllegalStateException("Unexpected segment " + textSegment);
        }
    }

    @Override
    @NotNull
    public TextMetrics computeTextMetrics(@NotNull RenderContext context, @NotNull TextSegment.RenderableSegment.UseTextLengthForCalculation flag) {
        if (flag == TextSegment.RenderableSegment.UseTextLengthForCalculation.YES && this.hasFixedLength()) {
            return new TextMetrics(0.0, 0.0, 0, this.textLength.resolve(context.measureContext()), 0);
        }
        RenderContextAccessor.Accessor accessor = RenderContextAccessor.instance();
        SVGFont font = accessor.font(context);
        float letterSpacing = accessor.fontRenderContext(context).letterSpacing().resolve(context.measureContext());
        IntermediateTextMetrics metrics = new IntermediateTextMetrics();
        int index = 0;
        for (TextSegment textSegment : this.children()) {
            RenderContext currentContext = context;
            if (textSegment instanceof Renderable) {
                currentContext = NodeRenderer.setupRenderContext(textSegment, context);
            }
            if (textSegment instanceof StringTextSegment) {
                StringTextSegment stringTextSegment = (StringTextSegment)textSegment;
                this.accumulateSegmentMetrics(metrics, stringTextSegment, font, letterSpacing, index);
            } else if (textSegment instanceof TextSegment.RenderableSegment) {
                this.accumulateRenderableSegmentMetrics((TextSegment.RenderableSegment)textSegment, metrics, currentContext);
            } else {
                throw new IllegalStateException("Unexpected segment " + textSegment);
            }
            ++index;
        }
        return new TextMetrics(metrics.letterSpacingLength, metrics.glyphLength, metrics.glyphCount, metrics.fixedGlyphLength, metrics.controllableLetterSpacingCount);
    }

    private void accumulateRenderableSegmentMetrics(@NotNull TextSegment.RenderableSegment segment, @NotNull IntermediateTextMetrics metrics, @NotNull RenderContext currentContext) {
        TextMetrics textMetrics = segment.computeTextMetrics(currentContext, TextSegment.RenderableSegment.UseTextLengthForCalculation.YES);
        metrics.letterSpacingLength += textMetrics.letterSpacingLength();
        metrics.glyphLength += textMetrics.glyphLength();
        metrics.glyphCount += textMetrics.glyphCount();
        metrics.fixedGlyphLength += textMetrics.fixedGlyphLength();
        metrics.controllableLetterSpacingCount += textMetrics.controllableLetterSpacingCount();
    }

    private void accumulateSegmentMetrics(@NotNull IntermediateTextMetrics metrics, @NotNull StringTextSegment segment, @NotNull SVGFont font, float letterSpacing, int index) {
        int glyphCount = segment.codepoints().size();
        boolean lastSegment = index == this.children().size() - 1;
        int whiteSpaceCount = lastSegment ? glyphCount - 1 : glyphCount;
        metrics.glyphCount += glyphCount;
        metrics.letterSpacingLength += (double)((float)whiteSpaceCount * letterSpacing);
        metrics.controllableLetterSpacingCount += whiteSpaceCount;
        for (String codepoint : segment.codepoints()) {
            metrics.glyphLength += (double)font.codepointGlyph(codepoint).advance();
        }
    }

    @Override
    public boolean hasFixedLength() {
        return this.textLength.isSpecified();
    }

    @Override
    public void renderSegmentWithoutLayout(@NotNull GlyphCursor cursor, @NotNull RenderContext context, @NotNull Output output) {
        this.forEachSegment(context, (segment, ctx) -> {
            if (!this.isVisible((RenderContext)ctx)) {
                return;
            }
            GlyphRenderer.renderGlyphRun(output, RenderContextAccessor.instance().paintOrder(context), this.vectorEffects(), segment);
        }, (segment, ctx) -> segment.renderSegmentWithoutLayout(cursor, (RenderContext)ctx, output));
    }

    @Override
    public void prepareSegmentForRendering(@NotNull GlyphCursor cursor, @NotNull RenderContext context, @NotNull TextOutput textOutput) {
        SVGFont font = RenderContextAccessor.instance().font(context);
        GlyphCursor localCursor = this.createLocalCursor(context, cursor);
        localCursor.setAdvancement(this.localGlyphAdvancement(context, cursor));
        this.forEachSegment(context, (segment, ctx) -> GlyphRenderer.prepareGlyphRun(segment, localCursor, font, ctx, textOutput), (segment, ctx) -> segment.prepareSegmentForRendering(localCursor, (RenderContext)ctx, textOutput));
        this.cleanUpLocalCursor(cursor, localCursor);
    }

    @Override
    public void appendTextShape(@NotNull GlyphCursor cursor, @NotNull MutableGlyphRun glyphRun, @NotNull RenderContext context) {
        SVGFont font = RenderContextAccessor.instance().font(context);
        GlyphCursor localCursor = this.createLocalCursor(context, cursor);
        localCursor.setAdvancement(this.localGlyphAdvancement(context, cursor));
        this.forEachSegment(context, (segment, ctx) -> glyphRun.append(GlyphRenderer.layoutGlyphRun(segment, localCursor, font, ctx, NullTextOutput.INSTANCE)), (segment, ctx) -> segment.appendTextShape(localCursor, glyphRun, (RenderContext)ctx));
        this.cleanUpLocalCursor(cursor, localCursor);
    }

    @NotNull
    private GlyphAdvancement localGlyphAdvancement(@NotNull RenderContext context, @NotNull GlyphCursor cursor) {
        if (this.hasFixedLength()) {
            return new GlyphAdvancement(this.computeTextMetrics(context, TextSegment.RenderableSegment.UseTextLengthForCalculation.NO), this.textLength.resolve(context.measureContext()), this.lengthAdjust);
        }
        return cursor.advancement();
    }

    @Override
    @NotNull
    public Rectangle2D untransformedElementBounds(@NotNull RenderContext context, HasShape.Box box) {
        return this.untransformedElementShape(context, box).getBounds2D();
    }

    @Override
    public boolean isVisible(@NotNull RenderContext context) {
        return this.isVisible;
    }

    private static final class IntermediateTextMetrics {
        double letterSpacingLength = 0.0;
        double glyphLength = 0.0;
        double fixedGlyphLength = 0.0;
        int glyphCount = 0;
        int controllableLetterSpacingCount = 0;

        private IntermediateTextMetrics() {
        }
    }
}

